/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaDocTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.LocaleSensitiveSpellDictionary;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set fgLocalesWithInstalledDictionaries;
    private Set fGlobalDictionaries = new HashSet();
    private ISpellChecker fChecker = null;
    private Map fLocaleDictionaries = new HashMap();
    private ISpellDictionary fUserDictionary = null;

    public static Set getLocalesWithInstalledDictionaries() {
        String[] fileNames;
        URL location;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            location = SpellCheckEngine.getDictionaryLocation();
            if (location == null) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (MalformedURLException ex) {
            JavaPlugin.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            URL url = FileLocator.toFileURL((URL)location);
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
            fileNames = file.list();
            if (fileNames == null) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet();
        int fileNameCount = fileNames.length;
        int i = 0;
        while (i < fileNameCount) {
            String fileName = fileNames[i];
            int localeEnd = fileName.indexOf(".dictionary");
            if (localeEnd > 1) {
                String localeName = fileName.substring(0, localeEnd);
                int languageEnd = localeName.indexOf(95);
                if (languageEnd == -1) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName));
                } else if (languageEnd == 2 && localeName.length() == 5) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3)));
                } else if (localeName.length() > 6 && localeName.charAt(5) == '_') {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6)));
                }
            }
            ++i;
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (dictionary != null) {
            return dictionary;
        }
        String language = locale.getLanguage();
        Iterator iter = this.fLocaleDictionaries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Locale dictLocale = (Locale)entry.getKey();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return (ISpellDictionary)entry.getValue();
        }
        return null;
    }

    public static Locale findClosestLocale(Locale locale) {
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        Iterator iter = SpellCheckEngine.getLocalesWithInstalledDictionaries().iterator();
        while (iter.hasNext()) {
            Locale dictLocale = (Locale)iter.next();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return dictLocale;
        }
        Locale defaultLocale = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(defaultLocale)) {
            return defaultLocale;
        }
        return null;
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static final synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        this.fGlobalDictionaries.add(new JavaDocTagDictionary());
        try {
            Locale locale = null;
            URL location = SpellCheckEngine.getDictionaryLocation();
            Iterator iterator = SpellCheckEngine.getLocalesWithInstalledDictionaries().iterator();
            while (iterator.hasNext()) {
                locale = (Locale)iterator.next();
                this.fLocaleDictionaries.put(locale, new LocaleSensitiveSpellDictionary(locale, location));
            }
        }
        catch (MalformedURLException malformedURLException) {}
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        if (this.fGlobalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        Locale locale = this.getCurrentLocale(store);
        if (this.fUserDictionary == null && "".equals(locale.toString())) {
            return null;
        }
        if (this.fChecker != null && this.fChecker.getLocale().equals(locale)) {
            return this.fChecker;
        }
        this.resetSpellChecker();
        this.fChecker = new DefaultSpellChecker(store, locale);
        this.resetUserDictionary();
        Iterator iterator = this.fGlobalDictionaries.iterator();
        while (iterator.hasNext()) {
            ISpellDictionary dictionary = (ISpellDictionary)iterator.next();
            this.fChecker.addDictionary(dictionary);
        }
        ISpellDictionary dictionary = this.findDictionary(this.fChecker.getLocale());
        if (dictionary != null) {
            this.fChecker.addDictionary(dictionary);
        }
        return this.fChecker;
    }

    private Locale getCurrentLocale(IPreferenceStore store) {
        return SpellCheckEngine.convertToLocale(store.getString("spelling_locale"));
    }

    public static Locale convertToLocale(String locale) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return new Locale("");
    }

    public final synchronized Locale getLocale() {
        if (this.fChecker == null) {
            return null;
        }
        return this.fChecker.getLocale();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("spelling_locale")) {
            this.resetSpellChecker();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary")) {
            this.resetUserDictionary();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary_encoding")) {
            this.resetUserDictionary();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void resetUserDictionary() {
        IPreferenceStore store;
        String filePath;
        if (this.fChecker == null) {
            return;
        }
        if (this.fUserDictionary != null) {
            this.fChecker.removeDictionary(this.fUserDictionary);
            this.fUserDictionary.unload();
            this.fUserDictionary = null;
        }
        if ((filePath = (store = JavaPlugin.getDefault().getPreferenceStore()).getString("spelling_user_dictionary")).length() <= 0) return;
        try {
            File file = new File(filePath);
            if (!file.exists() && !file.createNewFile()) {
                return;
            }
            URL url = new URL("file", null, filePath);
            InputStream stream = url.openStream();
            if (stream == null) return;
            try {
                this.fUserDictionary = new PersistentSpellDictionary(url);
                this.fChecker.addDictionary(this.fUserDictionary);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                stream.close();
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        catch (IOException iOException) {}
    }

    public final synchronized void registerGlobalDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        this.resetSpellChecker();
    }

    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        this.resetSpellChecker();
    }

    public final synchronized void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ISpellDictionary dictionary = null;
        Iterator<Object> iterator = this.fGlobalDictionaries.iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        this.fGlobalDictionaries = null;
        iterator = this.fLocaleDictionaries.values().iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        this.fLocaleDictionaries = null;
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary dictionary;
        if (this.fChecker != null && (dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(this.fChecker.getLocale())) != null) {
            dictionary.unload();
        }
        this.fChecker = null;
    }

    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        dictionary.unload();
        this.resetSpellChecker();
    }
}

