/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class BindingLabelProvider
extends LabelProvider {
    public static final long DEFAULT_TEXTFLAGS = JavaElementLabels.ALL_DEFAULT;
    public static final int DEFAULT_IMAGEFLAGS = 1;
    private final long fTextFlags;
    private final int fImageFlags;
    private ImageDescriptorRegistry fRegistry;

    private static int getAdornmentFlags(IBinding binding, int flags) {
        int modifiers;
        int adornments = 0;
        if (binding instanceof IMethodBinding && ((IMethodBinding)binding).isConstructor()) {
            adornments |= 0x200;
        }
        if (Modifier.isAbstract((int)(modifiers = binding.getModifiers()))) {
            adornments |= 1;
        }
        if (Modifier.isFinal((int)modifiers)) {
            adornments |= 2;
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            adornments |= 4;
        }
        if (Modifier.isStatic((int)modifiers)) {
            adornments |= 8;
        }
        if (binding.isDeprecated()) {
            adornments |= 0x400;
        }
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            if (Modifier.isTransient((int)modifiers)) {
                adornments |= 0x1000;
            }
            if (Modifier.isVolatile((int)modifiers)) {
                adornments |= 0x800;
            }
        }
        return adornments;
    }

    private static ImageDescriptor getBaseImageDescriptor(IBinding binding, int flags) {
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            if (typeBinding.isArray()) {
                typeBinding = typeBinding.getElementType();
            }
            if (typeBinding.isCapture()) {
                typeBinding.getWildcard();
            }
            return BindingLabelProvider.getTypeImageDescriptor(typeBinding.getDeclaringClass() != null, typeBinding, flags);
        }
        if (binding instanceof IMethodBinding) {
            ITypeBinding type = ((IMethodBinding)binding).getDeclaringClass();
            int modifiers = binding.getModifiers();
            if (type.isEnum() && !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) && !Modifier.isPrivate((int)modifiers) && ((IMethodBinding)binding).isConstructor()) {
                return JavaPluginImages.DESC_MISC_PRIVATE;
            }
            return BindingLabelProvider.getMethodImageDescriptor(binding.getModifiers());
        }
        if (binding instanceof IVariableBinding) {
            return BindingLabelProvider.getFieldImageDescriptor((IVariableBinding)binding);
        }
        return JavaPluginImages.DESC_OBJS_UNKNOWN;
    }

    private static ImageDescriptor getClassImageDescriptor(int modifiers) {
        if (Modifier.isPublic((int)modifiers) || Modifier.isProtected((int)modifiers) || Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getFieldImageDescriptor(IVariableBinding binding) {
        int modifiers = binding.getModifiers();
        if (Modifier.isPublic((int)modifiers) || binding.isEnumConstant()) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    private static void getFieldLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding declaringClass;
        if ((flags & 0x8000L) != 0L && !binding.isEnumConstant()) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L && !binding.isEnumConstant()) {
            buffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x20000L) != 0L && (declaringClass = binding.getDeclaringClass()) != null) {
            buffer.append(JavaElementLabels.CONCAT_STRING);
            BindingLabelProvider.getTypeLabel(declaringClass, 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static void getLocalVariableLabel(IVariableBinding binding, long flags, StringBuffer buffer) {
        IMethodBinding declaringMethod;
        if ((flags & 0x8000L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x10000L) != 0L && (declaringMethod = binding.getDeclaringMethod()) != null) {
            BindingLabelProvider.getMethodLabel(declaringMethod, flags, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 0x4000L) != 0L) {
            buffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(binding.getType(), flags & 0x200000L, buffer);
        }
    }

    private static ImageDescriptor getInnerClassImageDescriptor(int modifiers) {
        if (Modifier.isPublic((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(int modifiers) {
        if (Modifier.isPublic((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int modifiers) {
        if (Modifier.isPublic((int)modifiers) || Modifier.isProtected((int)modifiers) || Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getMethodImageDescriptor(int modifiers) {
        if (Modifier.isPublic((int)modifiers)) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    private static void appendDimensions(int dim, StringBuffer buffer) {
        int i = 0;
        while (i < dim) {
            buffer.append('[').append(']');
            ++i;
        }
    }

    private static void getMethodLabel(IMethodBinding binding, long flags, StringBuffer buffer) {
        ITypeBinding[] exceptions;
        int index;
        ITypeBinding[] typeArguments;
        ITypeBinding[] typeParameters;
        if ((flags & 4L) != 0L && binding.isGenericMethod() && (typeParameters = binding.getTypeParameters()).length > 0) {
            BindingLabelProvider.getTypeParametersLabel(typeParameters, flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x40L) != 0L && !binding.isConstructor()) {
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
            buffer.append(' ');
        }
        if ((flags & 0x80L) != 0L) {
            BindingLabelProvider.getTypeLabel(binding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
            buffer.append('.');
        }
        buffer.append(binding.getName());
        if ((flags & 8L) != 0L && binding.isParameterizedMethod() && (typeArguments = binding.getTypeArguments()).length > 0) {
            buffer.append(' ');
            BindingLabelProvider.getTypeArgumentsLabel(typeArguments, flags & 0x200000L, buffer);
        }
        buffer.append('(');
        if ((flags & 1L | 2L) != 0L) {
            ITypeBinding[] parameters;
            ITypeBinding[] iTypeBindingArray = parameters = (flags & 1L) != 0L ? binding.getParameterTypes() : null;
            if (parameters != null) {
                index = 0;
                while (index < parameters.length) {
                    if (index > 0) {
                        buffer.append(JavaElementLabels.COMMA_STRING);
                    }
                    ITypeBinding paramType = parameters[index];
                    if (binding.isVarargs() && index == parameters.length - 1) {
                        BindingLabelProvider.getTypeLabel(paramType.getElementType(), flags & 0x200000L, buffer);
                        BindingLabelProvider.appendDimensions(paramType.getDimensions() - 1, buffer);
                        buffer.append("...");
                    } else {
                        BindingLabelProvider.getTypeLabel(paramType, flags & 0x200000L, buffer);
                    }
                    ++index;
                }
            }
        } else if (binding.getParameterTypes().length > 0) {
            buffer.append("...");
        }
        buffer.append(')');
        if ((flags & 0x10L) != 0L && (exceptions = binding.getExceptionTypes()).length > 0) {
            buffer.append(" throws ");
            index = 0;
            while (index < exceptions.length) {
                if (index > 0) {
                    buffer.append(JavaElementLabels.COMMA_STRING);
                }
                BindingLabelProvider.getTypeLabel(exceptions[index], flags & 0x200000L, buffer);
                ++index;
            }
        }
        if ((flags & 8L) != 0L && binding.isGenericMethod() && (typeParameters = binding.getTypeParameters()).length > 0) {
            buffer.append(' ');
            BindingLabelProvider.getTypeParametersLabel(typeParameters, flags & 0x200000L, buffer);
        }
        if ((flags & 0x20L) != 0L && !binding.isConstructor()) {
            buffer.append(JavaElementLabels.DECL_STRING);
            BindingLabelProvider.getTypeLabel(binding.getReturnType(), flags & 0x200000L, buffer);
        }
        if ((flags & 0x100L) != 0L) {
            buffer.append(JavaElementLabels.CONCAT_STRING);
            BindingLabelProvider.getTypeLabel(binding.getDeclaringClass(), 0x40000L | flags & 0x2000000000L, buffer);
        }
    }

    private static ImageDescriptor getTypeImageDescriptor(boolean inner, ITypeBinding binding, int flags) {
        if (binding.isEnum()) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        if (binding.isAnnotation()) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        if (binding.isInterface()) {
            if ((flags & 4) != 0) {
                return JavaPluginImages.DESC_OBJS_INTERFACEALT;
            }
            if (inner) {
                return BindingLabelProvider.getInnerInterfaceImageDescriptor(binding.getModifiers());
            }
            return BindingLabelProvider.getInterfaceImageDescriptor(binding.getModifiers());
        }
        if (binding.isClass()) {
            if ((flags & 4) != 0) {
                return JavaPluginImages.DESC_OBJS_CLASSALT;
            }
            if (inner) {
                return BindingLabelProvider.getInnerClassImageDescriptor(binding.getModifiers());
            }
            return BindingLabelProvider.getClassImageDescriptor(binding.getModifiers());
        }
        if (binding.isTypeVariable()) {
            return JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
        }
        return null;
    }

    private static void getTypeLabel(ITypeBinding binding, long flags, StringBuffer buffer) {
        IPackageBinding pack;
        if ((flags & 0x40000L) != 0L && (pack = binding.getPackage()) != null && !pack.isUnnamed()) {
            buffer.append(pack.getName());
            buffer.append('.');
        }
        if ((flags & 0xC0000L) != 0L) {
            IMethodBinding declaringMethod;
            ITypeBinding declaring = binding.getDeclaringClass();
            if (declaring != null) {
                BindingLabelProvider.getTypeLabel(declaring, 0x80000L | flags & 0x2000000000L, buffer);
                buffer.append('.');
            }
            if ((declaringMethod = binding.getDeclaringMethod()) != null) {
                BindingLabelProvider.getMethodLabel(declaringMethod, 0L, buffer);
                buffer.append('.');
            }
        }
        if (binding.isCapture()) {
            BindingLabelProvider.getTypeLabel(binding.getWildcard(), flags & 0x200000L, buffer);
        } else if (binding.isWildcardType()) {
            buffer.append('?');
            ITypeBinding bound = binding.getBound();
            if (bound != null) {
                if (binding.isUpperbound()) {
                    buffer.append(" extends ");
                } else {
                    buffer.append(" super ");
                }
                BindingLabelProvider.getTypeLabel(bound, flags & 0x200000L, buffer);
            }
        } else if (binding.isArray()) {
            BindingLabelProvider.getTypeLabel(binding.getElementType(), flags & 0x200000L, buffer);
            BindingLabelProvider.appendDimensions(binding.getDimensions(), buffer);
        } else {
            String name = binding.getTypeDeclaration().getName();
            if (name.length() == 0) {
                if (binding.isEnum()) {
                    buffer.append("{...}");
                } else if (binding.isAnonymous()) {
                    ITypeBinding[] superInterfaces = binding.getInterfaces();
                    ITypeBinding baseType = superInterfaces.length > 0 ? superInterfaces[0] : binding.getSuperclass();
                    if (baseType != null) {
                        StringBuffer anonymBaseType = new StringBuffer();
                        BindingLabelProvider.getTypeLabel(baseType, flags & 0x200000L, anonymBaseType);
                        buffer.append(Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, anonymBaseType.toString()));
                    } else {
                        buffer.append(JavaUIMessages.JavaElementLabels_anonym);
                    }
                } else {
                    buffer.append("UNKNOWN");
                }
            } else {
                buffer.append(name);
            }
            if ((flags & 0x200000L) != 0L) {
                if (binding.isGenericType()) {
                    BindingLabelProvider.getTypeParametersLabel(binding.getTypeParameters(), flags, buffer);
                } else if (binding.isParameterizedType()) {
                    BindingLabelProvider.getTypeArgumentsLabel(binding.getTypeArguments(), flags, buffer);
                }
            }
        }
        if ((flags & 0x100000L) != 0L) {
            IMethodBinding declaringMethod = binding.getDeclaringMethod();
            ITypeBinding declaringType = binding.getDeclaringClass();
            if (declaringMethod != null) {
                buffer.append(JavaElementLabels.CONCAT_STRING);
                BindingLabelProvider.getMethodLabel(declaringMethod, 0x40000L | flags & 0x2000000000L, buffer);
            } else if (declaringType != null) {
                buffer.append(JavaElementLabels.CONCAT_STRING);
                BindingLabelProvider.getTypeLabel(declaringType, 0x40000L | flags & 0x2000000000L, buffer);
            } else {
                IPackageBinding pack2 = binding.getPackage();
                if (pack2 != null && !pack2.isUnnamed()) {
                    buffer.append(JavaElementLabels.CONCAT_STRING);
                    buffer.append(pack2.getName());
                }
            }
        }
    }

    private static void getTypeArgumentsLabel(ITypeBinding[] typeArgs, long flags, StringBuffer buf) {
        if (typeArgs.length > 0) {
            buf.append('<');
            int i = 0;
            while (i < typeArgs.length) {
                if (i > 0) {
                    buf.append(JavaElementLabels.COMMA_STRING);
                }
                BindingLabelProvider.getTypeLabel(typeArgs[i], flags & 0x200000L, buf);
                ++i;
            }
            buf.append('>');
        }
    }

    private static void getTypeParametersLabel(ITypeBinding[] typeParameters, long flags, StringBuffer buffer) {
        if (typeParameters.length > 0) {
            buffer.append('<');
            int index = 0;
            while (index < typeParameters.length) {
                if (index > 0) {
                    buffer.append(JavaElementLabels.COMMA_STRING);
                }
                buffer.append(typeParameters[index].getName());
                ++index;
            }
            buffer.append('>');
        }
    }

    public static String getBindingLabel(IBinding binding, long flags) {
        StringBuffer buffer = new StringBuffer(60);
        if (binding instanceof ITypeBinding) {
            BindingLabelProvider.getTypeLabel((ITypeBinding)binding, flags, buffer);
        } else if (binding instanceof IMethodBinding) {
            BindingLabelProvider.getMethodLabel((IMethodBinding)binding, flags, buffer);
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (variable.isField()) {
                BindingLabelProvider.getFieldLabel(variable, flags, buffer);
            } else {
                BindingLabelProvider.getLocalVariableLabel(variable, flags, buffer);
            }
        }
        return buffer.toString();
    }

    public static ImageDescriptor getBindingImageDescriptor(IBinding binding, int imageFlags) {
        ImageDescriptor baseImage = BindingLabelProvider.getBaseImageDescriptor(binding, imageFlags);
        if (baseImage != null) {
            int adornmentFlags = BindingLabelProvider.getAdornmentFlags(binding, imageFlags);
            Point size = (imageFlags & 2) != 0 ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
            return new JavaElementImageDescriptor(baseImage, adornmentFlags, size);
        }
        return null;
    }

    public BindingLabelProvider() {
        this(DEFAULT_TEXTFLAGS, 1);
    }

    public BindingLabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
        this.fRegistry = null;
    }

    public Image getImage(Object element) {
        ImageDescriptor baseImage;
        if (element instanceof IBinding && (baseImage = BindingLabelProvider.getBindingImageDescriptor((IBinding)element, this.fImageFlags)) != null) {
            return this.getRegistry().get(baseImage);
        }
        return super.getImage(element);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String getText(Object element) {
        if (element instanceof IBinding) {
            return BindingLabelProvider.getBindingLabel((IBinding)element, this.fTextFlags);
        }
        return super.getText(element);
    }
}

