/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class BuildPathSupport {
    public static final String JRE_PREF_PAGE_ID = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";

    private BuildPathSupport() {
    }

    public static String getDeprecationMessage(String variableName) {
        String deprecationMessage = JavaCore.getClasspathVariableDeprecationMessage((String)variableName);
        if (deprecationMessage == null) {
            return null;
        }
        return Messages.format(NewWizardMessages.BuildPathSupport_deprecated, new Object[]{variableName, deprecationMessage});
    }

    public static IPath guessSourceAttachment(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaProject currProject = elem.getJavaProject();
        try {
            IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IClasspathEntry[] entries = curr.getRawClasspath();
                    int k = 0;
                    while (k < entries.length) {
                        IPath attachPath;
                        IClasspathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath()) && (attachPath = entry.getSourceAttachmentPath()) != null && !attachPath.isEmpty()) {
                            return attachPath;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }

    public static String guessJavadocLocation(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaProject currProject = elem.getJavaProject();
        try {
            IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IClasspathEntry[] entries = curr.getRawClasspath();
                    int k = 0;
                    while (k < entries.length) {
                        IClasspathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath())) {
                            IClasspathAttribute[] attributes = entry.getExtraAttributes();
                            int n = 0;
                            while (n < attributes.length) {
                                IClasspathAttribute attrib = attributes[n];
                                if ("javadoc_location".equals(attrib.getName())) {
                                    return attrib.getValue();
                                }
                                ++n;
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }

    public static void modifyClasspathEntry(Shell shell, IClasspathEntry newEntry, String[] changedAttributes, IJavaProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            BuildPathSupport.updateContainerClasspath(jproject, containerPath, newEntry, changedAttributes, monitor);
        } else {
            BuildPathSupport.updateProjectClasspath(shell, jproject, newEntry, changedAttributes, monitor);
        }
    }

    public static void modifyClasspathEntry(Shell shell, IClasspathEntry newEntry, IJavaProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        BuildPathSupport.modifyClasspathEntry(shell, newEntry, null, jproject, containerPath, monitor);
    }

    private static void updateContainerClasspath(IJavaProject jproject, IPath containerPath, IClasspathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        IJsGlobalScopeContainer container = JavaCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaProject)jproject);
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Container " + containerPath + " cannot be resolved", null));
        }
        IClasspathEntry[] entries = container.getClasspathEntries();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals((Object)newEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject) : curr;
            ++i;
        }
        BuildPathSupport.requestContainerUpdate(jproject, container, newEntries);
        monitor.worked(1);
    }

    private static IClasspathEntry getUpdatedEntry(IClasspathEntry currEntry, IClasspathEntry updatedEntry, String[] updatedAttributes, IJavaProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        CPListElement currElem = CPListElement.createFromExisting(currEntry, jproject);
        CPListElement newElem = CPListElement.createFromExisting(updatedEntry, jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getClasspathEntry();
    }

    public static void requestContainerUpdate(IJavaProject jproject, IJsGlobalScopeContainer container, IClasspathEntry[] newEntries) throws CoreException {
        IPath containerPath = container.getPath();
        UpdatedJsGlobalScopeContainer updatedContainer = new UpdatedJsGlobalScopeContainer(container, newEntries);
        JsGlobalScopeContainerInitializer initializer = JavaCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            initializer.requestJsGlobalScopeContainerUpdate(containerPath, jproject, (IJsGlobalScopeContainer)updatedContainer);
        }
    }

    private static void updateProjectClasspath(Shell shell, IJavaProject jproject, IClasspathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldClasspath = jproject.getRawClasspath();
        int nEntries = oldClasspath.length;
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IClasspathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntries.add(BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject));
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (!BuildPathSupport.putJarOnClasspathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IClasspathEntry[] newClasspath = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        jproject.setRawClasspath(newClasspath, monitor);
    }

    private static boolean putJarOnClasspathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String message = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static class UpdatedJsGlobalScopeContainer
    implements IJsGlobalScopeContainer {
        private IClasspathEntry[] fNewEntries;
        private IJsGlobalScopeContainer fOriginal;

        public UpdatedJsGlobalScopeContainer(IJsGlobalScopeContainer original, IClasspathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }

        public String[] resolvedLibraryImport(String a) {
            return null;
        }
    }
}

