/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public abstract class BuildPathWizard
extends NewElementWizard {
    private boolean fDoFlushChange;
    private final CPListElement fEntryToEdit;
    private IPackageFragmentRoot fPackageFragmentRoot;
    private IPath fOutputLocation;
    private final ArrayList fExistingEntries;

    public BuildPathWizard(CPListElement[] existingEntries, CPListElement newEntry, IPath outputLocation, String titel, ImageDescriptor image) {
        this.fOutputLocation = outputLocation;
        if (image != null) {
            this.setDefaultPageImageDescriptor(image);
        }
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(titel);
        this.fEntryToEdit = newEntry;
        this.fExistingEntries = new ArrayList<CPListElement>(Arrays.asList(existingEntries));
        this.fDoFlushChange = true;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fDoFlushChange) {
            IJavaProject javaProject = this.getEntryToEdit().getJavaProject();
            BuildPathsBlock.flush(this.getExistingEntries(), javaProject, this.getSuperType(), monitor);
            IProject project = javaProject.getProject();
            IPath path = this.getEntryToEdit().getPath();
            IResource folder = project.getWorkspace().getRoot().findMember(path);
            this.fPackageFragmentRoot = javaProject.getPackageFragmentRoot(folder);
        }
    }

    public LibrarySuperType getSuperType() {
        return null;
    }

    public IJavaElement getCreatedElement() {
        return this.fPackageFragmentRoot;
    }

    public void setDoFlushChange(boolean b) {
        this.fDoFlushChange = b;
    }

    public ArrayList getExistingEntries() {
        return this.fExistingEntries;
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    protected void setOutputLocation(IPath outputLocation) {
        this.fOutputLocation = outputLocation;
    }

    protected CPListElement getEntryToEdit() {
        return this.fEntryToEdit;
    }

    public List getInsertedElements() {
        return new ArrayList();
    }

    public List getRemovedElements() {
        return new ArrayList();
    }

    public List getModifiedElements() {
        ArrayList<CPListElement> result = new ArrayList<CPListElement>(1);
        result.add(this.fEntryToEdit);
        return result;
    }

    public abstract void cancel();
}

