/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ObjectStringStatusButtonDialogField;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class ClasspathOrderingWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private List allCpElements;
    private static final boolean HIDE_ALL_READONLY_CONTAINERS = true;
    private ObjectStringStatusButtonDialogField superTypeField;
    private IJavaProject fJavaProject;
    private Control fSWTControl;

    public ClasspathOrderingWorkbookPage(ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        this.superTypeField = new ObjectStringStatusButtonDialogField(new OrderingWorkbookPageAdapter());
    }

    public ObjectStringStatusButtonDialogField getSuperField() {
        return this.superTypeField;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.superTypeField.setButtonLabel(NewWizardMessages.ClasspathOrderingWorkbookPage_SelectReorder);
        this.superTypeField.setLabelText(NewWizardMessages.ClasspathOrderingWorkbookPage_SuperType);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fClassPathList, this.superTypeField}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fClassPathList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fClassPathList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    public List getSelection() {
        return this.fClassPathList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.allCpElements = selElements;
        this.fClassPathList.selectElements((ISelection)new StructuredSelection(this.allCpElements));
    }

    private List filterNodes(List elements) {
        ArrayList filter = new ArrayList();
        Iterator itt = elements.iterator();
        while (itt.hasNext()) {
            Object next = itt.next();
            if (next instanceof CPListElement && ((CPListElement)next).isJRE() || next instanceof CPListElement && ((CPListElement)next).isInNonModifiableContainer()) continue;
            filter.add(next);
        }
        return filter;
    }

    public boolean isEntryKind(int kind) {
        return true;
    }

    public void init(IJavaProject javaProject) {
        this.fJavaProject = javaProject;
    }

    public void setFocus() {
        this.fClassPathList.setFocus();
    }

    public void aboutToDispose() {
        this.fClassPathList.setElements(this.allCpElements);
    }

    public void aboutToShow() {
        this.allCpElements = this.fClassPathList.getElements();
        this.fClassPathList.setElements(this.filterNodes(this.fClassPathList.getElements()));
        this.superTypeField.setText(this.superTypeField.getValue().toString());
    }

    private LibrarySuperType openSuperTypeSelectionDialog(CPListElement[] existingCp, LibrarySuperType existingSuper) {
        LibrarySuperType newLib = BuildPathDialogAccess.chooseSuperType(this.getShell(), existingCp, existingSuper, this.fJavaProject);
        return newLib;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    class OrderingWorkbookPageAdapter
    implements IStringButtonAdapter {
        OrderingWorkbookPageAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            if (field == ClasspathOrderingWorkbookPage.this.superTypeField) {
                LibrarySuperType superType;
                CPListElement[] elements = ClasspathOrderingWorkbookPage.this.allCpElements.toArray(new CPListElement[ClasspathOrderingWorkbookPage.this.allCpElements.size()]);
                Object prevSuperTypeObject = ClasspathOrderingWorkbookPage.this.superTypeField.getValue();
                LibrarySuperType oldSuper = null;
                if (prevSuperTypeObject != null) {
                    oldSuper = (LibrarySuperType)prevSuperTypeObject;
                }
                if ((superType = ClasspathOrderingWorkbookPage.this.openSuperTypeSelectionDialog(elements, oldSuper)) != null && superType != oldSuper) {
                    ClasspathOrderingWorkbookPage.this.superTypeField.setValue(superType);
                    IPath cpEntryPath = superType.getRawContainerPath();
                    Iterator listItt = ClasspathOrderingWorkbookPage.this.allCpElements.iterator();
                    CPListElement found = null;
                    int foundIndex = -1;
                    while (listItt.hasNext()) {
                        ++foundIndex;
                        CPListElement o = (CPListElement)listItt.next();
                        if (!o.getPath().equals((Object)cpEntryPath)) continue;
                        found = o;
                        break;
                    }
                    if (found != null) {
                        ClasspathOrderingWorkbookPage.this.allCpElements.add(0, ClasspathOrderingWorkbookPage.this.allCpElements.remove(foundIndex));
                    }
                    ClasspathOrderingWorkbookPage.this.fClassPathList.setElements(ClasspathOrderingWorkbookPage.this.filterNodes(ClasspathOrderingWorkbookPage.this.allCpElements));
                }
            }
        }
    }
}

