/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;

public class EditVariableEntryDialog
extends StatusDialog {
    private IPath fFileVariablePath;
    private IStatus fNameStatus;
    private Set fExistingEntries;
    private VariablePathDialogField fFileNameField;
    private CLabel fFullPathResolvedLabel;

    public EditVariableEntryDialog(Shell parent, IPath initialEntry, IPath[] existingEntries) {
        super(parent);
        this.setTitle(NewWizardMessages.EditVariableEntryDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fExistingEntries = new HashSet();
        if (existingEntries != null) {
            int i = 0;
            while (i < existingEntries.length) {
                IPath curr = existingEntries[i];
                if (!curr.equals((Object)initialEntry)) {
                    this.fExistingEntries.add(curr);
                }
                ++i;
            }
        }
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        this.fFileNameField = new VariablePathDialogField(adapter);
        this.fFileNameField.setDialogFieldListener(adapter);
        this.fFileNameField.setLabelText(NewWizardMessages.EditVariableEntryDialog_filename_varlabel);
        this.fFileNameField.setButtonLabel(NewWizardMessages.EditVariableEntryDialog_filename_external_varbutton);
        this.fFileNameField.setVariableButtonLabel(NewWizardMessages.EditVariableEntryDialog_filename_variable_button);
        String initialString = initialEntry != null ? initialEntry.toString() : "";
        this.fFileNameField.setText(initialString);
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.fFileNameField.getText());
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        int widthHint = this.convertWidthInCharsToPixels(50);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.fFileNameField.doFillIntoGrid(composite, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fFileNameField.getLabelControl(null), 3);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        this.fFullPathResolvedLabel = new CLabel(composite, 16384);
        this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        this.fFullPathResolvedLabel.setLayoutData((Object)new GridData(256));
        DialogField.createEmptySpace(composite, 2);
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.source_attachment_context");
        EditVariableEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        IPath jarFilePath;
        if (field == this.fFileNameField && (jarFilePath = this.chooseExtJarFile()) != null) {
            this.fFileNameField.setText(jarFilePath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        }
        this.doStatusLineUpdate();
    }

    private IPath chooseExtJarFile() {
        IPath currPath = this.getPath();
        IPath resolvedPath = this.getResolvedPath(currPath);
        File initialSelection = resolvedPath != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        JARFileSelectionDialog dialog = new JARFileSelectionDialog(this.getShell(), false, false);
        dialog.setTitle(NewWizardMessages.EditVariableEntryDialog_extvardialog_title);
        dialog.setMessage(NewWizardMessages.EditVariableEntryDialog_extvardialog_description);
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = Path.fromOSString((String)result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = JavaCore.getClasspathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = JavaCore.getClasspathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            status.setError(NewWizardMessages.EditVariableEntryDialog_filename_empty);
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.EditVariableEntryDialog_filename_error_notvalid);
            return status;
        }
        IPath filePath = Path.fromOSString((String)fileName);
        if (filePath.getDevice() != null) {
            status.setError(NewWizardMessages.EditVariableEntryDialog_filename_error_deviceinpath);
            return status;
        }
        String varName = filePath.segment(0);
        if (varName == null) {
            status.setError(NewWizardMessages.EditVariableEntryDialog_filename_error_notvalid);
            return status;
        }
        this.fFileVariablePath = JavaCore.getClasspathVariable((String)varName);
        if (this.fFileVariablePath == null) {
            status.setError(NewWizardMessages.EditVariableEntryDialog_filename_error_varnotexists);
            return status;
        }
        String deprecationMessage = BuildPathSupport.getDeprecationMessage(varName);
        IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
        if (resolvedPath.isEmpty()) {
            String message = NewWizardMessages.EditVariableEntryDialog_filename_warning_varempty;
            if (deprecationMessage != null) {
                message = String.valueOf(deprecationMessage) + "\n" + message;
            }
            status.setWarning(message);
            return status;
        }
        File file = resolvedPath.toFile();
        if (!file.isFile()) {
            String message = Messages.format(NewWizardMessages.EditVariableEntryDialog_filename_error_filenotexists, resolvedPath.toOSString());
            if (deprecationMessage != null) {
                message = String.valueOf(deprecationMessage) + "\n" + message;
                status.setWarning(message);
            } else {
                status.setInfo(message);
            }
            return status;
        }
        if (deprecationMessage != null) {
            status.setWarning(deprecationMessage);
            return status;
        }
        return status;
    }

    private String getResolvedLabelString() {
        IPath resolvedPath = this.getResolvedPath(this.getPath());
        if (resolvedPath != null) {
            return resolvedPath.toOSString();
        }
        return "";
    }

    private boolean canBrowseFileName() {
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private void doStatusLineUpdate() {
        IPath path;
        IStatus status;
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        }
        if (!(status = this.fNameStatus).matches(4) && this.fExistingEntries.contains(path = this.getPath())) {
            String message = NewWizardMessages.EditVariableEntryDialog_filename_error_alreadyexists;
            status = new StatusInfo(4, message);
        }
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            Point size = shell.getSize();
            Point minSize = shell.computeSize(-1, -1, true);
            if (minSize.x > size.x || minSize.y > size.y) {
                shell.setSize(minSize);
            }
        }
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            EditVariableEntryDialog.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            EditVariableEntryDialog.this.attachmentDialogFieldChanged(field);
        }
    }
}

