/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JsGlobalScopeContainerDefaultPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JsGlobalScopeContainerDescriptor;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JsGlobalScopeContainerSelectionPage;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension2;

public class JsGlobalScopeContainerWizard
extends Wizard {
    private JsGlobalScopeContainerDescriptor fPageDesc;
    private IClasspathEntry fEntryToEdit;
    private IClasspathEntry[] fNewEntries;
    private IJsGlobalScopeContainerPage fContainerPage;
    private IJavaProject fCurrProject;
    private IClasspathEntry[] fCurrClasspath;
    private JsGlobalScopeContainerSelectionPage fSelectionWizardPage;

    public JsGlobalScopeContainerWizard(IClasspathEntry entryToEdit, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public JsGlobalScopeContainerWizard(JsGlobalScopeContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    private JsGlobalScopeContainerWizard(IClasspathEntry entryToEdit, JsGlobalScopeContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fCurrProject = currProject;
        this.fCurrClasspath = currEntries;
        String title = entryToEdit == null ? NewWizardMessages.JsGlobalScopeContainerWizard_new_title : NewWizardMessages.JsGlobalScopeContainerWizard_edit_title;
        this.setWindowTitle(title);
    }

    public IClasspathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IJsGlobalScopeContainerPageExtension2) {
                this.fNewEntries = ((IJsGlobalScopeContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IClasspathEntry[] iClasspathEntryArray;
                IClasspathEntry entry = this.fContainerPage.getSelection();
                if (entry != null) {
                    IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[1];
                    iClasspathEntryArray = iClasspathEntryArray2;
                    iClasspathEntryArray2[0] = entry;
                } else {
                    iClasspathEntryArray = null;
                }
                this.fNewEntries = iClasspathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            JsGlobalScopeContainerDescriptor[] containers = JsGlobalScopeContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new JsGlobalScopeContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new JsGlobalScopeContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            JsGlobalScopeContainerDescriptor[] containers = JsGlobalScopeContainerDescriptor.getDescriptors();
            JsGlobalScopeContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IJsGlobalScopeContainerPage getContainerPage(JsGlobalScopeContainerDescriptor pageDesc) {
        IJsGlobalScopeContainerPage containerPage = null;
        if (pageDesc != null) {
            IJsGlobalScopeContainerPage page = pageDesc.getPage();
            if (page != null) {
                return page;
            }
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new JsGlobalScopeContainerDefaultPage();
            if (pageDesc != null) {
                pageDesc.setPage(containerPage);
            }
        }
        if (containerPage instanceof IJsGlobalScopeContainerPageExtension) {
            ((IJsGlobalScopeContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrClasspath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            JsGlobalScopeContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = NewWizardMessages.JsGlobalScopeContainerWizard_pagecreationerror_title;
        String message = NewWizardMessages.JsGlobalScopeContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private JsGlobalScopeContainerDescriptor findDescriptorPage(JsGlobalScopeContainerDescriptor[] containers, IClasspathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            JsGlobalScopeContainerDescriptor[] descriptors = this.fSelectionWizardPage.getContainers();
            int i = 0;
            while (i < descriptors.length) {
                descriptors[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, JsGlobalScopeContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

