/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;

public final class HintTextGroup
implements ISelectionChangedListener {
    private Composite fTopComposite;
    private DialogPackageExplorerActionGroup fActionGroup;
    private List fNewFolders = new ArrayList();
    private HashMap fImageMap = new HashMap();

    public Composite createControl(Composite parent) {
        this.fTopComposite = new Composite(parent, 0);
        this.fTopComposite.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)gridLayout);
        this.fTopComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData(null);
        this.fTopComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Collection collection = HintTextGroup.this.fImageMap.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
            }
        });
        return this.fTopComposite;
    }

    private Shell getShell() {
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    private FormText createFormText(Composite parent, String text) {
        FormText formText;
        FormToolkit toolkit = new FormToolkit(this.getShell().getDisplay());
        try {
            FormText formText2 = toolkit.createFormText(parent, true);
            formText2.setFont(parent.getFont());
            try {
                formText2.setText(text, true, false);
            }
            catch (IllegalArgumentException e) {
                formText2.setText(e.getMessage(), false, false);
                JavaPlugin.log(e);
            }
            formText2.marginHeight = 2;
            formText2.marginWidth = 0;
            formText2.setBackground(null);
            formText2.setLayoutData((Object)new TableWrapData(256));
            formText = formText2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            toolkit.dispose();
            throw throwable;
        }
        toolkit.dispose();
        return formText;
    }

    private void createLabel(Composite parent, String text, final BuildpathModifierAction action) {
        FormText formText = this.createFormText(parent, text);
        Image image = (Image)this.fImageMap.get(action.getId());
        if (image == null) {
            image = action.getImageDescriptor().createImage();
            this.fImageMap.put(action.getId(), image);
        }
        formText.setImage("defaultImage", image);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
    }

    void handleFolderCreation(List result) {
        if (result.size() == 1) {
            try {
                this.fNewFolders.add(((IPackageFragmentRoot)result.get(0)).getCorrespondingResource());
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public List getCreatedResources() {
        return this.fNewFolders;
    }

    public void resetCreatedResources() {
        this.fNewFolders.clear();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            this.handlePostSelectionChange((StructuredSelection)event.getSelection());
        } else {
            this.handlePostSelectionChange(StructuredSelection.EMPTY);
        }
    }

    private void handlePostSelectionChange(StructuredSelection selection) {
        BuildpathModifierAction[] actions = this.fActionGroup.getHintTextGroupActions();
        String[] descriptions = new String[actions.length];
        int i = 0;
        while (i < actions.length) {
            descriptions[i] = actions[i].getDetailedDescription();
            ++i;
        }
        Composite childComposite = (Composite)this.fTopComposite.getData();
        if (childComposite != null && childComposite.getParent() != null) {
            childComposite.getParent().dispose();
        }
        PixelConverter converter = new PixelConverter((Control)this.fTopComposite);
        ScrolledPageContent spc = new ScrolledPageContent(this.fTopComposite, 512);
        spc.getVerticalBar().setIncrement(5);
        GridData gridData = new GridData(1808);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        spc.setLayoutData(gridData);
        childComposite = spc.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        childComposite.setLayout((Layout)tableWrapLayout);
        gridData = new GridData(1808);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        gridData.widthHint = converter.convertWidthInCharsToPixels(25);
        childComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData((Object)childComposite);
        if (this.noContextHelpAvailable(actions)) {
            String noAction = this.noAction((ISelection)selection);
            this.createFormText(childComposite, Messages.format(NewWizardMessages.HintTextGroup_NoAction, noAction));
            this.fTopComposite.layout(true);
            return;
        }
        int i2 = 0;
        while (i2 < actions.length) {
            this.createLabel(childComposite, descriptions[i2], actions[i2]);
            ++i2;
        }
        this.fTopComposite.layout(true);
    }

    private String noAction(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            return this.noAction(((StructuredSelection)selection).toList());
        }
        return this.noAction(Collections.EMPTY_LIST);
    }

    private String noAction(List selectedElements) {
        if (selectedElements.size() == 0) {
            return NewWizardMessages.PackageExplorerActionGroup_NoAction_NullSelection;
        }
        if (selectedElements.size() == 1) {
            return NewWizardMessages.PackageExplorerActionGroup_NoAction_NoReason;
        }
        return NewWizardMessages.PackageExplorerActionGroup_NoAction_MultiSelection;
    }

    private boolean noContextHelpAvailable(BuildpathModifierAction[] actions) {
        int id;
        if (actions.length == 0) {
            return true;
        }
        if (actions.length == 1 && (id = Integer.parseInt(actions[0].getId())) == 5) {
            return true;
        }
        if (actions.length == 2) {
            int idLink = Integer.parseInt(actions[0].getId());
            int idReset = Integer.parseInt(actions[1].getId());
            if (idReset == 6 && idLink == 5) {
                return true;
            }
        }
        return false;
    }
}

