/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.buildpath.IBuildpathModifierListener;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.ViewerPane;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorer;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.HintTextGroup;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class NewSourceContainerWorkbookPage
extends BuildPathBasePage
implements IBuildpathModifierListener {
    public static final String OPEN_SETTING = "org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.NewSourceContainerPage.openSetting";
    private ListDialogField fClassPathList;
    private HintTextGroup fHintTextGroup;
    private DialogPackageExplorer fPackageExplorer;
    private DialogPackageExplorerActionGroup fActionGroup;
    private IJavaProject fJavaProject;
    private final IRunnableContext fContext;

    public NewSourceContainerWorkbookPage(ListDialogField classPathList, StringDialogField outputLocationField, IRunnableContext context, BuildPathsBlock buildPathsBlock) {
        this.fClassPathList = classPathList;
        this.fContext = context;
        this.fPackageExplorer = new DialogPackageExplorer();
        this.fHintTextGroup = new HintTextGroup();
    }

    public void init(IJavaProject javaProject) {
        this.fJavaProject = javaProject;
        this.fPackageExplorer.addPostSelectionChangedListener(this.fHintTextGroup);
        this.fActionGroup.getResetAllAction().setBreakPoint(javaProject);
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NewSourceContainerWorkbookPage.this.doUpdateUI();
                }
            });
        }
    }

    private void doUpdateUI() {
        this.fPackageExplorer.setInput(this.fJavaProject);
        boolean useFolderOutputs = false;
        List cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size() && !useFolderOutputs) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (cpe.getEntryKind() == 3 && cpe.getAttribute("output") != null) {
                useFolderOutputs = true;
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.fActionGroup != null) {
            this.fActionGroup.removeBuildpathModifierListener(this);
            this.fActionGroup = null;
        }
        this.fPackageExplorer.removePostSelectionChangedListener(this.fHintTextGroup);
        this.fPackageExplorer.dispose();
    }

    public Control getControl(Composite parent) {
        final int[] sashWeight = new int[]{60};
        final IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(OPEN_SETTING, true);
        ScrolledPageContent scrolledContent = new ScrolledPageContent(parent);
        Composite body = scrolledContent.getBody();
        body.setLayout((Layout)new GridLayout());
        final SashForm sashForm = new SashForm(body, 512);
        sashForm.setFont(sashForm.getFont());
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setContent(this.fPackageExplorer.createControl((Composite)pane));
        this.fPackageExplorer.setContentProvider();
        final ExpandableComposite excomposite = new ExpandableComposite((Composite)sashForm, 0, 18);
        excomposite.setFont(sashForm.getFont());
        excomposite.setText(NewWizardMessages.NewSourceContainerWorkbookPage_HintTextGroup_title);
        boolean isExpanded = preferenceStore.getBoolean(OPEN_SETTING);
        excomposite.setExpanded(isExpanded);
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite = NewSourceContainerWorkbookPage.this.getParentScrolledComposite((Control)excomposite);
                if (parentScrolledComposite != null) {
                    boolean expanded = excomposite.isExpanded();
                    parentScrolledComposite.reflow(true);
                    NewSourceContainerWorkbookPage.this.adjustSashForm(sashWeight, sashForm, expanded);
                    preferenceStore.setValue(NewSourceContainerWorkbookPage.OPEN_SETTING, expanded);
                }
            }
        });
        excomposite.setClient((Control)this.fHintTextGroup.createControl((Composite)excomposite));
        this.fActionGroup = new DialogPackageExplorerActionGroup(this.fHintTextGroup, this.fContext, this.fPackageExplorer, this);
        this.fActionGroup.addBuildpathModifierListener(this);
        Composite outputLocation = new Composite(body, 0);
        outputLocation.setLayout((Layout)new GridLayout(2, false));
        outputLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        ToolBarManager tbm = this.fActionGroup.createLeftToolBarManager(pane);
        pane.setTopCenter(null);
        pane.setTopLeft((Control)tbm.getControl());
        tbm = this.fActionGroup.createLeftToolBar(pane);
        pane.setTopRight((Control)tbm.getControl());
        this.fHintTextGroup.setActionGroup(this.fActionGroup);
        this.fPackageExplorer.setActionGroup(this.fActionGroup);
        sashForm.setWeights(new int[]{60, 40});
        this.adjustSashForm(sashWeight, sashForm, excomposite.isExpanded());
        GridData gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gd);
        parent.layout(true);
        return scrolledContent;
    }

    private void adjustSashForm(int[] sashWeight, SashForm sashForm, boolean isExpanded) {
        if (isExpanded) {
            int upperWeight = sashWeight[0];
            sashForm.setWeights(new int[]{upperWeight, 100 - upperWeight});
        } else {
            sashWeight[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    public List getSelection() {
        ArrayList<CPListElement> selectedList = new ArrayList<CPListElement>();
        IJavaProject project = this.fJavaProject;
        try {
            List list = ((StructuredSelection)this.fPackageExplorer.getSelection()).toList();
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            int i = 0;
            while (i < list.size()) {
                IClasspathEntry entry;
                CPListElement cpElement;
                Object obj = list.get(i);
                if (obj instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot element = (IPackageFragmentRoot)obj;
                    cpElement = ClasspathModifier.getClasspathEntry(existingEntries, element);
                    selectedList.add(cpElement);
                } else if (obj instanceof IJavaProject && (entry = ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3)) != null) {
                    cpElement = CPListElement.createFromExisting(entry, project);
                    selectedList.add(cpElement);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return new ArrayList();
        }
        return selectedList;
    }

    public void setSelection(List selection, boolean expand) {
        if (selection.size() == 0) {
            return;
        }
        ArrayList<CPListElement> cpEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < selection.size()) {
            CPListElementAttribute attribute;
            CPListElement element;
            Object obj = selection.get(i);
            if (obj instanceof CPListElement) {
                CPListElement element2 = (CPListElement)obj;
                if (element2.getEntryKind() == 3) {
                    cpEntries.add(element2);
                }
            } else if (obj instanceof CPListElementAttribute && (element = (attribute = (CPListElementAttribute)obj).getParent()).getEntryKind() == 3) {
                cpEntries.add(element);
            }
            ++i;
        }
        List list = this.fClassPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            CPListElement entry = (CPListElement)list.get(i2);
            entries[i2] = entry.getClasspathEntry();
            ++i2;
        }
        try {
            this.fJavaProject.setRawClasspath(entries, null);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        this.fPackageExplorer.setSelection(cpEntries);
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    public void buildpathChanged(BuildpathDelta delta) {
    }

    public void commitDefaultOutputFolder() {
    }

    public void setFocus() {
        this.fPackageExplorer.getViewerControl().setFocus();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }
}

