/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddGetterSetterOperation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddGetterSetterAction
extends SelectionDispatchAction {
    private boolean fSort;
    private boolean fSynchronized;
    private boolean fFinal;
    private int fVisibility;
    private boolean fGenerateComment;
    private int fNumEntries;
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.AddGetterSetterAction_error_title;
    static /* synthetic */ Class class$0;

    public AddGetterSetterAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddGetterSetterAction_label);
        this.setDescription(ActionMessages.AddGetterSetterAction_description);
        this.setToolTipText(ActionMessages.AddGetterSetterAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.getter_setter_action_context");
    }

    public AddGetterSetterAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
        this.fEditor.getEditorSite();
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (this.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.AddGetterSetterAction_no_primary_type_title, (String)ActionMessages.AddGetterSetterAction_no_primary_type_message);
                    this.notifyResult(false);
                    return;
                }
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields == null || fields.length == 0) {
            return false;
        }
        int count = 0;
        int index = 0;
        while (index < fields.length) {
            if (!JdtFlags.isEnum((IMember)fields[index])) {
                ++count;
            }
            ++index;
        }
        if (count == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_not_applicable);
        }
        return count > 0;
    }

    private void resetNumEntries() {
        this.fNumEntries = 0;
    }

    private void incNumEntries() {
        ++this.fNumEntries;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (type.isAnnotation()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_annotation_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_interface_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.getCompilationUnit() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_error_not_in_source_file);
            this.notifyResult(false);
            return;
        }
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            this.notifyResult(false);
            return;
        }
        if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)type)) {
            this.notifyResult(false);
            return;
        }
        AddGetterSetterLabelProvider lp = new AddGetterSetterLabelProvider();
        this.resetNumEntries();
        Map entries = this.createGetterSetterMapping(type);
        if (entries.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGettSetterAction_typeContainsNoFields_message);
            this.notifyResult(false);
            return;
        }
        AddGetterSetterContentProvider cp = new AddGetterSetterContentProvider(entries);
        GetterSetterTreeSelectionDialog dialog = new GetterSetterTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, cp, this.fEditor, type);
        dialog.setComparator(new JavaElementComparator());
        dialog.setTitle(DIALOG_TITLE);
        String message = ActionMessages.AddGetterSetterAction_dialog_label;
        dialog.setMessage(message);
        dialog.setValidator(AddGetterSetterAction.createValidator(this.fNumEntries));
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(type);
        if (preselected.length > 0) {
            dialog.setInitialSelections(preselected);
            dialog.setExpandedElements(preselected);
        }
        LinkedHashSet keySet = new LinkedHashSet(entries.keySet());
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IField[] getterSetterFields;
            IField[] setterFields;
            IField[] getterFields;
            Object[] result = dialog.getResult();
            if (result == null) {
                this.notifyResult(false);
                return;
            }
            this.fSort = dialog.getSortOrder();
            this.fSynchronized = dialog.getSynchronized();
            this.fFinal = dialog.getFinal();
            this.fVisibility = dialog.getVisibilityModifier();
            this.fGenerateComment = dialog.getGenerateComment();
            if (this.fSort) {
                getterFields = AddGetterSetterAction.getGetterFields(result, keySet);
                setterFields = AddGetterSetterAction.getSetterFields(result, keySet);
                getterSetterFields = new IField[]{};
            } else {
                getterFields = AddGetterSetterAction.getGetterOnlyFields(result, keySet);
                setterFields = AddGetterSetterAction.getSetterOnlyFields(result, keySet);
                getterSetterFields = AddGetterSetterAction.getGetterSetterFields(result, keySet);
            }
            this.generate(type, getterFields, setterFields, getterSetterFields, new RefactoringASTParser(3).parse((ITypeRoot)type.getCompilationUnit(), true), dialog.getElementPosition());
        }
        this.notifyResult(dialogResult == 0);
    }

    private static String createSignatureKey(String methodName, IField field) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodName);
        String fieldType = field.getTypeSignature();
        String signature = Signature.getSimpleName((String)Signature.toString((String)fieldType));
        buffer.append("#");
        buffer.append(signature);
        return buffer.toString();
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddGetterSetterSelectionStatusValidator validator = new AddGetterSetterSelectionStatusValidator(entries);
        return validator;
    }

    private static IField[] getSetterFields(Object[] result, Set set) {
        List<IField> list = new ArrayList(0);
        Object each = null;
        GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (!entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterFields(Object[] result, Set set) {
        List<IField> list = new ArrayList(0);
        Object each = null;
        GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterOnlyFields(Object[] result, Set set) {
        List<IField> list = new ArrayList(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.remove(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getSetterOnlyFields(Object[] result, Set set) {
        List<IField> list = new ArrayList(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && !getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterSetterFields(Object[] result, Set set) {
        List<IField> list = new ArrayList(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static List reorderFields(List collection, Set set) {
        ArrayList<IField> list = new ArrayList<IField>(collection.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IField field = (IField)iterator.next();
            if (!collection.contains(field)) continue;
            list.add(field);
        }
        return list;
    }

    private void generate(IType type, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, CompilationUnit unit, IJavaElement elementPosition) throws CoreException {
        if (getterFields.length == 0 && setterFields.length == 0 && getterSetterFields.length == 0) {
            return;
        }
        ICompilationUnit cu = null;
        cu = getterFields.length != 0 ? getterFields[0].getCompilationUnit() : (setterFields.length != 0 ? setterFields[0].getCompilationUnit() : getterSetterFields[0].getCompilationUnit());
        this.run(cu, type, getterFields, setterFields, getterSetterFields, JavaUI.openInEditor((IJavaElement)cu), unit, elementPosition);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        try {
            IType type;
            if (!ActionUtil.isProcessable(this.fEditor)) {
                this.notifyResult(false);
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_not_applicable);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Exception decompiling
     */
    private void run(ICompilationUnit cu, IType type, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IEditorPart editor, CompilationUnit unit, IJavaElement elementPosition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 218->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setOperationStatusFields(AddGetterSetterOperation op) {
        int flags = this.fVisibility;
        if (this.fSynchronized) {
            flags |= 0x20;
        }
        if (this.fFinal) {
            flags |= 0x10;
        }
        op.setSort(this.fSort);
        op.setVisibility(flags);
    }

    private IRequestQuery skipReplaceQuery() {
        return new IRequestQuery(){

            public int doQuery(IMember method) {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 3;
                int[] returnCodes = nArray;
                String skipLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_skip_label;
                String replaceLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_replace_label;
                String skipAllLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_skipAll_label;
                String[] options = new String[]{skipLabel, replaceLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1L);
                String formattedMessage = Messages.format(ActionMessages.AddGetterSetterAction_SkipExistingDialog_message, methodName);
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private int showQueryDialog(final String message, final String[] buttonLabels, int[] returnCodes) {
        final Shell shell = this.getShell();
        if (shell == null) {
            JavaPlugin.logErrorMessage("AddGetterSetterAction.showQueryDialog: No active shell found");
            return 0;
        }
        final int[] result = new int[]{1};
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = ActionMessages.AddGetterSetterAction_QueryDialog_title;
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttonLabels, 0);
                result[0] = dialog.open();
            }
        });
        int returnVal = result[0];
        return returnVal < 0 ? 0 : returnCodes[returnVal];
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            IType declaringType = fld.getDeclaringType();
                            if (declaringType == null || declaringType.isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
                ++i;
            }
            return res;
        }
        return null;
    }

    private Map createGetterSetterMapping(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        LinkedHashMap<IField, GetterSetterEntry[]> result = new LinkedHashMap<IField, GetterSetterEntry[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            int flags = field.getFlags();
            if (!Flags.isEnum((int)flags)) {
                ArrayList<GetterSetterEntry> l = new ArrayList<GetterSetterEntry>(2);
                if (GetterSetterUtil.getGetter(field) == null) {
                    l.add(new GetterSetterEntry(field, true, Flags.isFinal((int)flags)));
                    this.incNumEntries();
                }
                if (GetterSetterUtil.getSetter(field) == null) {
                    l.add(new GetterSetterEntry(field, false, Flags.isFinal((int)flags)));
                    this.incNumEntries();
                }
                if (!l.isEmpty()) {
                    result.put(field, l.toArray(new GetterSetterEntry[l.size()]));
                }
            }
            ++i;
        }
        return result;
    }

    private static class AddGetterSetterContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private Viewer fViewer;
        private Map fGetterSetterEntries;

        public AddGetterSetterContentProvider(Map entries) {
            this.fGetterSetterEntries = entries;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
        }

        public Viewer getViewer() {
            return this.fViewer;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return (Object[])this.fGetterSetterEntries.get(parentElement);
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                return member.getDeclaringType() != null ? member.getDeclaringType() : member.getCompilationUnit();
            }
            if (element instanceof GetterSetterEntry) {
                return ((GetterSetterEntry)element).field;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fGetterSetterEntries.keySet().toArray();
        }

        public void dispose() {
            this.fGetterSetterEntries.clear();
            this.fGetterSetterEntries = null;
        }
    }

    private static class AddGetterSetterLabelProvider
    extends JavaElementLabelProvider {
        AddGetterSetterLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)element;
                try {
                    if (entry.isGetter) {
                        return String.valueOf(GetterSetterUtil.getGetterName(entry.field, null)) + "()";
                    }
                    return String.valueOf(GetterSetterUtil.getSetterName(entry.field, null)) + '(' + Signature.getSimpleName((String)Signature.toString((String)entry.field.getTypeSignature())) + ')';
                }
                catch (JavaModelException javaModelException) {
                    return "";
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof GetterSetterEntry) {
                int flags = 0;
                try {
                    flags = ((GetterSetterEntry)element).field.getFlags();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Object desc = JavaElementImageProvider.getFieldImageDescriptor(false, 1);
                int adornmentFlags = Flags.isStatic((int)flags) ? 8 : 0;
                desc = new JavaElementImageDescriptor((ImageDescriptor)desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
            return super.getImage(element);
        }
    }

    private static class AddGetterSetterSelectionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddGetterSetterSelectionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            HashSet<Object> map = null;
            if (selection != null && selection.length > 1) {
                map = new HashSet<Object>(selection.length);
            }
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                try {
                    if (selection[i] instanceof GetterSetterEntry) {
                        Object key = selection[i];
                        IField getsetField = ((GetterSetterEntry)selection[i]).field;
                        if (((GetterSetterEntry)selection[i]).isGetter ? !map.add(GetterSetterUtil.getGetterName(getsetField, null)) : !map.add(key = AddGetterSetterAction.createSignatureKey(GetterSetterUtil.getSetterName(getsetField, null), getsetField))) {
                            return new StatusInfo(2, ActionMessages.AddGetterSetterAction_error_duplicate_methods);
                        }
                        ++count;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String message = Messages.format(ActionMessages.AddGetterSetterAction_methods_selected, new Object[]{String.valueOf(count), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }
    }

    private static class GetterSetterEntry {
        public final IField field;
        public final boolean isGetter;
        public final boolean isFinal;

        GetterSetterEntry(IField field, boolean isGetterEntry, boolean isFinal) {
            this.field = field;
            this.isGetter = isGetterEntry;
            this.isFinal = isFinal;
        }
    }

    private static class GetterSetterTreeSelectionDialog
    extends SourceActionDialog {
        private AddGetterSetterContentProvider fContentProvider;
        private static final int SELECT_GETTERS_ID = 1025;
        private static final int SELECT_SETTERS_ID = 1026;
        private final String SETTINGS_SECTION = "AddGetterSetterDialog";
        private final String SORT_ORDER = "SortOrdering";
        private final String ALLOW_SETTERS_FOR_FINALS = "RemoveFinal";
        private IDialogSettings fSettings;
        private SettersForFinalFieldsFilter fSettersForFinalFieldsFilter;
        private boolean fSortOrder;
        private boolean fAllowSettersForFinals;
        private ArrayList fPreviousSelectedFinals;

        public GetterSetterTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, AddGetterSetterContentProvider contentProvider, CompilationUnitEditor editor, IType type) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, false);
            this.fContentProvider = contentProvider;
            this.fPreviousSelectedFinals = new ArrayList();
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("AddGetterSetterDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("AddGetterSetterDialog");
                this.fSettings.put("SortOrdering", false);
                this.fSettings.put("RemoveFinal", false);
            }
            this.fSortOrder = this.fSettings.getBoolean("SortOrdering");
            this.fAllowSettersForFinals = this.fSettings.getBoolean("RemoveFinal");
            this.fSettersForFinalFieldsFilter = new SettersForFinalFieldsFilter(contentProvider);
        }

        public boolean getSortOrder() {
            return this.fSortOrder;
        }

        public void setSortOrder(boolean sort) {
            if (this.fSortOrder != sort) {
                this.fSortOrder = sort;
                this.fSettings.put("SortOrdering", sort);
                if (this.getTreeViewer() != null) {
                    this.getTreeViewer().refresh();
                }
            }
        }

        private boolean allowSettersForFinals() {
            return this.fAllowSettersForFinals;
        }

        public void allowSettersForFinals(boolean allowSettersForFinals) {
            if (this.fAllowSettersForFinals != allowSettersForFinals) {
                this.fAllowSettersForFinals = allowSettersForFinals;
                this.fSettings.put("RemoveFinal", allowSettersForFinals);
                CheckboxTreeViewer treeViewer = this.getTreeViewer();
                if (treeViewer != null) {
                    ArrayList<GetterSetterEntry> newChecked = new ArrayList<GetterSetterEntry>();
                    if (allowSettersForFinals) {
                        newChecked.addAll(this.fPreviousSelectedFinals);
                    }
                    this.fPreviousSelectedFinals.clear();
                    Object[] checkedElements = treeViewer.getCheckedElements();
                    int i = 0;
                    while (i < checkedElements.length) {
                        if (checkedElements[i] instanceof GetterSetterEntry) {
                            GetterSetterEntry entry = (GetterSetterEntry)checkedElements[i];
                            if (allowSettersForFinals || entry.isGetter || !entry.isFinal) {
                                newChecked.add(entry);
                            } else {
                                this.fPreviousSelectedFinals.add(entry);
                            }
                        }
                        ++i;
                    }
                    if (allowSettersForFinals) {
                        treeViewer.removeFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
                    } else {
                        treeViewer.addFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
                    }
                    treeViewer.setCheckedElements(newChecked.toArray());
                }
                this.updateOKStatus();
            }
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
            if (!this.fAllowSettersForFinals) {
                treeViewer.addFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
            }
            return treeViewer;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.add_getter_setter_selection_dialog_context");
        }

        private void createGetterSetterButtons(Composite buttonComposite) {
            this.createButton(buttonComposite, 1025, ActionMessages.GetterSetterTreeSelectionDialog_select_getters, false);
            this.createButton(buttonComposite, 1026, ActionMessages.GetterSetterTreeSelectionDialog_select_setters, false);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            switch (buttonId) {
                case 1025: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(true));
                    this.updateOKStatus();
                    break;
                }
                case 1026: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(false));
                    this.updateOKStatus();
                }
            }
        }

        protected Composite createInsertPositionCombo(Composite composite) {
            Button addRemoveFinalCheckbox = this.addAllowSettersForFinalslCheckbox(composite);
            addRemoveFinalCheckbox.setLayoutData((Object)new GridData(768));
            Composite entryComposite = super.createInsertPositionCombo(composite);
            this.addSortOrder(entryComposite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        private Button addAllowSettersForFinalslCheckbox(Composite entryComposite) {
            Button allowSettersForFinalsButton = new Button(entryComposite, 32);
            allowSettersForFinalsButton.setText(ActionMessages.AddGetterSetterAction_allow_setters_for_finals_description);
            allowSettersForFinalsButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ GetterSetterTreeSelectionDialog this$1;
                {
                    this.this$1 = getterSetterTreeSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$1.allowSettersForFinals(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            allowSettersForFinalsButton.setSelection(this.allowSettersForFinals());
            return allowSettersForFinalsButton;
        }

        private Composite addSortOrder(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(ActionMessages.GetterSetterTreeSelectionDialog_sort_label);
            GridData gd = new GridData(1808);
            label.setLayoutData((Object)gd);
            Combo combo = new Combo(composite, 8);
            combo.setItems(new String[]{ActionMessages.GetterSetterTreeSelectionDialog_alpha_pair_sort, ActionMessages.GetterSetterTreeSelectionDialog_alpha_method_sort});
            int sort = this.getSortOrder() ? 1 : 0;
            combo.setText(combo.getItem(sort));
            gd = new GridData(1808);
            combo.setLayoutData((Object)gd);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, combo){
                final /* synthetic */ GetterSetterTreeSelectionDialog this$1;
                private final /* synthetic */ Combo val$combo;
                {
                    this.this$1 = getterSetterTreeSelectionDialog;
                    this.val$combo = combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setSortOrder(this.val$combo.getSelectionIndex() == 1);
                }
            });
            return composite;
        }

        private Object[] getGetterSetterElements(boolean isGetter) {
            Object[] allFields = this.fContentProvider.getElements(null);
            HashSet<GetterSetterEntry> result = new HashSet<GetterSetterEntry>();
            int i = 0;
            while (i < allFields.length) {
                IField field = (IField)allFields[i];
                GetterSetterEntry[] entries = this.getEntries(field);
                int j = 0;
                while (j < entries.length) {
                    GetterSetterEntry entry = entries[j];
                    if (entry.isGetter == isGetter) {
                        result.add(entry);
                    }
                    ++j;
                }
                ++i;
            }
            return result.toArray();
        }

        private GetterSetterEntry[] getEntries(IField field) {
            List<Object> result = Arrays.asList(this.fContentProvider.getChildren(field));
            return result.toArray(new GetterSetterEntry[result.size()]);
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = super.createSelectionButtons(composite);
            GridLayout layout = new GridLayout();
            buttonComposite.setLayout((Layout)layout);
            this.createGetterSetterButtons(buttonComposite);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            return buttonComposite;
        }

        protected Control createLinkControl(Composite composite) {
            Link link = new Link(composite, 64);
            link.setText(ActionMessages.AddGetterSetterAction_template_link_description);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ GetterSetterTreeSelectionDialog this$1;
                {
                    this.this$1 = getterSetterTreeSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    GetterSetterTreeSelectionDialog.access$0(this.this$1, "org.eclipse.wst.jsdt.ui.text.codetemplates.gettercomment");
                }
            });
            link.setToolTipText(ActionMessages.AddGetterSetterAction_template_link_tooltip);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(40);
            link.setLayoutData((Object)gridData);
            return link;
        }

        static /* synthetic */ void access$0(GetterSetterTreeSelectionDialog getterSetterTreeSelectionDialog, String string) {
            getterSetterTreeSelectionDialog.openCodeTempatePage(string);
        }
    }

    private static class SettersForFinalFieldsFilter
    extends ViewerFilter {
        private final AddGetterSetterContentProvider fContentProvider;

        public SettersForFinalFieldsFilter(AddGetterSetterContentProvider contentProvider) {
            this.fContentProvider = contentProvider;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry getterSetterEntry = (GetterSetterEntry)element;
                return getterSetterEntry.isGetter || !getterSetterEntry.isFinal;
            }
            if (element instanceof IField) {
                Object[] children = this.fContentProvider.getChildren(element);
                int i = 0;
                while (i < children.length) {
                    GetterSetterEntry curr = (GetterSetterEntry)children[i];
                    if (curr.isGetter || !curr.isFinal) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
    }
}

