/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddToClasspathAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$0;

    public AddToClasspathAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddToClasspathAction_label);
        this.setToolTipText(ActionMessages.AddToClasspathAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.addjtoclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(AddToClasspathAction.checkEnabled(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private static boolean checkEnabled(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (AddToClasspathAction.canBeAddedToBuildPath(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeAddedToBuildPath(Object element) throws JavaModelException {
        return element instanceof IAdaptable && AddToClasspathAction.getCandidate((IAdaptable)element) != null;
    }

    private static IFile getCandidate(IAdaptable element) throws JavaModelException {
        IResource resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((resource = (IResource)element.getAdapter((Class)clazz)) instanceof IFile) || !ArchiveFileFilter.isArchivePath(resource.getFullPath())) {
            return null;
        }
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (project != null && project.exists() && project.findPackageFragmentRoot(resource.getFullPath()) == null) {
            return (IFile)resource;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            final IFile[] files = AddToClasspathAction.getJARFiles(selection);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask(ActionMessages.AddToClasspathAction_progressMessage, files.length);
                    int i = 0;
                    while (i < files.length) {
                        monitor.subTask(files[i].getFullPath().toString());
                        IJavaProject project = JavaCore.create((IProject)files[i].getProject());
                        this.addToClassPath(project, files[i].getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }

                private void addToClassPath(IJavaProject project, IPath jarPath, IProgressMonitor monitor) throws JavaModelException {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IClasspathEntry[] entries = project.getRawClasspath();
                    IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                    System.arraycopy(entries, 0, newEntries, 0, entries.length);
                    newEntries[entries.length] = JavaCore.newLibraryEntry((IPath)jarPath, null, null, (boolean)false);
                    project.setRawClasspath(newEntries, monitor);
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IFile[] getJARFiles(IStructuredSelection selection) throws JavaModelException {
        ArrayList<IFile> list = new ArrayList<IFile>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IFile file;
            Object element = iter.next();
            if (!(element instanceof IAdaptable) || (file = AddToClasspathAction.getCandidate((IAdaptable)element)) == null) continue;
            list.add(file);
        }
        return list.toArray(new IFile[list.size()]);
    }
}

