/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.InlineConstantAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.InlineMethodAction;
import org.eclipse.wst.jsdt.ui.actions.InlineTempAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InlineAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private final InlineTempAction fInlineTemp;
    private final InlineMethodAction fInlineMethod;
    private final InlineConstantAction fInlineConstant;

    public InlineAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fInlineTemp = new InlineTempAction(site);
        this.fInlineConstant = new InlineConstantAction(site);
        this.fInlineMethod = new InlineMethodAction(site);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
    }

    public InlineAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fEditor = editor;
        this.fInlineTemp = new InlineTempAction(editor);
        this.fInlineConstant = new InlineConstantAction(editor);
        this.fInlineMethod = new InlineMethodAction(editor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ISelection selection) {
        this.fInlineConstant.update(selection);
        this.fInlineMethod.update(selection);
        this.fInlineTemp.update(selection);
        this.setEnabled(this.fInlineTemp.isEnabled() || this.fInlineConstant.isEnabled() || this.fInlineMethod.isEnabled());
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ITypeRoot typeRoot = SelectionConverter.getInputAsTypeRoot(this.fEditor);
        if (typeRoot == null) {
            return;
        }
        CompilationUnit node = RefactoringASTParser.parseWithASTProvider(typeRoot, true, null);
        if (typeRoot instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)typeRoot;
            if (this.fInlineTemp.isEnabled() && this.fInlineTemp.tryInlineTemp(cu, node, selection, this.getShell())) {
                return;
            }
            if (this.fInlineConstant.isEnabled() && this.fInlineConstant.tryInlineConstant(cu, node, selection, this.getShell())) {
                return;
            }
        }
        if (this.fInlineMethod.isEnabled() && this.fInlineMethod.tryInlineMethod(typeRoot, node, selection, this.getShell())) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineAction_dialog_title, (String)RefactoringMessages.InlineAction_select);
    }

    public void run(IStructuredSelection selection) {
        if (this.fInlineConstant.isEnabled()) {
            this.fInlineConstant.run(selection);
        } else if (this.fInlineMethod.isEnabled()) {
            this.fInlineMethod.run(selection);
        } else {
            Assert.isTrue((!this.fInlineTemp.isEnabled() ? 1 : 0) != 0);
        }
    }
}

