/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class IntroduceIndirectionAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public IntroduceIndirectionAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public IntroduceIndirectionAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.IntroduceIndirectionAction_title);
        this.setToolTipText(RefactoringMessages.IntroduceIndirectionAction_tooltip);
        this.setDescription(RefactoringMessages.IntroduceIndirectionAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.introduce_indirection_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IMethod));
            this.run((IMethod)first);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement editorInput = SelectionConverter.getInput(this.fEditor);
            if (editorInput instanceof ICompilationUnit) {
                this.run(selection.getOffset(), selection.getLength(), (ICompilationUnit)editorInput);
            } else if (editorInput instanceof IClassFile) {
                this.run(selection.getOffset(), selection.getLength(), (IClassFile)editorInput);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.IntroduceIndirectionAction_dialog_title, RefactoringMessages.IntroduceIndirectionAction_unknown_exception);
        }
    }

    private void run(int offset, int length, ICompilationUnit unit) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)unit)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(unit, offset, length, this.getShell());
    }

    private void run(int offset, int length, IClassFile file) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)file)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(file, offset, length, this.getShell());
    }

    private void run(IMethod method) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)method)) {
            return;
        }
        RefactoringExecutionStarter.startIntroduceIndirectionRefactoring(method, this.getShell());
    }
}

