/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RemoveFromClasspathAction
extends SelectionDispatchAction {
    public RemoveFromClasspathAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.RemoveFromClasspathAction_Remove);
        this.setToolTipText(ActionMessages.RemoveFromClasspathAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.removefromclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(RemoveFromClasspathAction.checkEnabled(selection));
    }

    private static boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (RemoveFromClasspathAction.canRemove(iter.next())) continue;
            return false;
        }
        return true;
    }

    public void run(final IStructuredSelection selection) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        IPackageFragmentRoot[] roots = RemoveFromClasspathAction.getRootsToRemove(selection);
                        pm.beginTask(ActionMessages.RemoveFromClasspathAction_Removing, roots.length);
                        int i = 0;
                        while (i < roots.length) {
                            int jCoreFlags = 3;
                            roots[i].delete(0, jCoreFlags, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    pm.done();
                }
            }));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.RemoveFromClasspathAction_exception_dialog_title, ActionMessages.RemoveFromClasspathAction_Problems_occurred);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IPackageFragmentRoot[] getRootsToRemove(IStructuredSelection selection) {
        ArrayList result = new ArrayList(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!RemoveFromClasspathAction.canRemove(element)) continue;
            result.add(element);
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static boolean canRemove(Object element) {
        if (!(element instanceof IPackageFragmentRoot)) {
            return false;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)element;
        try {
            IClasspathEntry cpe = root.getRawClasspathEntry();
            return cpe != null && cpe.getEntryKind() != 5;
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            return false;
        }
    }
}

