/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameEnumConstProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameSelectionState;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameUserInterfaceStarter;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void openDialog(Shell parent) throws CoreException {
        this.openDialog(parent, false);
    }

    public boolean openDialog(Shell parent, boolean showPreviewOnly) throws CoreException {
        UserInterfaceStarter starter;
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return false;
        }
        if (!showPreviewOnly) {
            starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)this.fRefactoring);
        } else {
            starter = new RenameUserInterfaceStarter();
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)this.fRefactoring, this.fRefactoring.getName(), null, null, null){

                protected void addUserInputPages() {
                }
            };
            wizard.setForcePreviewReview(showPreviewOnly);
            starter.initialize(wizard);
        }
        return starter.activate((Refactoring)this.fRefactoring, parent, this.getJavaRenameProcessor().getSaveMode());
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
            RenameSelectionState state = this.createSelectionState();
            RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.getJavaRenameProcessor().getSaveMode(), parent, context);
            helper.perform(true, true);
            this.restoreSelectionState(state);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RenameSupport(RenameJavaElementDescriptor descriptor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fRefactoring = (RenameRefactoring)descriptor.createRefactoring(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            this.fPreCheckStatus = refactoringStatus;
        } else {
            this.preCheck();
            refactoringStatus.merge(this.fPreCheckStatus);
            this.fPreCheckStatus = refactoringStatus;
        }
    }

    public static RenameSupport create(RenameJavaElementDescriptor descriptor) throws CoreException {
        return new RenameSupport(descriptor);
    }

    private RenameSupport(JavaRenameProcessor processor, String newName, int flags) throws CoreException {
        this.fRefactoring = new JavaRenameRefactoring(processor);
        RenameSupport.initialize(this.fRefactoring, newName, flags);
    }

    private JavaRenameProcessor getJavaRenameProcessor() {
        return (JavaRenameProcessor)this.fRefactoring.getProcessor();
    }

    public static RenameSupport create(IJavaProject project, String newName, int flags) throws CoreException {
        RenameJavaProjectProcessor processor = new RenameJavaProjectProcessor(project);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IPackageFragmentRoot root, String newName) throws CoreException {
        RenameSourceFolderProcessor processor = new RenameSourceFolderProcessor(root);
        return new RenameSupport(processor, newName, 0);
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        RenamePackageProcessor processor = new RenamePackageProcessor(fragment);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        RenameCompilationUnitProcessor processor = new RenameCompilationUnitProcessor(unit);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        RenameTypeProcessor processor = new RenameTypeProcessor(type);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        RenameMethodProcessor processor = MethodChecks.isVirtual(method) ? new RenameVirtualMethodProcessor(method) : new RenameNonVirtualMethodProcessor(method);
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        if (JdtFlags.isEnum((IMember)field)) {
            return new RenameSupport(new RenameEnumConstProcessor(field), newName, flags);
        }
        RenameFieldProcessor processor = new RenameFieldProcessor(field);
        processor.setRenameGetter(RenameSupport.updateGetterMethod(flags));
        processor.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ITypeParameter parameter, String newName, int flags) throws CoreException {
        RenameTypeParameterProcessor processor = new RenameTypeParameterProcessor(parameter);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    public static RenameSupport create(ILocalVariable variable, String newName, int flags) throws CoreException {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(variable);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport(processor, newName, flags);
    }

    private static void initialize(RenameRefactoring refactoring, String newName, int flags) {
        ITextUpdating text;
        Class<?> clazz;
        IReferenceUpdating reference;
        if (refactoring.getProcessor() == null) {
            return;
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RenameSupport.setNewName((INameUpdating)refactoring.getAdapter((Class)clazz2), newName);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = (IReferenceUpdating)refactoring.getAdapter((Class)clazz3)) != null) {
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((text = (ITextUpdating)refactoring.getAdapter((Class)clazz)) != null) {
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 76;
        return (flags & TEXT_UPDATES) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)JavaUIMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)JavaUIMessages.RenameSupport_dialog_title, (String)message);
    }

    private RenameSelectionState createSelectionState() {
        RenameProcessor processor;
        Object[] elements;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ltk.core.refactoring.participants.RenameProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RenameSelectionState state = (elements = (processor = (RenameProcessor)this.fRefactoring.getAdapter((Class)clazz)).getElements()).length == 1 ? new RenameSelectionState(elements[0]) : null;
        return state;
    }

    private void restoreSelectionState(RenameSelectionState state) throws CoreException {
        Object newElement;
        INameUpdating nameUpdating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((nameUpdating = (INameUpdating)this.fRefactoring.getAdapter((Class)clazz)) != null && state != null && (newElement = nameUpdating.getNewElement()) != null) {
            state.restore(newElement);
        }
    }
}

