/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.provider.J2EEUtilityJarItemProvider;
import org.eclipse.jst.j2ee.navigator.internal.J2EEContentProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.BundledNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ear.ModulesNode;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class Ear5ContentProvider
extends J2EEContentProvider
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final Class IPROJECT_CLASS = IProject.class;
    public static final String EAR_DEFAULT_LIB = "lib";
    private Viewer viewer;

    private List getComponentReferencesAsList(List componentTypes, IVirtualComponent virtualComponent, IPath runtimePath) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = virtualComponent;
        if (earComponent != null) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)module))) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public IVirtualReference[] getUtilityModuleReferences(IVirtualComponent component) {
        List explicitUtilityReferences = this.getComponentReferencesAsList(Collections.singletonList("jst.utility"), component, null);
        List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb");
        List implicitUtilityReferences = this.getComponentReferencesAsList(implicitUtilityReferenceTypes, component, null);
        ArrayList allUtilityModuleReferences = new ArrayList();
        allUtilityModuleReferences.addAll(explicitUtilityReferences);
        allUtilityModuleReferences.addAll(implicitUtilityReferences);
        if (allUtilityModuleReferences.size() > 0) {
            return allUtilityModuleReferences.toArray(new IVirtualReference[allUtilityModuleReferences.size()]);
        }
        return new IVirtualReference[0];
    }

    public Object[] getChildren(Object aParentElement) {
        IProject project = null;
        ArrayList<Object> children = new ArrayList<Object>();
        if (aParentElement instanceof GroupEARProvider) {
            project = ((GroupEARProvider)aParentElement).getProject();
            IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)project);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear").getVersion("5.0"))) {
                    List libs = this.getComponentReferencesAsList(Collections.singletonList("jst.utility"), projectComponent, (IPath)new Path("/lib"));
                    ArrayList bundledLibs = new ArrayList();
                    ArrayList appLibsInTheRoot = new ArrayList();
                    int i = 0;
                    while (i < libs.size()) {
                        IVirtualReference reference = (IVirtualReference)libs.get(i);
                        IPath runtimePath = reference.getRuntimePath();
                        if (runtimePath != null && runtimePath.segment(0) != null && runtimePath.equals((Object)new Path("/lib"))) {
                            bundledLibs.add(libs.get(i));
                        } else {
                            appLibsInTheRoot.add(libs.get(i));
                        }
                        ++i;
                    }
                    BundledNode bundledLibsDirectoryNode = new BundledNode(project, bundledLibs, String.valueOf(Messages.LIBRARY_DIRECTORY) + ": /" + EAR_DEFAULT_LIB, null);
                    appLibsInTheRoot.add(bundledLibsDirectoryNode);
                    BundledNode bundledLibsNode = new BundledNode(project, appLibsInTheRoot, Messages.BUNDLED_LIBRARIES_NODE, bundledLibsDirectoryNode);
                    List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb", "jst.connector");
                    List modules = this.getComponentReferencesAsList(implicitUtilityReferenceTypes, projectComponent, (IPath)new Path("/"));
                    ModulesNode modulesNode = new ModulesNode(project, modules);
                    children.add(modulesNode);
                    children.add(bundledLibsNode);
                }
            }
            catch (CoreException e) {
                String msg = "Error in the JEEContentProvider.getChildren() for parent:" + aParentElement;
                JEEUIPlugin.getDefault();
                JEEUIPlugin.logError(msg, (Exception)((Object)e));
            }
        } else {
            if (aParentElement instanceof AbstractEarNode) {
                return ((AbstractEarNode)aParentElement).getModules().toArray();
            }
            if (aParentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS)) != null && J2EEProjectUtilities.isEARProject((IProject)project)) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear").getVersion("5.0"))) {
                        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                        GroupEARProvider element = new GroupEARProvider((EARVirtualComponent)component);
                        children.add(element);
                    }
                }
                catch (CoreException e) {
                    String msg = "Error in the JEEContentProvider.getChildren() for parent:" + aParentElement;
                    JEEUIPlugin.getDefault();
                    JEEUIPlugin.logError(msg, (Exception)((Object)e));
                }
            }
        }
        return children.toArray();
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.viewer = aViewer;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            String msg = "Error in the JEEContentProvider.resourceChanged()";
            JEEUIPlugin.getDefault();
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource;
        if (delta.getResource().getType() == 1 && J2EEUtilityJarItemProvider.isComponentFile((IResource)(resource = delta.getResource()))) {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    if (Ear5ContentProvider.this.viewer != null && !Ear5ContentProvider.this.viewer.getControl().isDisposed()) {
                        Ear5ContentProvider.this.viewer.refresh();
                    }
                }
            };
            Display.getDefault().asyncExec(refreshThread);
            return false;
        }
        return true;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AbstractEarNode) {
            return ((AbstractEarNode)element).getModules().size() > 0;
        }
        return element instanceof GroupEARProvider;
    }

    public Object getParent(Object object) {
        if (object instanceof AbstractEarNode) {
            return ((AbstractEarNode)object).getEarProject();
        }
        return null;
    }
}

