/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.navigator.internal.J2EEContentProvider;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractDDNode;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.JndiRefNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.ActivationConfigProperties;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanInterfaceNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3ContentProvider
extends J2EEContentProvider
implements IModelProviderListener {
    private static final Class IPROJECT_CLASS = IProject.class;
    private Viewer viewer;
    private static HashMap<IProject, IModelProvider> groupProvidersMap = new HashMap();

    public Object[] getChildren(Object aParentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        IProject project = null;
        if (aParentElement instanceof AbstractGroupProvider) {
            List lst = ((AbstractGroupProvider)aParentElement).getChildren();
            children.addAll(lst);
        } else if (aParentElement instanceof AbstractDDNode) {
            List lst = ((AbstractDDNode)aParentElement).getChildren();
            children.addAll(lst);
        } else if (aParentElement instanceof SessionBean) {
            SessionBean sb = (SessionBean)aParentElement;
            this.addSessionBeanSubNodes(sb, children);
        } else if (aParentElement instanceof EntityBean) {
            EntityBean eb = (EntityBean)aParentElement;
            this.addEntityBeanSubNodes(eb, children);
        } else if (aParentElement instanceof MessageDrivenBean) {
            BeanNode msgBean = new BeanNode((JavaEEObject)((MessageDrivenBean)aParentElement));
            this.addActivationConfigProperties((MessageDrivenBean)aParentElement, children);
            children.add(msgBean);
        } else if (aParentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS)) != null && this.isEjbModuleProject(project)) {
            IModelProvider modelProvider = groupProvidersMap.get(project);
            if (modelProvider != null) {
                GroupEJBProvider element = new GroupEJBProvider((EJBJar)modelProvider.getModelObject());
                element.setProjectName(project.getName());
                children.add(element);
            } else {
                modelProvider = ModelProviderManager.getModelProvider((IProject)project);
                modelProvider.addListener((IModelProviderListener)this);
                GroupEJBProvider element = new GroupEJBProvider((EJBJar)modelProvider.getModelObject());
                element.setProjectName(project.getName());
                children.add(element);
                groupProvidersMap.put(project, modelProvider);
            }
        }
        return children.toArray();
    }

    private void addActivationConfigProperties(MessageDrivenBean parentElement, List<Object> children) {
        if (parentElement.getActivationConfig() != null && parentElement.getActivationConfig().getActivationConfigProperties() != null && !parentElement.getActivationConfig().getActivationConfigProperties().isEmpty()) {
            children.add(new ActivationConfigProperties(parentElement.getActivationConfig().getActivationConfigProperties()));
        }
    }

    private void addEntityBeanSubNodes(EntityBean eb, List<Object> children) {
        if (eb.getLocal() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getLocal(), 2));
        }
        if (eb.getLocalHome() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getLocalHome(), 3));
        }
        if (eb.getRemote() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getRemote(), 4));
        }
        if (eb.getHome() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getHome(), 5));
        }
        children.add(new BeanNode((JavaEEObject)eb));
    }

    private void addSessionBeanSubNodes(SessionBean sb, List children) {
        this.addClassRelatedInfo(sb, children);
        this.addSessionJNDIRefInfo(sb, children);
    }

    private void addSessionJNDIRefInfo(SessionBean sb, List children) {
        if (sb.getEjbLocalRefs() != null && !sb.getEjbLocalRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getEjbLocalRefs(), 0));
        }
        if (sb.getEjbRefs() != null && !sb.getEjbRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getEjbRefs(), 1));
        }
        if (sb.getResourceEnvRefs() != null && !sb.getResourceEnvRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getResourceEnvRefs(), 3));
        }
        if (sb.getEnvEntries() != null && !sb.getEnvEntries().isEmpty()) {
            children.add(new JndiRefNode(sb.getEnvEntries(), 2));
        }
        if (sb.getResourceRefs() != null && !sb.getResourceRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getResourceRefs(), 4));
        }
        if (sb.getServiceRefs() != null && !sb.getServiceRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getServiceRefs(), 5));
        }
    }

    private void addSessionJNDIRefInfo(EntityBean eb, List children) {
        if (eb.getEjbLocalRefs() != null && !eb.getEjbLocalRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getEjbLocalRefs(), 0));
        }
        if (eb.getEjbRefs() != null && !eb.getEjbRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getEjbRefs(), 1));
        }
        if (eb.getResourceEnvRefs() != null && !eb.getResourceEnvRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getResourceEnvRefs(), 3));
        }
        if (eb.getEnvEntries() != null && !eb.getEnvEntries().isEmpty()) {
            children.add(new JndiRefNode(eb.getEnvEntries(), 2));
        }
        if (eb.getResourceRefs() != null && !eb.getResourceRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getResourceRefs(), 4));
        }
        if (eb.getServiceRefs() != null && !eb.getServiceRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getServiceRefs(), 5));
        }
    }

    private void addClassRelatedInfo(SessionBean sb, List children) {
        if (sb.getLocal() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getLocal(), 2));
        }
        if (sb.getLocalHome() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getLocalHome(), 3));
        }
        if (sb.getRemote() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getRemote(), 4));
        }
        if (sb.getHome() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getHome(), 5));
        }
        children.add(new BeanNode((JavaEEObject)sb));
        List r = sb.getBusinessLocals();
        for (Object locals : r) {
            children.add(new BeanInterfaceNode(sb, (String)locals, 0));
        }
        r = sb.getBusinessRemotes();
        for (Object locals : r) {
            children.add(new BeanInterfaceNode(sb, (String)locals, 1));
        }
    }

    private boolean isEjbModuleProject(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IProjectFacetVersion installedVersion = facetedProject.getInstalledVersion(ProjectFacetsManager.getProjectFacet((String)"jst.ejb").getVersion(IJ2EEFacetConstants.EJB_30.getVersionString()).getProjectFacet());
            return installedVersion != null;
        }
        catch (CoreException e) {
            JEEUIPlugin.logError("Can not acces project", (Exception)((Object)e));
            return false;
        }
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AbstractGroupProvider) {
            return ((AbstractGroupProvider)element).hasChildren();
        }
        if (element instanceof AbstractDDNode) {
            return ((AbstractDDNode)element).hasChildren();
        }
        if (element instanceof SessionBean) {
            return true;
        }
        if (element instanceof EntityBean) {
            return true;
        }
        return element instanceof MessageDrivenBean;
    }

    public void projectChanged(final IProject project) {
        try {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    if (Ejb3ContentProvider.this.viewer != null) {
                        ISelection sel = ((TreeViewer)Ejb3ContentProvider.this.viewer).getSelection();
                        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)Ejb3ContentProvider.this.viewer).getContentProvider();
                        contentProvider.getChildren((Object)project);
                        ((StructuredViewer)Ejb3ContentProvider.this.viewer).refresh((Object)project);
                        ((TreeViewer)Ejb3ContentProvider.this.viewer).setSelection(sel);
                    }
                }
            };
            Display.getDefault().asyncExec(refreshThread);
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during refresh", e);
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.projectChanged(event.getProject());
    }

    public void dispose() {
        groupProvidersMap.clear();
    }
}

