/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.navigator.internal.J2EEContentProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Display;

public class Web25ContentProvider
extends J2EEContentProvider
implements IModelProviderListener {
    private static final Class IPROJECT_CLASS = IProject.class;
    private Viewer viewer;
    private static HashMap<IProject, IModelProvider> groupProvidersMap = new HashMap();

    public Object[] getChildren(Object aParentElement) {
        ArrayList<WebAppProvider> children = new ArrayList<WebAppProvider>();
        IProject project = null;
        if (aParentElement instanceof IAdaptable) {
            project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS);
            if (project != null) {
                IModelProvider provider = groupProvidersMap.get(project);
                if (provider != null) {
                    Object mObj = provider.getModelObject();
                    children.add(new WebAppProvider((WebApp)mObj, project));
                } else {
                    provider = ModelProviderManager.getModelProvider((IProject)project);
                    provider.addListener((IModelProviderListener)this);
                    Object mObj = provider.getModelObject();
                    WebAppProvider webProvider = new WebAppProvider((WebApp)mObj, project);
                    children.add(webProvider);
                    groupProvidersMap.put(project, provider);
                }
            }
        } else if (aParentElement instanceof WebAppProvider) {
            children.addAll(((WebAppProvider)aParentElement).getChildren());
        } else if (aParentElement instanceof AbstractGroupProvider) {
            children.addAll(((AbstractGroupProvider)aParentElement).getChildren());
        }
        return children.toArray();
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
    }

    public void dispose() {
        groupProvidersMap.clear();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof WebAppProvider) {
            return true;
        }
        if (element instanceof AbstractGroupProvider) {
            return ((AbstractGroupProvider)element).hasChildren();
        }
        return false;
    }

    private void j2eeRefreshContent() {
        try {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    Web25ContentProvider.this.viewer.refresh();
                }
            };
            Display.getDefault().asyncExec(refreshThread);
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during refresh", e);
        }
    }

    public void projectChanged(final IProject project) {
        try {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    if (Web25ContentProvider.this.viewer != null) {
                        ISelection sel = ((TreeViewer)Web25ContentProvider.this.viewer).getSelection();
                        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)Web25ContentProvider.this.viewer).getContentProvider();
                        contentProvider.getChildren((Object)project);
                        ((StructuredViewer)Web25ContentProvider.this.viewer).refresh((Object)project);
                        ((TreeViewer)Web25ContentProvider.this.viewer).setSelection(sel);
                    }
                }
            };
            Display.getDefault().asyncExec(refreshThread);
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during refresh", e);
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.projectChanged(event.getProject());
    }
}

