/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.appclient;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class GroupAppClientProvider {
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application-client.xml";
    private static Image APP_CLIENT50;
    private IProject project = null;
    private ApplicationClient model = null;
    protected List children;
    private Object javaee = null;
    private IFile ddFile;

    public GroupAppClientProvider(IProject project) {
        this.project = project;
        this.javaee = this.getModel();
    }

    private ApplicationClient getModel() {
        if (this.model != null) {
            return this.model;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this.project);
        Object modelObject = null;
        try {
            modelObject = modelProvider.getModelObject();
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during initializing model", e);
        }
        if (modelObject != null && modelObject instanceof ApplicationClient) {
            return (ApplicationClient)modelObject;
        }
        return null;
    }

    public String getText() {
        String result = null;
        result = this.project == null ? Messages.DEPLOYMENT_DESCRIPTOR : String.valueOf(Messages.DEPLOYMENT_DESCRIPTOR) + this.project.getName();
        return result;
    }

    public List getChildren() {
        ArrayList result = new ArrayList();
        if (this.javaee != null) {
            result.addAll(((ApplicationClient)this.javaee).getEjbRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceRefs());
            result.addAll(((ApplicationClient)this.javaee).getResourceEnvRefs());
            result.addAll(((ApplicationClient)this.javaee).getEnvEntries());
            result.addAll(((ApplicationClient)this.javaee).getMessageDestinationRefs());
            result.addAll(((ApplicationClient)this.javaee).getPersistenceUnitRefs());
            result.addAll(((ApplicationClient)this.javaee).getServiceRefs());
        }
        return result;
    }

    public static Image getImage() {
        if (APP_CLIENT50 == null) {
            ImageDescriptor imageDescriptor = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.APP_CLIENT50);
            APP_CLIENT50 = imageDescriptor.createImage();
        }
        return APP_CLIENT50;
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.project).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }
}

