/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class LaunchClientJob
extends ChainedJob {
    protected IModule[] module;
    protected IClient client;
    protected ILaunchableAdapter launchableAdapter;
    protected String launchMode;
    protected IModuleArtifact moduleArtifact;

    public LaunchClientJob(IServer server, IModule[] module, String launchMode, IModuleArtifact moduleArtifact, ILaunchableAdapter launchableAdapter, IClient client) {
        super(Messages.launchingClientTask, server);
        this.module = module;
        this.launchMode = launchMode;
        this.moduleArtifact = moduleArtifact;
        this.launchableAdapter = launchableAdapter;
        this.client = client;
        this.setRule((ISchedulingRule)new ServerSchedulingRule(server));
    }

    protected IStatus run(IProgressMonitor monitor) {
        Trace.trace((byte)5, "LaunchClient job");
        final Server server = (Server)this.getServer();
        int state = server.getModuleState(this.module);
        int count = ServerPreferences.getInstance().getModuleStartTimeout();
        while (state == 1 && count > 0) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            count -= 2000;
            state = server.getModuleState(this.module);
        }
        Trace.trace((byte)5, "LaunchClient job 2 " + state);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (state == 1) {
            return Status.OK_STATUS;
        }
        Trace.trace((byte)5, "LaunchClient job 3");
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Trace.trace((byte)4, "Attempting to load client: " + LaunchClientJob.this.client.getId());
                try {
                    Object launchable = LaunchClientJob.this.launchableAdapter.getLaunchable((IServer)server, LaunchClientJob.this.moduleArtifact);
                    IStatus status = LaunchClientJob.this.client.launch((IServer)server, launchable, LaunchClientJob.this.launchMode, server.getLaunch());
                    if (status != null && status.getSeverity() == 4) {
                        EclipseUtil.openError(null, status);
                    }
                }
                catch (CoreException ce) {
                    EclipseUtil.openError(null, ce.getStatus());
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Server client failed", e);
                }
            }
        });
        Trace.trace((byte)5, "LaunchClient job 4");
        return Status.OK_STATUS;
    }
}

