/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.LaunchClientJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerProcess;

public class RunOnServerLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_SERVER_ID = "server-id";
    public static final String ATTR_MODULE_ARTIFACT = "module-artifact";
    public static final String ATTR_MODULE_ARTIFACT_CLASS = "module-artifact-class";
    public static final String ATTR_LAUNCHABLE_ADAPTER_ID = "launchable-adapter-id";
    public static final String ATTR_CLIENT_ID = "client-id";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String launchMode, ILaunch launch2, IProgressMonitor monitor) throws CoreException {
        block38: {
            int state;
            IModule[] modules;
            IClient client;
            ILaunchableAdapter launchableAdapter;
            ModuleArtifactDelegate moduleArtifact;
            IServer server;
            block40: {
                boolean restart;
                IAdaptable info;
                block41: {
                    int result;
                    boolean disabledBreakpoints;
                    IBreakpointManager breakpointManager;
                    Shell shell;
                    block37: {
                        int result2;
                        boolean breakpointsOption;
                        String mode;
                        block42: {
                            block39: {
                                String serverId = configuration.getAttribute(ATTR_SERVER_ID, null);
                                String moduleArt = configuration.getAttribute(ATTR_MODULE_ARTIFACT, null);
                                String moduleArtifactClass = configuration.getAttribute(ATTR_MODULE_ARTIFACT_CLASS, null);
                                String laId = configuration.getAttribute(ATTR_LAUNCHABLE_ADAPTER_ID, null);
                                String clientId = configuration.getAttribute(ATTR_CLIENT_ID, null);
                                server = ServerCore.findServer((String)serverId);
                                IModule module = null;
                                moduleArtifact = null;
                                launchableAdapter = null;
                                if (laId != null) {
                                    launchableAdapter = ServerPlugin.findLaunchableAdapter((String)laId);
                                }
                                client = ServerPlugin.findClient((String)clientId);
                                try {
                                    Class<?> c = Class.forName(moduleArtifactClass);
                                    moduleArtifact = (ModuleArtifactDelegate)c.newInstance();
                                    moduleArtifact.deserialize(moduleArt);
                                    module = moduleArtifact.getModule();
                                }
                                catch (Throwable throwable) {
                                    Trace.trace((byte)2, "Could not load module artifact delegate class");
                                }
                                if (moduleArtifact == null) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
                                }
                                if (module == null) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
                                }
                                if (server == null) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorInvalidServer));
                                }
                                if (launchableAdapter == null) {
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.ui", Messages.errorLaunchConfig));
                                }
                                final Shell[] shell2 = new Shell[1];
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        shell2[0] = EclipseUtil.getShell();
                                    }
                                });
                                shell = shell2[0];
                                info = new IAdaptable(){

                                    public Object getAdapter(Class adapter) {
                                        if (Shell.class.equals((Object)adapter)) {
                                            return shell;
                                        }
                                        return null;
                                    }
                                };
                                if (client == null) {
                                    client = new IClient(){

                                        public String getDescription() {
                                            return Messages.clientDefaultDescription;
                                        }

                                        public String getId() {
                                            return "org.eclipse.wst.server.ui.client.default";
                                        }

                                        public String getName() {
                                            return Messages.clientDefaultName;
                                        }

                                        public IStatus launch(IServer server3, Object launchable2, String launchMode3, ILaunch launch) {
                                            return Status.OK_STATUS;
                                        }

                                        public boolean supports(IServer server3, Object launchable2, String launchMode3) {
                                            return true;
                                        }
                                    };
                                }
                                Trace.trace((byte)4, "Ready to launch");
                                launch2.addProcess((IProcess)new RunOnServerProcess(launch2));
                                modules = new IModule[]{module};
                                state = server.getServerState();
                                if (state != 1) break block39;
                                LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
                                clientJob.schedule();
                                break block38;
                            }
                            if (state != 2) break block40;
                            restart = false;
                            mode = server.getMode();
                            breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                            disabledBreakpoints = false;
                            if (server.getServerRestartState()) {
                                result = RunOnServerActionDelegate.openRestartDialog(shell);
                                if (result == 0) {
                                    launchMode = mode;
                                    restart = true;
                                } else if (result == 9) {
                                    launch2.terminate();
                                    return;
                                }
                            }
                            if (restart) break block41;
                            if ("run".equals(mode) || !"run".equals(launchMode)) break block42;
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizRunOnServerTitle, Messages.dialogModeWarningRun, breakpointsOption)) == 0) {
                                restart = true;
                                break block37;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                launchMode = mode;
                                break block37;
                            } else {
                                if (result2 != 2) {
                                    launch2.terminate();
                                    return;
                                }
                                launchMode = mode;
                            }
                            break block37;
                        }
                        if (!"debug".equals(mode) && "debug".equals(launchMode)) {
                            result = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizDebugOnServerTitle, Messages.dialogModeWarningDebug, false);
                            if (result == 0) {
                                restart = true;
                            } else {
                                if (result != 1) {
                                    launch2.terminate();
                                    return;
                                }
                                launchMode = mode;
                            }
                        } else if (!"profile".equals(mode) && "profile".equals(launchMode)) {
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizProfileOnServerTitle, Messages.dialogModeWarningProfile, breakpointsOption)) == 0) {
                                restart = true;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                launchMode = mode;
                            } else {
                                if (result2 != 2) {
                                    launch2.terminate();
                                    return;
                                }
                                launchMode = mode;
                            }
                        }
                    }
                    if ("debug".equals(launchMode) && !breakpointManager.isEnabled() && !disabledBreakpoints) {
                        result = RunOnServerActionDelegate.openBreakpointDialog(shell);
                        if (result == 0) {
                            breakpointManager.setEnabled(true);
                        } else if (result != 1) {
                            launch2.terminate();
                            return;
                        }
                    }
                }
                final LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
                if (restart) {
                    final IServer server2 = server;
                    server.restart(launchMode, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                            server2.publish(1, null, info, new IServer.IOperationListener(){

                                public void done(IStatus result2) {
                                    if (result2.isOK()) {
                                        clientJob.schedule();
                                    }
                                }
                            });
                        }
                    });
                    break block38;
                } else {
                    server.publish(1, null, info, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                            if (result.isOK()) {
                                clientJob.schedule();
                            }
                        }
                    });
                }
                break block38;
            }
            if (state != 3) {
                final LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, (IModuleArtifact)moduleArtifact, launchableAdapter, client);
                server.start(launchMode, new IServer.IOperationListener(){

                    public void done(IStatus result) {
                        if (result.isOK()) {
                            clientJob.schedule();
                        }
                    }
                });
            }
        }
        launch2.terminate();
    }
}

