/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.ui.internal.editor.IOrdered;
import org.eclipse.wst.server.ui.internal.wizard.fragment.SubTasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksWizardFragment
extends WizardFragment {
    protected List tasks;
    protected boolean hasOptionalTasks;
    protected boolean hasPreferredTasks;
    protected Map<String, Boolean> selectedTaskMap = new HashMap<String, Boolean>();

    @Override
    protected void createChildFragments(List<WizardFragment> list) {
        if (this.tasks == null || this.tasks.isEmpty()) {
            return;
        }
        int TASKS_PER_PAGE = 5;
        int size = this.tasks.size();
        int pages = (size - 1) / TASKS_PER_PAGE + 1;
        int i = 0;
        while (i < pages) {
            SubTasksWizardFragment fragment = new SubTasksWizardFragment();
            List list2 = this.tasks.subList(TASKS_PER_PAGE * i, Math.min(size, TASKS_PER_PAGE * (i + 1)));
            fragment.updateTasks(list2);
            list.add(fragment);
            ++i;
        }
    }

    @Override
    public void enter() {
        this.updateTasks();
    }

    @Override
    public List getChildFragments() {
        this.updateTasks();
        return super.getChildFragments();
    }

    @Override
    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.updateTasks();
    }

    public void updateTasks() {
        if (this.getTaskModel() == null) {
            this.tasks = null;
            return;
        }
        IServerAttributes server = (IServerAttributes)this.getTaskModel().getObject("server");
        ArrayList modules = (ArrayList)this.getTaskModel().getObject("modules");
        if (server != null && modules == null) {
            final ArrayList moduleList = new ArrayList();
            ((Server)server).visit(new IModuleVisitor(){

                public boolean visit(IModule[] module2) {
                    moduleList.add(module2);
                    return true;
                }
            }, null);
            modules = moduleList;
        }
        if (server != null && modules != null) {
            this.hasOptionalTasks = false;
            this.hasPreferredTasks = false;
            ArrayList<TaskInfo> taskList = new ArrayList<TaskInfo>(5);
            this.createTasks(taskList, server, modules);
            if (this.tasks == null || !this.tasks.equals(taskList)) {
                this.tasks = taskList;
                this.updateChildFragments();
                boolean b = this.hasOptionalTasks || this.hasPreferredTasks;
                this.getTaskModel().putObject("hasTasks", (Object)new Boolean(b));
            }
        }
    }

    protected void createTasks(List<TaskInfo> taskList, IServerAttributes server, List modules) {
        if (server == null) {
            return;
        }
        List enabledTasks = ((Server)server).getEnabledOptionalPublishOperationIds();
        List disabledTasks = ((Server)server).getDisabledPreferredPublishOperationIds();
        PublishOperation[] tasks2 = ((Server)server).getAllTasks(modules);
        int j = 0;
        while (j < tasks2.length) {
            int kind = tasks2[j].getKind();
            String id = ((Server)server).getPublishOperationId(tasks2[j]);
            if (kind == 0 || kind == 1) {
                this.hasOptionalTasks = true;
            }
            if (kind == 1) {
                this.hasPreferredTasks = true;
            }
            tasks2[j].setTaskModel(this.getTaskModel());
            boolean selected = true;
            if (kind == 0) {
                if (!enabledTasks.contains(id)) {
                    selected = false;
                }
            } else if (kind == 1 && disabledTasks.contains(id)) {
                selected = false;
            }
            taskList.add(this.getServerTask(server, tasks2[j], selected));
            ++j;
        }
    }

    public TaskInfo getServerTask(IServerAttributes server, PublishOperation task2, boolean selected) {
        TaskInfo sti = new TaskInfo();
        sti.task2 = task2;
        sti.kind = task2.getKind();
        sti.id = ((Server)server).getPublishOperationId(task2);
        sti.setDefaultSelected(selected);
        return sti;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (!this.hasOptionalTasks) {
            return;
        }
        if (this.tasks == null || this.tasks.isEmpty()) {
            return;
        }
        TaskModel taskModel = this.getTaskModel();
        IServer server = (IServer)taskModel.getObject("server");
        if (server == null) {
            return;
        }
        boolean createdWC = false;
        ServerWorkingCopy wc = null;
        if (server instanceof ServerWorkingCopy) {
            wc = (ServerWorkingCopy)server;
        } else {
            wc = (ServerWorkingCopy)server.createWorkingCopy();
            createdWC = true;
        }
        wc.resetPreferredPublishOperations();
        wc.resetOptionalPublishOperations();
        for (TaskInfo task : this.tasks) {
            if (2 == task.kind) continue;
            if (1 == task.kind) {
                if (task.isSelected()) continue;
                wc.disablePreferredPublishOperations(task.task2);
                continue;
            }
            if (task.kind != 0 || !task.isSelected()) continue;
            wc.enableOptionalPublishOperations(task.task2);
        }
        if (createdWC && wc.isDirty()) {
            wc.save(true, monitor);
        }
        monitor.done();
    }

    public class TaskInfo
    implements IOrdered {
        public int kind;
        public String id;
        public PublishOperation task2;
        private static final String DEFAULT = "default:";

        public boolean isSelected() {
            if (this.id == null) {
                return false;
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(this.id)) {
                return TasksWizardFragment.this.selectedTaskMap.get(this.id);
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(DEFAULT + this.id)) {
                return TasksWizardFragment.this.selectedTaskMap.get(DEFAULT + this.id);
            }
            return false;
        }

        public void setDefaultSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(DEFAULT + this.getId(), new Boolean(sel));
        }

        public boolean getDefaultSelected() {
            return TasksWizardFragment.this.selectedTaskMap.get(DEFAULT + this.id);
        }

        public void setSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(this.getId(), new Boolean(sel));
        }

        public int getOrder() {
            return this.task2.getOrder();
        }

        protected String getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            block11: {
                TaskInfo ti;
                block14: {
                    block13: {
                        block12: {
                            if (!(obj instanceof TaskInfo)) {
                                return false;
                            }
                            ti = (TaskInfo)obj;
                            if (this.kind != ti.kind) {
                                return false;
                            }
                            if (this.id == null || !this.id.equals(ti.id)) {
                                return false;
                            }
                            if (this.task2 == null && ti.task2 != null) {
                                return false;
                            }
                            if (this.task2 != null && ti.task2 == null) {
                                return false;
                            }
                            try {
                                if (this.task2 == null || ti.task2 == null) break block11;
                                if (this.task2.getKind() == ti.task2.getKind()) break block12;
                                return false;
                            }
                            catch (Exception exception) {}
                        }
                        if (this.task2.getOrder() == ti.task2.getOrder()) break block13;
                        return false;
                    }
                    if (this.task2.getLabel().equals(ti.task2.getLabel())) break block14;
                    return false;
                }
                if (!this.task2.getDescription().equals(ti.task2.getDescription())) {
                    return false;
                }
            }
            return true;
        }
    }
}

