/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.wizards.ImportXMLCatalogPage;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class ImportXMLCatalogWizard
extends Wizard
implements IImportWizard {
    protected ImportXMLCatalogPage importPage = null;
    protected ICatalog workingUserCatalog = null;
    protected ICatalog userCatalog = null;

    public ImportXMLCatalogWizard() {
        this.setWindowTitle(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_IMPORT_TITLE);
        ImageDescriptor descriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/generatexml_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "user_catalog".equals(referencedCatalog.getId())) {
                this.userCatalog = referencedCatalog;
            }
            ++i;
        }
        CatalogSet tempCatalogSet = new CatalogSet();
        this.workingUserCatalog = tempCatalogSet.lookupOrCreateCatalog("working", "");
        this.workingUserCatalog.addEntriesFromCatalog(this.userCatalog);
    }

    public boolean performFinish() {
        IFile file = this.importPage.getFile();
        if (file != null) {
            String fileName = file.getLocation().toFile().toURI().toString();
            try {
                CatalogSet tempResourceSet = new CatalogSet();
                Catalog newCatalog = tempResourceSet.lookupOrCreateCatalog("temp", fileName);
                this.workingUserCatalog.addEntriesFromCatalog((ICatalog)newCatalog);
                this.userCatalog.clear();
                this.userCatalog.addEntriesFromCatalog(this.workingUserCatalog);
                this.userCatalog.save();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.importPage = new ImportXMLCatalogPage();
        this.importPage.setTitle(XMLCatalogMessages.UI_LABEL_IMPORT_DIALOG_HEADING);
        this.importPage.setDescription(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_IMPORT_DESCRIPTION);
        this.importPage.setMessage(XMLCatalogMessages.UI_LABEL_IMPORT_DIALOG_MESSAGE);
        this.addPage((IWizardPage)this.importPage);
    }
}

