/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntimeChecker;

public class ServiceRuntimeDescriptor {
    private IConfigurationElement elem;
    private Hashtable allWebServiceImpls;
    private Hashtable allRuntimes;
    private String id;
    private WebServiceImpl serviceImplementationType;
    private RuntimeDescriptor runtime;
    private boolean bottomUp = false;
    private boolean topDown = false;
    private String serviceRuntimeClassName;
    private IWebServiceRuntime webServiceRuntime;
    private RequiredFacetVersion[] requiredFacetVersions;
    private Set projectFacetVersions;
    private IWebServiceRuntimeChecker webServiceRuntimeChecker;
    private String runtimePreferredServerType;

    public ServiceRuntimeDescriptor(IConfigurationElement elem, Hashtable allWebServiceImpls, Hashtable allRuntimes) {
        this.elem = elem;
        this.allWebServiceImpls = allWebServiceImpls;
        this.allRuntimes = allRuntimes;
        this.bottomUp = Boolean.valueOf(elem.getAttribute("bottomUp"));
        this.topDown = Boolean.valueOf(elem.getAttribute("topDown"));
    }

    public boolean getBottomUp() {
        return this.bottomUp;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.elem.getAttribute("id");
        }
        return this.id;
    }

    public RequiredFacetVersion[] getRequiredFacetVersions() {
        if (this.requiredFacetVersions == null) {
            ArrayList<RequiredFacetVersion> requiredFacetVersionList = new ArrayList<RequiredFacetVersion>();
            IConfigurationElement[] facetElems = this.elem.getChildren("required-facet-version");
            int i = 0;
            while (i < facetElems.length) {
                String facetID = facetElems[i].getAttribute("facet");
                if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
                    RequiredFacetVersion rfv = new RequiredFacetVersion();
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)facetID);
                    IProjectFacetVersion projectFacetVersion = projectFacet.getVersion(facetElems[i].getAttribute("version"));
                    rfv.setProjectFacetVersion(projectFacetVersion);
                    String allowNewerValue = facetElems[i].getAttribute("allow-newer");
                    if (allowNewerValue == null) {
                        rfv.setAllowNewer(false);
                    } else {
                        rfv.setAllowNewer(Boolean.valueOf(allowNewerValue).booleanValue());
                    }
                    requiredFacetVersionList.add(rfv);
                }
                ++i;
            }
            this.requiredFacetVersions = requiredFacetVersionList.toArray(new RequiredFacetVersion[0]);
        }
        return this.requiredFacetVersions;
    }

    public Set getProjectFacetVersions() {
        if (this.projectFacetVersions == null) {
            this.projectFacetVersions = new HashSet();
            RequiredFacetVersion[] rfv = this.getRequiredFacetVersions();
            int i = 0;
            while (i < rfv.length) {
                this.projectFacetVersions.add(rfv[i].getProjectFacetVersion());
                ++i;
            }
        }
        return this.projectFacetVersions;
    }

    public RuntimeDescriptor getRuntime() {
        if (this.runtime == null) {
            String runtimeId = this.elem.getAttribute("runtimeId");
            this.runtime = (RuntimeDescriptor)this.allRuntimes.get(runtimeId);
        }
        return this.runtime;
    }

    public WebServiceImpl getServiceImplementationType() {
        if (this.serviceImplementationType == null) {
            String serviceImplementationTypeId = this.elem.getAttribute("serviceImplementationTypeId");
            this.serviceImplementationType = (WebServiceImpl)this.allWebServiceImpls.get(serviceImplementationTypeId);
        }
        return this.serviceImplementationType;
    }

    public String getServiceRuntimeClassName() {
        if (this.serviceRuntimeClassName == null) {
            this.serviceRuntimeClassName = this.elem.getAttribute("class");
        }
        return this.serviceRuntimeClassName;
    }

    public boolean getTopDown() {
        return this.topDown;
    }

    public IWebServiceRuntime getWebServiceRuntime() {
        if (this.webServiceRuntime == null) {
            try {
                this.webServiceRuntime = (IWebServiceRuntime)this.elem.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return this.webServiceRuntime;
    }

    public IWebServiceRuntimeChecker getServiceRuntimeChecker() {
        if (this.webServiceRuntimeChecker == null) {
            try {
                if (this.elem.getAttribute("runtimeChecker") != null) {
                    this.webServiceRuntimeChecker = (IWebServiceRuntimeChecker)this.elem.createExecutableExtension("runtimeChecker");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.webServiceRuntimeChecker;
    }

    public String getRuntimePreferredServerType() {
        if (this.runtimePreferredServerType == null) {
            this.runtimePreferredServerType = this.elem.getAttribute("runtimePreferredServerType");
        }
        return this.runtimePreferredServerType;
    }
}

