/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMElementDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TLDFileHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TaglibJarUriHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.URLFileRegionHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaglibHyperlinkDetector
extends AbstractHyperlinkDetector {
    private final String HTTP_PROTOCOL = "http://";
    private final String JAR_PROTOCOL = "jar:file:";
    private String URN_TLD = "urn:jsptld:";
    private String XMLNS = "xmlns:";
    static final int TAG = 1;
    static final int ATTRIBUTE = 2;

    static IRegion findDefinition(IDOMModel model, String searchName, int searchType) {
        NodeList declarations = null;
        if (searchType == 1) {
            declarations = model.getDocument().getElementsByTagNameNS("*", "tag");
        } else if (searchType == 2) {
            declarations = model.getDocument().getElementsByTagNameNS("*", "attribute");
        }
        if (declarations == null || declarations.getLength() == 0) {
            if (searchType == 1) {
                declarations = model.getDocument().getElementsByTagName("tag");
            } else if (searchType == 2) {
                declarations = model.getDocument().getElementsByTagName("attribute");
            }
        }
        int i = 0;
        while (i < declarations.getLength()) {
            NodeList names = model.getDocument().getElementsByTagName("name");
            int j = 0;
            while (j < names.getLength()) {
                String name = TaglibHyperlinkDetector.getContainedText(names.item(j));
                if (searchName.compareTo(name) == 0) {
                    int start = -1;
                    int end = -1;
                    Node caret = names.item(j).getFirstChild();
                    if (caret != null) {
                        start = ((IDOMNode)caret).getStartOffset();
                    }
                    while (caret != null) {
                        end = ((IDOMNode)caret).getEndOffset();
                        caret = caret.getNextSibling();
                    }
                    if (start > 0) {
                        return new Region(start, end - start);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        TaglibJarUriHyperlink hyperlink;
        block26: {
            IDocument doc;
            hyperlink = null;
            if (textViewer != null && region != null && (doc = textViewer.getDocument()) != null) {
                try {
                    Node currentNode;
                    ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)region.getOffset(), (boolean)false);
                    if (partition == null || partition.getType() != "org.eclipse.jst.jsp.JSP_DIRECTIVE" || (currentNode = this.getCurrentNode(doc, region.getOffset())) == null || currentNode.getNodeType() != 1) break block26;
                    if ("jsp:directive.taglib".equalsIgnoreCase(currentNode.getNodeName())) {
                        ITaglibRecord reference;
                        Attr taglibURINode = ((Element)currentNode).getAttributeNode("uri");
                        if (taglibURINode == null || (reference = TaglibIndex.resolve((String)this.getBaseLocationForTaglib(doc), (String)taglibURINode.getValue(), (boolean)false)) == null) break block26;
                        switch (reference.getRecordType()) {
                            case 1: {
                                ITLDRecord record = (ITLDRecord)reference;
                                String uriString = record.getPath().toString();
                                IRegion hyperlinkRegion = this.getHyperlinkRegion(taglibURINode, region);
                                if (hyperlinkRegion != null) {
                                    hyperlink = this.createHyperlink(uriString, hyperlinkRegion, doc, null);
                                    break;
                                }
                                break block26;
                            }
                            case 2: 
                            case 4: {
                                IRegion hyperlinkRegion = this.getHyperlinkRegion(taglibURINode, region);
                                if (hyperlinkRegion == null) break block26;
                                hyperlink = new TaglibJarUriHyperlink(hyperlinkRegion, reference);
                            }
                            default: {
                                break;
                            }
                        }
                        break block26;
                    }
                    if ("jsp:root".equalsIgnoreCase(currentNode.getNodeName())) {
                        NamedNodeMap attrs = currentNode.getAttributes();
                        int i = 0;
                        while (i < attrs.getLength()) {
                            Attr attr = (Attr)attrs.item(i);
                            if (attr.getNodeName().startsWith(this.XMLNS)) {
                                ITaglibRecord reference;
                                String uri = StringUtils.strip((String)attr.getNodeValue());
                                if (uri.startsWith(this.URN_TLD)) {
                                    uri = uri.substring(this.URN_TLD.length());
                                }
                                if ((reference = TaglibIndex.resolve((String)this.getBaseLocationForTaglib(doc), (String)uri, (boolean)false)) != null) {
                                    switch (reference.getRecordType()) {
                                        case 1: {
                                            ITLDRecord record = (ITLDRecord)reference;
                                            String uriString = record.getPath().toString();
                                            IRegion hyperlinkRegion = this.getHyperlinkRegion(attr, region);
                                            if (hyperlinkRegion == null) break;
                                            hyperlink = this.createHyperlink(uriString, hyperlinkRegion, doc, null);
                                            break;
                                        }
                                        case 2: 
                                        case 4: {
                                            IRegion hyperlinkRegion = this.getHyperlinkRegion(attr, region);
                                            if (hyperlinkRegion == null) break;
                                            hyperlink = new TaglibJarUriHyperlink(hyperlinkRegion, reference);
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        TLDCMDocumentManager documentManager = TaglibController.getTLDCMDocumentManager((IDocument)doc);
                        if (documentManager != null) {
                            List documentTrackers = documentManager.getCMDocumentTrackers(currentNode.getPrefix(), region.getOffset());
                            int i = 0;
                            while (i < documentTrackers.size()) {
                                TaglibTracker tracker = (TaglibTracker)documentTrackers.get(i);
                                CMElementDeclaration decl = (CMElementDeclaration)tracker.getElements().getNamedItem(currentNode.getNodeName());
                                if (decl != null && (decl = (CMElementDeclaration)((CMNodeWrapper)decl).getOriginNode()) instanceof CMElementDeclarationImpl) {
                                    String base = ((CMElementDeclarationImpl)decl).getLocationString();
                                    IRegion hyperlinkRegion = this.getHyperlinkRegion(currentNode, region);
                                    if (hyperlinkRegion != null) {
                                        hyperlink = this.createHyperlink(base, hyperlinkRegion, doc, currentNode);
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (BadLocationException e) {
                    Logger.log(202, e.getMessage(), e);
                }
            }
        }
        if (hyperlink != null) {
            return new IHyperlink[]{hyperlink};
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String getBaseLocationForTaglib(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IRegion getHyperlinkRegion(Node node, IRegion boundingRegion) {
        Region hyperRegion = null;
        if (node != null) {
            IDOMNode docNode;
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion != null) {
                    int regLength = valueRegion.getTextLength();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    hyperRegion = new Region(regOffset, regLength);
                }
            }
            if (nodeType == 1 && (hyperRegion = this.getNameRegion((ITextRegionCollection)(docNode = (IDOMNode)node).getFirstStructuredDocumentRegion())) == null) {
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getFirstStructuredDocumentRegion().getTextLength());
            }
        }
        if (hyperRegion != null && this.intersects((IRegion)hyperRegion, boundingRegion)) {
            return hyperRegion;
        }
        return null;
    }

    private boolean intersects(IRegion hyperlinkRegion, IRegion detectionRegion) {
        int hyperLinkStart = hyperlinkRegion.getOffset();
        int hyperLinkEnd = hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
        int detectionStart = detectionRegion.getOffset();
        int detectionEnd = detectionRegion.getOffset() + detectionRegion.getLength();
        return hyperLinkStart <= detectionStart && detectionStart < hyperLinkEnd || hyperLinkStart <= detectionEnd && detectionEnd < hyperLinkEnd;
    }

    private IRegion getNameRegion(ITextRegionCollection containerRegion) {
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion nameRegion = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameRegion = r;
                break;
            }
            ++i;
        }
        if (nameRegion != null) {
            return new Region(containerRegion.getStartOffset(nameRegion), nameRegion.getTextLength());
        }
        return null;
    }

    private IHyperlink createHyperlink(String uriString, IRegion hyperlinkRegion, IDocument document, Node node) {
        Object link = null;
        if (uriString != null) {
            String temp = uriString.toLowerCase();
            if (temp.startsWith("http://")) {
                link = new URLHyperlink(hyperlinkRegion, uriString);
            } else if (temp.startsWith("jar:file:")) {
                try {
                    link = new URLFileRegionHyperlink(hyperlinkRegion, 1, node.getLocalName(), new URL(uriString));
                }
                catch (MalformedURLException e) {
                    Logger.log(202, e.getMessage(), e);
                }
            } else {
                IFile file;
                Path path = new Path(uriString);
                if (path.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).getType() == 1 && file.isAccessible()) {
                    link = node != null ? new TLDFileHyperlink((IResource)file, 1, node.getLocalName(), hyperlinkRegion) : new WorkspaceFileHyperlink(hyperlinkRegion, file);
                }
            }
            if (link == null) {
                File externalFile = new File(uriString);
                link = new ExternalFileHyperlink(hyperlinkRegion, externalFile);
            }
        }
        return link;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode;
        block6: {
            inode = null;
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (sModel == null) break block6;
            }
            sModel.releaseFromRead();
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }
}

