/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.jsdt.core.ICodeFormatter;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.util.PublicScanner;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatter;

public class ToolFactory {
    public static final int M_FORMAT_NEW = new Integer(0);
    public static final int M_FORMAT_EXISTING = new Integer(1);

    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("codeFormatter");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (execExt instanceof ICodeFormatter) {
                            return (ICodeFormatter)execExt;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        return ToolFactory.createCodeFormatter(options, M_FORMAT_NEW);
    }

    public static CodeFormatter createCodeFormatter(Map options, int mode) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        HashMap<String, String> currentOptions = new HashMap<String, String>(options);
        if (mode == M_FORMAT_NEW) {
            currentOptions.put("org.eclipse.wst.jsdt.core.formatter.never_indent_block_comments_on_first_column", "false");
            currentOptions.put("org.eclipse.wst.jsdt.core.formatter.never_indent_line_comments_on_first_column", "false");
        }
        return new DefaultCodeFormatter(currentOptions);
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new org.eclipse.wst.jsdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        PublicScanner scanner = null;
        long level = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (level == 0L) {
            level = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, level, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel(complianceLevel)) == 0L) {
            complianceLevelValue = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

