/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import org.eclipse.wst.jsdt.core.ast.ASTVisitor;
import org.eclipse.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.core.ast.IReturnStatement;
import org.eclipse.wst.jsdt.core.ast.IScriptFileDeclaration;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMember;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CharLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class InferEngine
extends ASTVisitor {
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    protected int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public int appliesTo;
    public InferrenceProvider inferenceProvider;
    public InferredType StringType = new InferredType(new char[]{'S', 't', 'r', 'i', 'n', 'g'});
    public InferredType NumberType = new InferredType(new char[]{'N', 'u', 'm', 'b', 'e', 'r'});
    public InferredType BooleanType = new InferredType(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'});
    public InferredType FunctionType = new InferredType(new char[]{'F', 'u', 'n', 'c', 't', 'i', 'o', 'n'});
    public InferredType ArrayType = new InferredType(InferredType.ARRAY_NAME);
    public InferredType VoidType = new InferredType(new char[]{'v', 'o', 'i', 'd'});
    public InferredType ObjectType = new InferredType(InferredType.OBJECT_NAME);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    public static HashtableOfObject WellKnownTypes = new HashtableOfObject();
    protected InferredType inferredGlobal;
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    public static final char[] ANONYMOUS_PREFIX = new char[]{'_', '_', '_'};
    public static final char[] ANONYMOUS_CLASS_ID = new char[]{'a', 'n', 'o', 'n', 'y', 'm', 'o', 'u', 's'};

    public InferEngine(InferOptions inferOptions) {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(new char[]{'F', 'u', 'n', 'c', 't', 'i', 'o', 'n'}, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = inferOptions;
    }

    public InferEngine() {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(new char[]{'F', 'u', 'n', 'c', 't', 'i', 'o', 'n'}, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = new InferOptions();
    }

    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
        this.inferredGlobal = null;
    }

    public void setCompilationUnit(CompilationUnitDeclaration compilationUnit) {
        this.compUnit = compilationUnit;
        this.buildDefinedMembers(compilationUnit.statements, null);
    }

    public boolean visit(IFunctionCall functionCall) {
        boolean visitChildren = this.handleFunctionCall(functionCall);
        if (visitChildren && this.contextPtr == -1 && functionCall.getReceiver() instanceof FunctionExpression) {
            this.isTopLevelAnonymousFunction = true;
        }
        return visitChildren;
    }

    public boolean visit(ILocalDeclaration localDeclaration) {
        this.currentContext.addMember(localDeclaration.getName(), localDeclaration);
        if (localDeclaration.getJsDoc() != null) {
            InferredType type;
            Javadoc javadoc = (Javadoc)localDeclaration.getJsDoc();
            this.createTypeIfNecessary(javadoc);
            InferredAttribute attribute = null;
            if (javadoc.memberOf != null) {
                type = this.addType(javadoc.memberOf.getSimpleTypeName(), true);
                attribute = type.addAttribute(localDeclaration.getName(), localDeclaration);
                if (localDeclaration.getInitialization() != null) {
                    attribute.initializationStart = localDeclaration.getInitialization().sourceStart();
                }
                attribute.type = type;
            }
            if (javadoc.returnType != null) {
                type = this.addType(javadoc.returnType.getSimpleTypeName());
                localDeclaration.setInferredType(type);
                if (attribute != null) {
                    attribute.type = type;
                }
            }
        }
        if (localDeclaration.getInferredType() == null && localDeclaration.getInitialization() != null) {
            localDeclaration.setInferredType(this.getTypeOf(localDeclaration.getInitialization()));
        }
        return true;
    }

    private void createTypeIfNecessary(Javadoc javadoc) {
        if (javadoc.classDef != null) {
            Object namespace = new char[][]{};
            char[][] typeName = javadoc.classDef.getTypeName();
            if (javadoc.namespace != null) {
                namespace = javadoc.namespace.getTypeName();
            }
            char[] name = CharOperation.concat(CharOperation.concatWith(namespace, '.'), CharOperation.concatWith(typeName, '.'), '.');
            this.currentContext.currentType = this.addType(name);
            if (javadoc.extendsType != null) {
                char[] superName = CharOperation.concatWith(javadoc.extendsType.getTypeName(), '.');
                this.currentContext.currentType.superClass = this.addType(superName);
            }
            this.currentContext.isJsDocClass = true;
        }
    }

    public boolean visit(IAssignment assignment) {
        this.pushContext();
        Expression assignmentExpression = (Expression)assignment.getExpression();
        if (!this.handlePrototype((Assignment)assignment)) {
            if (assignmentExpression instanceof FunctionExpression) {
                boolean keepVisiting = this.handleFunctionExpressionAssignment((Assignment)assignment);
                if (!keepVisiting) {
                    return false;
                }
            } else if (assignmentExpression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.getLeftHandSide())) {
                SingleNameReference snr = (SingleNameReference)assignmentExpression;
                Object object = this.currentContext.getMember(snr.token);
                FieldReference fieldReference = (FieldReference)assignment.getLeftHandSide();
                char[] memberName = fieldReference.token;
                InferredMember member = null;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)object;
                    member = this.currentContext.currentType.addMethod(memberName, method, false);
                } else {
                    member = this.currentContext.currentType.addAttribute(memberName, assignment);
                    member.type = this.getTypeOf(assignmentExpression);
                }
                if (member != null) {
                    member.isStatic = false;
                    member.nameStart = fieldReference.sourceEnd - memberName.length + 1;
                }
            } else if (assignmentExpression instanceof ObjectLiteral && assignment.getLeftHandSide() instanceof SingleNameReference) {
                AbstractVariableDeclaration varDecl = this.getVariable(assignment.getLeftHandSide());
                if (varDecl != null) {
                    InferredType type = varDecl.inferredType;
                    if (type == null) {
                        varDecl.inferredType = type = this.getTypeOf(assignmentExpression);
                        return true;
                    }
                    return false;
                }
            } else if (assignmentExpression instanceof ObjectLiteral && assignment.getLeftHandSide() instanceof FieldReference) {
                boolean isKnownName;
                FieldReference fRef = (FieldReference)assignment.getLeftHandSide();
                boolean bl = isKnownName = fRef.receiver.isThis() && this.isKnownType(fRef.token) && this.inferredGlobal != null && this.inferredGlobal == this.currentContext.currentType;
                if (isKnownName || this.inferOptions.useAssignments && this.passNumber == 2) {
                    InferredAttribute attr;
                    InferredType receiverType = this.getInferredType(fRef.receiver);
                    if (receiverType == null && this.passNumber == 2) {
                        receiverType = this.getInferredType2(fRef.receiver);
                    }
                    if (receiverType != null && ((attr = receiverType.findAttribute(fRef.token)) == null || attr.type == null)) {
                        char[] possibleTypeName;
                        attr = receiverType.addAttribute(fRef.token, assignment);
                        attr.type = this.getTypeOf(assignmentExpression);
                        if (isKnownName && attr.type.isAnonymous) {
                            InferredType existingType = this.compUnit.findInferredType(fRef.token);
                            if (existingType != null) {
                                attr.type = existingType;
                            } else {
                                this.compUnit.inferredTypesHash.removeKey(attr.type.name);
                                attr.type.name = fRef.token;
                                this.compUnit.inferredTypesHash.put(fRef.token, attr.type);
                            }
                        }
                        attr.isStatic = (possibleTypeName = this.constructTypeName(fRef.receiver)) != null && this.compUnit.findInferredType(possibleTypeName) != null;
                        attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        return false;
                    }
                }
            } else if (assignmentExpression instanceof AllocationExpression && ((AllocationExpression)assignmentExpression).member instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (assignmentExpression instanceof Assignment && ((Assignment)assignmentExpression).expression instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (this.inferOptions.useAssignments && assignment.getLeftHandSide() instanceof FieldReference) {
                IFunctionDeclaration function;
                FieldReference fRef = (FieldReference)assignment.getLeftHandSide();
                int nameStart = (int)(fRef.nameSourcePosition >>> 32);
                InferredType receiverType = this.getInferredType(fRef.receiver);
                if (receiverType == null && (function = this.getDefinedFunction(fRef.receiver)) != null) {
                    receiverType = this.addType(this.constructTypeName(fRef.receiver));
                }
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fRef.receiver);
                }
                if (receiverType != null) {
                    InferredMethod method = null;
                    InferredAttribute attr = receiverType.findAttribute(fRef.token);
                    if (attr == null) {
                        method = receiverType.findMethod(fRef.token, null);
                    }
                    if (method == null && attr == null || method == null && attr != null && attr.type == null) {
                        IFunctionDeclaration definedFunction = null;
                        InferredType exprType = this.getTypeOf(assignmentExpression);
                        if (exprType == null) {
                            definedFunction = this.getDefinedFunction(assignmentExpression);
                        }
                        if (definedFunction != null) {
                            method = receiverType.addMethod(fRef.token, definedFunction, false);
                            method.nameStart = nameStart;
                        } else {
                            attr = receiverType.addAttribute(fRef.token, assignment);
                            attr.type = exprType;
                            char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                            attr.isStatic = possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                            attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected InferredType getInferredType2(Expression fieldReceiver) {
        char[] name;
        InferredAttribute attr;
        InferredType receiverType = null;
        AbstractVariableDeclaration var = this.getVariable(fieldReceiver);
        if (var != null) {
            receiverType = this.createAnonymousType(var);
        } else if (this.inferredGlobal != null && fieldReceiver instanceof SingleNameReference && (attr = (InferredAttribute)this.inferredGlobal.attributesHash.get(name = ((SingleNameReference)fieldReceiver).token)) != null) {
            receiverType = attr.type;
        }
        return receiverType;
    }

    private InferredType createAnonymousType(AbstractVariableDeclaration var) {
        InferredType currentType = var.inferredType;
        if (currentType == null || !currentType.isAnonymous) {
            InferredType type;
            var.inferredType = type = this.createAnonymousType(var.name, currentType);
        }
        return var.inferredType;
    }

    private InferredType createAnonymousType(char[] possibleTypeName, InferredType currentType) {
        char[] name;
        if (this.isKnownType(possibleTypeName)) {
            name = possibleTypeName;
        } else {
            char[] cs = String.valueOf(this.anonymousCount++).toCharArray();
            name = CharOperation.concat(ANONYMOUS_PREFIX, possibleTypeName, cs);
        }
        InferredType type = this.addType(name, true);
        type.isAnonymous = true;
        if (currentType != null) {
            type.superClass = currentType;
        }
        return type;
    }

    private InferredType createAnonymousType(ObjectLiteral objLit) {
        if (objLit.inferredType != null) {
            return objLit.inferredType;
        }
        char[] loc = (String.valueOf(String.valueOf(objLit.sourceStart)) + '_' + String.valueOf(objLit.sourceEnd)).toCharArray();
        char[] name = CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, loc);
        InferredType anonType = this.addType(name, true);
        anonType.isAnonymous = true;
        anonType.isObjectLiteral = true;
        anonType.superClass = this.ObjectType;
        anonType.sourceStart = objLit.sourceStart;
        anonType.sourceEnd = objLit.sourceEnd;
        this.populateType(anonType, objLit);
        return anonType;
    }

    protected boolean handleFunctionExpressionAssignment(Assignment assignment) {
        FunctionExpression functionExpression = null;
        if (assignment.expression instanceof FunctionExpression) {
            functionExpression = (FunctionExpression)assignment.expression;
        } else if (assignment.expression instanceof AllocationExpression) {
            functionExpression = (FunctionExpression)((AllocationExpression)assignment.expression).member;
        } else if (assignment.expression instanceof Assignment) {
            functionExpression = (FunctionExpression)((Assignment)assignment.expression).expression;
        }
        MethodDeclaration methodDeclaration = functionExpression.methodDeclaration;
        char[] possibleTypeName = this.constructTypeName(assignment.lhs);
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, assignment.sourceStart);
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                this.currentContext.currentType = type;
                type.isDefinition = true;
                InferredMethod method = type.addMethod(type.name, methodDeclaration, true);
                method.nameStart = assignment.lhs.sourceStart;
            }
        } else if (assignment.lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)assignment.lhs;
            int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
            InferredType receiverType = this.getInferredType(fieldReference.receiver);
            if (receiverType != null) {
                InferredMethod method = receiverType.findMethod(fieldReference.token, methodDeclaration);
                if (method == null) {
                    method = receiverType.addMethod(fieldReference.token, methodDeclaration, false);
                    receiverType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                    method.nameStart = nameStart;
                    receiverType.isDefinition = true;
                    char[] possibleInTypeName = this.constructTypeName(fieldReference.receiver);
                    method.isStatic = possibleInTypeName != null && this.compUnit.findInferredType(possibleInTypeName) != null;
                    return true;
                }
                return false;
            }
            if (this.passNumber == 2 && (receiverType = this.getInferredType2(fieldReference.receiver)) != null) {
                InferredMethod method = receiverType.addMethod(fieldReference.token, methodDeclaration, false);
                method.isStatic = receiverType.isAnonymous;
                method.nameStart = nameStart;
                receiverType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
            }
        } else {
            boolean cfr_ignored_0 = assignment.lhs instanceof SingleNameReference;
        }
        return true;
    }

    protected boolean handlePrototype(Assignment assignment) {
        Expression lhs = assignment.lhs;
        if (lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)lhs;
            if (fieldReference.isPrototype()) {
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(fieldReference.receiver);
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName, true);
                }
                newType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (assignment.expression instanceof AllocationExpression) {
                    AllocationExpression allocationExpression = (AllocationExpression)assignment.expression;
                    InferredType superType = null;
                    char[] possibleSuperTypeName = this.constructTypeName(allocationExpression.member);
                    if (possibleSuperTypeName != null) {
                        superType = this.compUnit.findInferredType(possibleSuperTypeName);
                        if (superType == null) {
                            superType = this.addType(possibleSuperTypeName);
                        }
                        if (newType.superClass == null) {
                            newType.superClass = superType;
                        }
                    }
                    return true;
                }
                if (assignment.expression instanceof ObjectLiteral) {
                    this.populateType(newType, (ObjectLiteral)assignment.expression);
                    if (newType.superClass == null) {
                        newType.superClass = this.ObjectType;
                    }
                    return true;
                }
            } else if (fieldReference.receiver.isPrototype()) {
                FieldReference prototype = (FieldReference)fieldReference.receiver;
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(prototype.receiver);
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName);
                    newType.isDefinition = true;
                }
                newType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (this.passNumber == 1 && assignment.expression instanceof ObjectLiteral) {
                    return false;
                }
                char[] memberName = fieldReference.token;
                int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                InferredType typeOf = this.getTypeOf(assignment.expression);
                IFunctionDeclaration methodDecl = null;
                if (typeOf == null || typeOf == this.FunctionType) {
                    methodDecl = this.getDefinedFunction(assignment.expression);
                }
                if (methodDecl != null) {
                    InferredMethod method = newType.addMethod(memberName, methodDecl, false);
                    method.nameStart = nameStart;
                } else if (!CharOperation.equals(CONSTRUCTOR_ID, memberName)) {
                    InferredAttribute attribute = newType.addAttribute(memberName, assignment);
                    attribute.initializationStart = assignment.expression.sourceStart;
                    attribute.nameStart = nameStart;
                    if (attribute.type == null) {
                        attribute.type = typeOf;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected IFunctionDeclaration getDefinedFunction(IExpression expression) {
        if (expression instanceof SingleNameReference) {
            Object object = this.currentContext.getMember(((SingleNameReference)expression).token);
            if (object instanceof AbstractMethodDeclaration) {
                return (MethodDeclaration)object;
            }
        } else {
            if (expression instanceof FunctionExpression) {
                return ((FunctionExpression)expression).methodDeclaration;
            }
            if (expression instanceof FieldReference) {
                InferredMethod method;
                FieldReference fieldReference = (FieldReference)expression;
                InferredType receiverType = this.getInferredType(fieldReference.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fieldReference.receiver);
                }
                if (receiverType != null && (method = receiverType.findMethod(fieldReference.token, null)) != null) {
                    return method.getFunctionDeclaration();
                }
            }
        }
        return null;
    }

    protected InferredType getTypeOf(IExpression expression) {
        if (expression instanceof StringLiteral || expression instanceof CharLiteral) {
            return this.StringType;
        }
        if (expression instanceof NumberLiteral) {
            return this.NumberType;
        }
        if (expression instanceof AllocationExpression) {
            AllocationExpression allocationExpression = (AllocationExpression)expression;
            InferredType type = null;
            char[] possibleTypeName = this.constructTypeName(allocationExpression.member);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    type = this.addType(possibleTypeName);
                }
                return type;
            }
        } else if (expression instanceof SingleNameReference) {
            InferredAttribute attribute;
            AbstractVariableDeclaration varDecl = this.getVariable((SingleNameReference)expression);
            if (varDecl != null) {
                return varDecl.inferredType;
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((SingleNameReference)expression).token)) != null) {
                return attribute.type;
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute attribute;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null && (attribute = this.currentContext.currentType.findAttribute(fieldReference.token)) != null) {
                return attribute.type;
            }
        } else {
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean typeSet = false;
                InferredType memberType = null;
                if (arrayInitializer.expressions != null) {
                    int i = 0;
                    while (i < arrayInitializer.expressions.length) {
                        InferredType thisType = this.getTypeOf(arrayInitializer.expressions[i]);
                        if (thisType != null) {
                            if (!thisType.equals(memberType)) {
                                memberType = !typeSet ? thisType : null;
                            }
                            typeSet = true;
                        }
                        ++i;
                    }
                }
                if (memberType != null) {
                    InferredType type = new InferredType(InferredType.ARRAY_NAME);
                    type.referenceClass = memberType;
                    return type;
                }
                return this.ArrayType;
            }
            if (expression instanceof TrueLiteral || expression instanceof FalseLiteral) {
                return this.BooleanType;
            }
            if (expression instanceof ObjectLiteral) {
                InferredType type = this.createAnonymousType((ObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
                return type;
            }
            if (expression instanceof ThisReference) {
                return this.currentContext.currentType;
            }
            if (expression instanceof Assignment) {
                return this.getTypeOf(((Assignment)expression).getExpression());
            }
            if (expression instanceof FunctionExpression) {
                return this.FunctionType;
            }
        }
        return null;
    }

    private void populateType(InferredType type, ObjectLiteral objLit) {
        if (objLit.inferredType == null) {
            objLit.inferredType = type;
            if (objLit.fields != null) {
                int i = 0;
                while (i < objLit.fields.length) {
                    ObjectLiteralField field = objLit.fields[i];
                    char[] name = null;
                    int nameStart = -1;
                    if (field.fieldName instanceof SingleNameReference) {
                        SingleNameReference singleNameReference = (SingleNameReference)field.fieldName;
                        name = singleNameReference.token;
                        nameStart = singleNameReference.sourceStart;
                        Javadoc javaDoc = (Javadoc)field.getJsDoc();
                        InferredType returnType = null;
                        if (javaDoc != null) {
                            InferredType previousType;
                            if (javaDoc.memberOf != null) {
                                char[] typeName = javaDoc.memberOf.getSimpleTypeName();
                                this.convertAnonymousTypeToNamed(type, typeName);
                                type.isDefinition = true;
                            } else if (this.currentContext.isJsDocClass && javaDoc.property != null && type.isAnonymous && (previousType = this.currentContext.currentType) != null) {
                                this.copyAnonymousTypeToNamed(type, previousType);
                                type = this.currentContext.currentType = previousType;
                                objLit.inferredType = this.currentContext.currentType;
                            }
                            if (javaDoc.returnType != null) {
                                returnType = this.addType(javaDoc.returnType.getSimpleTypeName());
                            }
                        }
                        if (field.initializer instanceof FunctionExpression) {
                            FunctionExpression functionExpression = (FunctionExpression)field.initializer;
                            InferredMethod method = type.addMethod(name, functionExpression.methodDeclaration, false);
                            method.nameStart = nameStart;
                            if (javaDoc != null) {
                                functionExpression.methodDeclaration.modifiers = javaDoc.modifiers;
                                this.handleFunctionDeclarationArguments(functionExpression.methodDeclaration, javaDoc);
                            }
                            if (returnType != null) {
                                functionExpression.methodDeclaration.inferredType = returnType;
                            }
                        } else {
                            InferredAttribute attribute = type.addAttribute(name, field.fieldName);
                            attribute.nameStart = nameStart;
                            attribute.type = returnType != null ? returnType : this.getTypeOf(field.initializer);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void endVisit(IAssignment assignment) {
        this.popContext();
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend) {
        return true;
    }

    public void endVisit(IReturnStatement returnStatement) {
        if (this.currentContext.currentMethod != null && returnStatement.getExpression() != null) {
            InferredType type = this.getTypeOf(returnStatement.getExpression());
            if (this.currentContext.currentMethod.inferredType == this.VoidType) {
                this.currentContext.currentMethod.inferredType = type;
            } else if (type == null || !type.equals(this.currentContext.currentMethod.inferredType)) {
                this.currentContext.currentMethod.inferredType = null;
            }
        }
    }

    public void endVisit(IFunctionDeclaration methodDeclaration) {
        this.popContext();
    }

    public boolean visit(IFunctionDeclaration methodDeclaration) {
        InferredType type;
        this.pushContext();
        if (this.isTopLevelAnonymousFunction && this.currentContext.currentType == null) {
            this.inferredGlobal = this.currentContext.currentType = this.addType(InferredType.GLOBAL_NAME, true);
        }
        this.isTopLevelAnonymousFunction = false;
        char[] methodName = methodDeclaration.getName();
        if (this.passNumber == 1) {
            this.buildDefinedMembers((ProgramElement[])methodDeclaration.getStatements(), (Argument[])methodDeclaration.getArguments());
            if (methodDeclaration.getJsDoc() != null) {
                InferredType type2;
                InferredMethod method = null;
                Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
                this.createTypeIfNecessary(javadoc);
                if (javadoc.isConstructor) {
                    type2 = !this.currentContext.isJsDocClass && methodName != null ? this.addType(methodName) : this.currentContext.currentType;
                    if (type2 != null) {
                        this.handleJSDocConstructor(type2, methodDeclaration, methodDeclaration.sourceStart());
                    }
                } else if (javadoc.memberOf != null) {
                    type2 = this.addType(javadoc.memberOf.getSimpleTypeName(), true);
                    char[] name = methodName;
                    if (name != null) {
                        method = type2.addMethod(methodName, methodDeclaration, false);
                    }
                } else if (javadoc.methodDef != null && this.currentContext.isJsDocClass) {
                    type2 = this.currentContext.currentType;
                    char[][] methName = javadoc.methodDef.getTypeName();
                    if (methName.length == 1) {
                        method = type2.addMethod(methName[0], methodDeclaration, false);
                    } else {
                        method = type2.addMethod(methName[methName.length - 1], methodDeclaration, false);
                        method.isStatic = true;
                    }
                    method.nameStart = ((MethodDeclaration)methodDeclaration).sourceStart;
                }
                if (javadoc.returnType != null) {
                    type2 = this.addType(javadoc.returnType.getSimpleTypeName());
                    methodDeclaration.setInferredType(type2);
                    ((MethodDeclaration)methodDeclaration).bits |= 0x4000;
                }
            }
            if (methodDeclaration.getArguments() != null) {
                this.handleFunctionDeclarationArguments((MethodDeclaration)methodDeclaration, (Javadoc)methodDeclaration.getJsDoc());
            }
        }
        if (this.passNumber == 2 && methodName != null && (type = this.compUnit.findInferredType(methodName)) != null) {
            this.currentContext.currentType = type;
            type.isDefinition = true;
            InferredMethod method = type.addMethod(methodName, methodDeclaration, true);
            method.nameStart = methodDeclaration.sourceStart();
            method.isConstructor = true;
            methodDeclaration.setInferredType(type);
        }
        this.currentContext.currentMethod = (MethodDeclaration)methodDeclaration;
        if (methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null) {
            this.currentContext.currentType = methodDeclaration.getInferredMethod().inType;
        }
        if (methodDeclaration.getInferredType() == null) {
            methodDeclaration.setInferredType(this.VoidType);
        }
        return true;
    }

    protected void handleJSDocConstructor(InferredType type, IFunctionDeclaration methodDeclaration, int nameStart) {
        Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
        type.isDefinition = true;
        InferredMethod method = type.addMethod(type.name, methodDeclaration, true);
        method.nameStart = nameStart;
        method.isConstructor = true;
        if (javadoc.extendsType != null) {
            InferredType superType;
            type.superClass = superType = this.addType(javadoc.extendsType.getSimpleTypeName());
        }
    }

    protected void handleFunctionDeclarationArguments(IFunctionDeclaration methodDeclaration, Javadoc javadoc) {
        if (javadoc == null) {
            return;
        }
        IArgument[] arguments = methodDeclaration.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                JavadocSingleNameReference param = javadoc.findParam(arguments[i].getName());
                if (param != null && param.types != null) {
                    char[] name = new char[]{};
                    int j = 0;
                    while (j < param.types.length) {
                        char[] typeName = param.types[j].getSimpleTypeName();
                        if (j == 0) {
                            name = typeName;
                        } else {
                            name = CharOperation.append(name, '|');
                            name = CharOperation.concat(name, typeName);
                        }
                        ++j;
                    }
                    InferredType paramType = this.addType(name);
                    arguments[i].setInferredType(paramType);
                }
                ++i;
            }
        }
    }

    public boolean visit(IAllocationExpression allocationExpression) {
        InferredType type = null;
        char[] possibleTypeName = this.constructTypeName(allocationExpression.getMember());
        if (possibleTypeName != null && (type = this.compUnit.findInferredType(possibleTypeName)) == null) {
            type = this.addType(possibleTypeName);
        }
        return true;
    }

    public void endVisit(IObjectLiteralField field) {
    }

    private void copyAnonymousTypeToNamed(InferredType inClass, InferredType toType) {
        this.compUnit.inferredTypesHash.removeKey(inClass.name);
        if (inClass.methods != null) {
            if (toType != null) {
                toType.methods.addAll(inClass.methods);
            } else {
                toType.methods = inClass.methods;
            }
        }
        if (inClass.attributes != null) {
            int i = 0;
            while (i < inClass.numberAttributes) {
                toType.addAttribute(inClass.attributes[i]);
                ++i;
            }
        }
    }

    private void convertAnonymousTypeToNamed(InferredType inClass, char[] typeName) {
        if (inClass.isAnonymous) {
            inClass.isAnonymous = false;
            this.compUnit.inferredTypesHash.removeKey(inClass.name);
            inClass.name = typeName;
            this.compUnit.inferredTypesHash.put(typeName, inClass);
        }
    }

    protected boolean isMatch(IExpression expr, char[][] names, int index) {
        char[] matchName = names[index];
        if (expr instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)expr;
            return CharOperation.equals(snr.token, matchName);
        }
        if (expr instanceof FieldReference && names.length > 1) {
            FieldReference fieldReference = (FieldReference)expr;
            if (CharOperation.equals(fieldReference.token, matchName)) {
                return this.isMatch(fieldReference.receiver, names, index - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(IFunctionCall messageSend, String string) {
        String[] names = string.split("\\.");
        char[] functionName = names[names.length - 1].toCharArray();
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        char[][] namesChars = new char[names.length][];
        int i = 0;
        while (i < namesChars.length) {
            namesChars[i] = names[i].toCharArray();
            ++i;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReciever(), namesChars, namesChars.length - 2);
        }
        return true;
    }

    protected boolean isFunction(IFunctionCall messageSend, char[][] names) {
        char[] functionName = names[names.length - 1];
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReciever(), names, names.length - 2);
        }
        return true;
    }

    public void doInfer() {
        this.compUnit.traverse(this);
        this.passNumber = 2;
        this.compUnit.traverse(this);
        int i = 0;
        while (i < this.compUnit.numberInferredTypes) {
            if (this.compUnit.inferredTypes[i].sourceStart < 0) {
                this.compUnit.inferredTypes[i].sourceStart = 0;
            }
            ++i;
        }
        this.compUnit = null;
    }

    protected InferredType addType(char[] className) {
        return this.addType(className, false);
    }

    protected InferredType addType(char[] className, boolean isDefinition) {
        InferredType type = this.compUnit.findInferredType(className);
        if (type == null) {
            if (this.compUnit.numberInferredTypes == this.compUnit.inferredTypes.length) {
                this.compUnit.inferredTypes = new InferredType[this.compUnit.numberInferredTypes * 2];
                System.arraycopy(this.compUnit.inferredTypes, 0, this.compUnit.inferredTypes, 0, this.compUnit.numberInferredTypes);
            }
            InferredType inferredType = new InferredType(className);
            this.compUnit.inferredTypes[this.compUnit.numberInferredTypes++] = inferredType;
            type = inferredType;
            type.inferenceProviderID = this.inferenceProvider.getID();
            this.compUnit.inferredTypesHash.put(className, type);
        }
        if (isDefinition) {
            type.isDefinition = isDefinition;
        }
        return type;
    }

    protected final void pushContext() {
        Context newContext = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = newContext;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.selector != null;
    }

    protected AbstractVariableDeclaration getVariable(IExpression expression) {
        Object var;
        char[] name = null;
        if (expression instanceof SingleNameReference) {
            name = ((SingleNameReference)expression).token;
        }
        if (name != null && (var = this.currentContext.getMember(name)) instanceof AbstractVariableDeclaration) {
            return (AbstractVariableDeclaration)var;
        }
        return null;
    }

    private void buildDefinedMembers(ProgramElement[] statements, IArgument[] arguments) {
        int i;
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                this.currentContext.addMember(arguments[i].getName(), arguments[i]);
                ++i;
            }
        }
        if (statements != null) {
            i = 0;
            while (i < statements.length) {
                if (statements[i] instanceof LocalDeclaration) {
                    LocalDeclaration local = (LocalDeclaration)statements[i];
                    this.currentContext.addMember(local.name, local);
                } else if (statements[i] instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration method = (AbstractMethodDeclaration)statements[i];
                    if (method.selector != null) {
                        this.currentContext.addMember(method.selector, method);
                    }
                }
                ++i;
            }
        }
    }

    private static boolean isThis(IExpression expression) {
        return expression instanceof FieldReference && ((FieldReference)expression).receiver.isThis();
    }

    private InferredType getInferredType(Expression expression) {
        InferredType type = null;
        if (expression instanceof ThisReference) {
            if (this.passNumber == 2 && this.currentContext.currentType == null) {
                char[] possibleTypeName = new char[]{'g', 'l', 'o', 'b', 'a', 'l'};
                if (this.currentContext.currentMethod != null) {
                    possibleTypeName = this.currentContext.currentMethod.selector;
                }
                this.currentContext.setCurrentType(this.createAnonymousType(possibleTypeName, null));
            }
            type = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                AbstractVariableDeclaration varDecl;
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    if (WellKnownTypes.containsKey(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    } else if (this.passNumber == 2 && this.isKnownType(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    }
                }
                if (type == null && (varDecl = this.getVariable(expression)) != null && (type = varDecl.inferredType) != null && !type.isAnonymous) {
                    type = this.createAnonymousType(varDecl);
                }
            }
        } else if (expression instanceof FieldReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
            }
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null) {
                InferredAttribute typeAttribute;
                FieldReference fRef = (FieldReference)expression;
                InferredType parentType = this.getInferredType(fRef.receiver);
                if (parentType != null && (typeAttribute = parentType.findAttribute(fRef.token)) != null && (type = typeAttribute.type) != null && !type.isAnonymous) {
                    if (possibleTypeName == null) {
                        possibleTypeName = typeAttribute.name;
                    }
                    typeAttribute.type = type = this.createAnonymousType(possibleTypeName, type);
                }
            }
        }
        return type;
    }

    protected boolean isKnownType(char[] possibleTypeName) {
        return false;
    }

    protected final char[] constructTypeName(IExpression expression) {
        return Util.getTypeName(expression);
    }

    public boolean visit(IObjectLiteral literal) {
        if (this.passNumber == 1 && literal.getInferredType() == null) {
            this.createAnonymousType((ObjectLiteral)literal);
        }
        this.pushContext();
        this.currentContext.currentType = literal.getInferredType();
        return true;
    }

    public void endVisit(IObjectLiteral literal) {
        this.popContext();
    }

    public void initializeOptions(InferOptions options) {
    }

    protected boolean isPossibleClassName(char[] name) {
        return false;
    }

    public IScriptFileDeclaration getScriptFileDeclaration() {
        return this.compUnit;
    }

    static class Context {
        InferredType currentType;
        MethodDeclaration currentMethod;
        boolean isJsDocClass;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context parent) {
            this.parent = parent;
            this.currentType = parent.currentType;
            this.currentMethod = parent.currentMethod;
            this.isJsDocClass = parent.isJsDocClass;
        }

        public Object getMember(char[] key) {
            Object value = null;
            if (this.definedMembers != null) {
                value = this.definedMembers.get(key);
            }
            if (value == null && this.parent != null) {
                value = this.parent.getMember(key);
            }
            return value;
        }

        public void addMember(char[] key, Object member) {
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(key, member);
        }

        public void setCurrentType(InferredType type) {
            this.currentType = type;
            Context parentContext = this.parent;
            while (parentContext != null && parentContext.currentMethod == this.currentMethod) {
                parentContext.currentType = type;
                parentContext = parentContext.parent;
            }
        }
    }
}

