/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.builder.StringSet;
import org.eclipse.wst.jsdt.internal.core.builder.ValidationParticipantResult;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BatchImageBuilder
extends AbstractImageBuilder {
    IncrementalImageBuilder incrementalBuilder;
    ArrayList secondaryTypes;
    StringSet typeLocatorsWithUndefinedTypes;

    protected BatchImageBuilder(JavaBuilder javaBuilder, boolean buildStarting) {
        super(javaBuilder, buildStarting, null);
        this.nameEnvironment.isIncrementalBuild = false;
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build() {
        if (JavaBuilder.DEBUG) {
            System.out.println("FULL build");
        }
        try {
            try {
                JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                this.notifier.updateProgressDelta(0.05f);
                this.notifier.subTask(Messages.build_analyzingSources);
                ArrayList sourceFiles = new ArrayList(33);
                this.addAllSourceFiles(sourceFiles);
                this.notifier.updateProgressDelta(0.1f);
                if (sourceFiles.size() > 0) {
                    SourceFile[] allSourceFiles = new SourceFile[sourceFiles.size()];
                    sourceFiles.toArray(allSourceFiles);
                    this.notifier.setProgressPerCompilationUnit(0.75f / (float)allSourceFiles.length);
                    this.workQueue.addAll(allSourceFiles);
                    this.compile(allSourceFiles);
                    if (this.typeLocatorsWithUndefinedTypes != null && this.secondaryTypes != null && !this.secondaryTypes.isEmpty()) {
                        this.rebuildTypesAffectedBySecondaryTypes();
                    }
                    if (this.incrementalBuilder != null) {
                        this.incrementalBuilder.buildAfterBatchBuild();
                    }
                }
                if (this.javaBuilder.javaProject.hasCycleMarker()) {
                    this.javaBuilder.mustPropagateStructuralChanges();
                }
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.cleanUp();
            return;
        }
    }

    protected void cleanUp() {
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
        super.cleanUp();
    }

    protected void compile(SourceFile[] units, SourceFile[] additionalUnits, boolean compilingFirstGroup) {
        if (additionalUnits != null && this.secondaryTypes == null) {
            this.secondaryTypes = new ArrayList(7);
        }
        super.compile(units, additionalUnits, compilingFirstGroup);
    }

    protected void copyExtraResourcesBack(ClasspathMultiDirectory sourceLocation, final boolean deletedAll) throws CoreException {
        this.notifier.subTask(Messages.build_copyingResources);
        final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
        final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
        final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
        final IContainer outputFolder = sourceLocation.binaryFolder;
        final boolean isAlsoProject = sourceLocation.sourceFolder.equals((Object)this.javaBuilder.currentProject);
        sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource resource = null;
                switch (proxy.getType()) {
                    case 1: {
                        if (Util.isJavaLikeFileName(proxy.getName()) || org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(proxy.getName())) {
                            return false;
                        }
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded(resource.getFullPath(), inclusionPatterns, exclusionPatterns, false)) {
                            return false;
                        }
                        IPath partialPath = resource.getFullPath().removeFirstSegments(segmentCount);
                        IFile copiedResource = outputFolder.getFile(partialPath);
                        if (copiedResource.exists()) {
                            if (deletedAll) {
                                IResource originalResource = BatchImageBuilder.this.findOriginalResource(partialPath);
                                String id = originalResource.getFullPath().removeFirstSegments(1).toString();
                                BatchImageBuilder.this.createProblemFor(resource, null, Messages.bind(Messages.build_duplicateResource, id), BatchImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.wst.jsdt.core.builder.duplicateResourceTask", true));
                                return false;
                            }
                            copiedResource.delete(1, null);
                        }
                        BatchImageBuilder.this.createFolder(partialPath.removeLastSegments(1), outputFolder);
                        resource.copy(copiedResource.getFullPath(), 1025, null);
                        Util.setReadOnly((IResource)copiedResource, false);
                        return false;
                    }
                    case 2: {
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if (isAlsoProject && BatchImageBuilder.this.isExcludedFromProject(resource.getFullPath())) {
                            return false;
                        }
                        if (exclusionPatterns == null || inclusionPatterns != null || !Util.isExcluded(resource.getFullPath(), null, exclusionPatterns, true)) break;
                        return false;
                    }
                }
                return true;
            }
        }, 0);
    }

    protected IResource findOriginalResource(IPath partialPath) {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            IFile originalResource;
            ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            if (sourceLocation.hasIndependentOutputFolder && (originalResource = sourceLocation.sourceFolder.getFile(partialPath)).exists()) {
                return originalResource;
            }
            ++i;
        }
        return null;
    }

    protected void processAnnotationResults(ValidationParticipantResult[] results) {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = new IncrementalImageBuilder(this);
        }
        this.incrementalBuilder.processAnnotationResults(results);
    }

    protected void rebuildTypesAffectedBySecondaryTypes() {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = new IncrementalImageBuilder(this);
        }
        int i = this.secondaryTypes.size();
        while (--i >= 0) {
            char[] secondaryTypeName = (char[])this.secondaryTypes.get(i);
            Path path = new Path(null, new String(secondaryTypeName));
            this.incrementalBuilder.addDependentsOf((IPath)path, false);
        }
        this.incrementalBuilder.addAffectedSourceFiles(this.incrementalBuilder.qualifiedStrings, this.incrementalBuilder.simpleStrings, this.typeLocatorsWithUndefinedTypes);
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        int i = problems.length;
        while (--i >= 0) {
            CategorizedProblem problem = problems[i];
            if (problem == null || problem.getID() != 0x1000002) continue;
            if (this.typeLocatorsWithUndefinedTypes == null) {
                this.typeLocatorsWithUndefinedTypes = new StringSet(3);
            }
            this.typeLocatorsWithUndefinedTypes.add(sourceFile.typeLocator());
            break;
        }
        super.storeProblemsFor(sourceFile, problems);
    }

    public String toString() {
        return "batch image builder for:\n\tnew state: " + this.newState;
    }
}

