/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IndexSelector;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchParticipant
extends SearchParticipant {
    IndexSelector indexSelector;

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    public String getDescription() {
        return "JavaScript";
    }

    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (Util.isJavaLikeFileName(documentPath)) {
            new SourceIndexer(document).indexDocument();
        }
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locatePackageDeclarations(this);
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
        }
        return this.indexSelector.getIndexLocations();
    }
}

