/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariablePattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class LocalVariablePattern
extends VariablePattern {
    LocalVariable localVariable;
    protected static char[][] REF_CATEGORIES = new char[][]{REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{REF, VAR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{VAR_DECL};

    public LocalVariablePattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, LocalVariable localVariable, int matchRule) {
        super(512, findDeclarations, readAccess, writeAccess, localVariable.getElementName().toCharArray(), matchRule, localVariable);
        this.localVariable = localVariable;
    }

    public LocalVariablePattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, char[] name, int matchRule) {
        super(512, findDeclarations, readAccess, writeAccess, name, matchRule, null);
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (this.localVariable != null) {
            JavaSearchScope javaSearchScope;
            AccessRuleSet access;
            String documentPath;
            String relativePath;
            IPackageFragmentRoot root = (IPackageFragmentRoot)this.localVariable.getAncestor(3);
            if (root.isArchive()) {
                IType type = (IType)this.localVariable.getAncestor(7);
                relativePath = String.valueOf(type.getFullyQualifiedName('/').replace('.', '/')) + ".js";
                documentPath = root.getPath() + "|" + relativePath;
            } else {
                IPath path = this.localVariable.getPath();
                documentPath = path.toString();
                relativePath = Util.relativePath(path, 1);
            }
            if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
                throw new OperationCanceledException();
            }
        } else {
            super.findIndexMatches(index, requestor, participant, scope, progressMonitor);
        }
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations || this.writeAccess ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public char[] getIndexKey() {
        return this.name;
    }

    public SearchPattern getBlankPattern() {
        return new LocalVariablePattern(false, false, false, null, 8);
    }

    public void decodeIndexKey(char[] key) {
        this.name = key;
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            output.append("LocalVarReferencePattern: ");
        }
        output.append(this.localVariable.toStringWithAncestors());
        return super.print(output);
    }
}

