/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PossibleMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    CompilationUnitDeclaration parsedUnit;
    public SearchDocument document;
    private String sourceFileName;
    private char[] source;

    public PossibleMatch(MatchLocator locator, IResource resource, Openable openable, SearchDocument document, boolean mustResolve) {
        this.resource = resource;
        this.openable = openable;
        this.document = document;
        this.nodeSet = new MatchingNodeSet(mustResolve);
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public void cleanUp() {
        this.source = null;
        if (this.parsedUnit != null) {
            this.parsedUnit.cleanUp();
            this.parsedUnit = null;
        }
        this.nodeSet = null;
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)obj).compoundName);
    }

    public char[] getContents() {
        if (this.source != null) {
            return this.source;
        }
        if (this.openable instanceof ClassFile) {
            this.source = ((ClassFile)this.openable).getContents();
            return this.source;
        }
        this.source = this.document.getCharContents();
        return this.source;
    }

    public char[] getFileName() {
        return this.openable.getElementName().toCharArray();
    }

    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, length - 1);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.openable.getElementName();
            char[] mainTypeName = Util.getNameWithoutJavaLikeExtension(fileName).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
            }
            int index = Util.indexOfJavaLikeExtension(fileName);
            String simpleName = index == -1 ? fileName : fileName.substring(0, index);
            PackageFragment pkg = (PackageFragment)this.openable.getParent();
            return Util.concatWith(pkg.names, simpleName, '.').toCharArray();
        }
        return null;
    }

    private String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        return this.sourceFileName;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }

    public LibrarySuperType getCommonSuperType() {
        return this.openable.getCommonSuperType();
    }

    public String getInferenceID() {
        return null;
    }
}

