/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.JsDataTypes;
import org.eclipse.wst.jsdt.web.core.javascript.NodeHelper;
import org.eclipse.wst.jsdt.web.core.javascript.Util;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JsTranslator
extends Job
implements IJsTranslator {
    protected static final boolean DEBUG;
    private static final boolean DEBUG_SAVE_OUTPUT;
    protected static final String ENDL = "\n";
    protected static final boolean REMOVE_XML_COMMENT = true;
    protected static final String XML_COMMENT_START = "<!--";
    protected static final String XML_COMMENT_END = "-->";
    private IStructuredDocumentRegion fCurrentNode;
    protected StringBuffer fScriptText = new StringBuffer();
    protected IStructuredDocument fStructuredDocument = null;
    protected ArrayList importLocationsInHtml = new ArrayList();
    protected boolean fIsGlobalJs = true;
    protected ArrayList rawImports = new ArrayList();
    protected ArrayList scriptLocationInHtml = new ArrayList();
    protected int scriptOffset = 0;
    protected byte[] fLock = new byte[0];
    protected byte[] finished = new byte[0];
    protected IBuffer fCompUnitBuff;
    protected boolean cancelParse = false;
    protected int missingEndTagRegionStart = -1;
    protected static final boolean ADD_SEMICOLON_AT_INLINE = true;

    static {
        DEBUG_SAVE_OUTPUT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsptranslationstodisk"));
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspjavamapping");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    protected boolean isGlobalJs() {
        return this.fIsGlobalJs;
    }

    protected IBuffer getCompUnitBuffer() {
        return this.fCompUnitBuff;
    }

    protected StringBuffer getScriptTextBuffer() {
        return this.fScriptText;
    }

    protected void setIsGlobalJs(boolean value) {
        this.fIsGlobalJs = value;
    }

    protected void advanceNextNode() {
        this.setCurrentNode(this.getCurrentNode().getNext());
    }

    protected void cleanupXmlQuotes() {
        int index = -1;
        int replaceLength = XML_COMMENT_START.length();
        while ((index = this.fScriptText.indexOf(XML_COMMENT_START, index)) > -1) {
            this.fScriptText.replace(index, index + replaceLength, new String(Util.getPad(replaceLength)));
        }
        index = -1;
        replaceLength = XML_COMMENT_END.length();
        while ((index = this.fScriptText.indexOf(XML_COMMENT_END, index)) > -1) {
            this.fScriptText.replace(index, index + replaceLength, new String(Util.getPad(replaceLength)));
        }
    }

    public JsTranslator(IStructuredDocument document, String fileName) {
        super("JavaScript translation for : " + fileName);
        this.fStructuredDocument = document;
        this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
        this.setPriority(30);
        this.setSystem(true);
        this.schedule();
        this.reset();
    }

    public JsTranslator() {
        super("JavaScript Translation");
    }

    public JsTranslator(IStructuredDocument document, String fileName, boolean listenForChanges) {
        super("JavaScript translation for : " + fileName);
        this.fStructuredDocument = document;
        if (listenForChanges) {
            this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
            this.setPriority(30);
            this.setSystem(true);
            this.schedule();
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsText() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fScriptText.toString();
        }
    }

    protected final IStructuredDocumentRegion getCurrentNode() {
        return this.fCurrentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(IBuffer buffer) {
        this.fCompUnitBuff = buffer;
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            this.fCompUnitBuff.setContents(this.fScriptText.toString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getHtmlLocations() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scriptLocationInHtml.toArray(new Position[this.scriptLocationInHtml.size()]);
        }
    }

    public int getMissingEndTagRegionStart() {
        return this.missingEndTagRegionStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getImportHtmlRanges() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.importLocationsInHtml.toArray(new Position[this.importLocationsInHtml.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRawImports() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rawImports.toArray(new String[this.rawImports.size()]);
        }
    }

    protected boolean isCanceled() {
        return this.cancelParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.scriptOffset = 0;
            this.cancelParse = false;
            this.fScriptText = new StringBuffer();
            this.fCurrentNode = this.fStructuredDocument.getFirstStructuredDocumentRegion();
            this.rawImports.clear();
            this.importLocationsInHtml.clear();
            this.scriptLocationInHtml.clear();
            this.missingEndTagRegionStart = -1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.translate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStructuredDocumentRegion setCurrentNode(IStructuredDocumentRegion currentNode) {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.fCurrentNode = currentNode;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.fCurrentNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            while (this.getCurrentNode() != null && !this.isCanceled()) {
                if (this.getCurrentNode().getType() == "XML_TAG_NAME") {
                    NodeHelper nh = new NodeHelper(this.getCurrentNode());
                    if ((!nh.isEndTag() || nh.isSelfClosingTag()) && nh.nameEquals("script")) {
                        if (NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("type")) || NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("language")) || this.isGlobalJs()) {
                            if (nh.containsAttribute(new String[]{"src"})) {
                                this.translateScriptImportNode(this.getCurrentNode());
                            }
                            if (this.getCurrentNode().getNext() != null) {
                                this.translateJSNode(this.getCurrentNode().getNext());
                            }
                        }
                    } else if (nh.containsAttribute(JsDataTypes.HTMLATREVENTS)) {
                        this.translateInlineJSNode(this.getCurrentNode());
                    } else if (nh.nameEquals("META") && nh.attrEquals("http-equiv", "Content-Script-Type") && nh.containsAttribute(new String[]{"content"})) {
                        this.setIsGlobalJs(NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nh.getAttributeValue("content")));
                    }
                }
                if (this.getCurrentNode() == null) continue;
                this.advanceNextNode();
            }
            if (this.getCompUnitBuffer() != null) {
                this.getCompUnitBuffer().setContents(this.fScriptText.toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.finishedTranslation();
            return;
        }
    }

    protected void finishedTranslation() {
        this.cleanupXmlQuotes();
    }

    public void translateInlineJSNode(IStructuredDocumentRegion container) {
        new NodeHelper(container);
        ITextRegionList t = container.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext() && !this.isCanceled()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int start = r.getStart();
            int offset = r.getTextEnd();
            String tagAttrname = container.getText().substring(start, offset).trim();
            if (!NodeHelper.isInArray(JsDataTypes.HTMLATREVENTS, tagAttrname)) continue;
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int valStartOffset = container.getStartOffset(r);
            String rawText = container.getText().substring(r.getStart(), r.getTextEnd());
            if (rawText == null || rawText.length() == 0) {
                return;
            }
            switch (rawText.charAt(0)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(1);
                    ++valStartOffset;
                }
            }
            if (rawText == null || rawText.length() == 0) {
                return;
            }
            switch (rawText.charAt(rawText.length() - 1)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(0, rawText.length() - 1);
                }
            }
            rawText = String.valueOf(rawText) + ";";
            Position inHtml = new Position(valStartOffset, rawText.length());
            this.scriptLocationInHtml.add(inHtml);
            char[] spaces = Util.getPad(valStartOffset - this.scriptOffset);
            this.fScriptText.append(spaces);
            this.fScriptText.append(rawText);
            this.scriptOffset = this.fScriptText.length();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void translateJSNode(IStructuredDocumentRegion container) {
        containerRegion = container;
        regions = containerRegion.getRegions().iterator();
        region = null;
        if (container == null) {
            return;
        }
        spaces = Util.getPad(container.getStartOffset() - this.scriptOffset);
        this.fScriptText.append(spaces);
        this.scriptOffset = container.getStartOffset();
        if (container.getType() == "BLOCK_TEXT" || container.getType() == "XML_CDATA_TEXT") ** GOTO lbl34
        return;
lbl-1000:
        // 1 sources

        {
            region = (ITextRegion)regions.next();
            type = region.getType();
            isBlockRegion = region instanceof ITextRegionContainer;
            if (type != "BLOCK_TEXT") continue;
            scriptStart = container.getStartOffset();
            scriptTextEnd = container.getEndOffset() - container.getStartOffset();
            regionText = container.getText().substring(region.getStart(), region.getEnd());
            regionLength = regionText.length();
            inHtml = new Position(scriptStart, scriptTextEnd);
            this.scriptLocationInHtml.add(inHtml);
            spaces = Util.getPad(scriptStart - this.scriptOffset);
            this.fScriptText.append(spaces);
            if (isBlockRegion) {
                spaces = Util.getPad(regionLength);
                this.fScriptText.append(spaces);
            } else {
                this.fScriptText.append(regionText);
            }
            this.scriptOffset = this.fScriptText.length();
lbl34:
            // 3 sources

            ** while (regions.hasNext() && !this.isCanceled())
        }
lbl35:
        // 1 sources

        endTag = container.getNext();
        if (endTag == null) {
            this.missingEndTagRegionStart = container.getStartOffset();
        } else if (!(endTag == null || (name = (nh = new NodeHelper(endTag)).getTagName()) != null && name.trim().equalsIgnoreCase("script") && nh.isEndTag())) {
            this.missingEndTagRegionStart = container.getStartOffset();
        }
    }

    public void translateScriptImportNode(IStructuredDocumentRegion region) {
        NodeHelper nh = new NodeHelper(region);
        String importName = nh.getAttributeValue("src");
        if (importName != null && !importName.equals("")) {
            this.rawImports.add(importName);
            Position inHtml = new Position(region.getStartOffset(), region.getEndOffset());
            this.importLocationsInHtml.add(inHtml);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.cancelParse = true;
    }

    public void documentChanged(DocumentEvent event) {
        this.reset();
    }

    protected IStatus run(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void release() {
        this.fStructuredDocument.removeDocumentListener((IDocumentListener)this);
    }
}

