/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;

public class JsPathIndexer {
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IPath[] getVisibleJspPaths(SearchPattern pattern, IJavaSearchScope scope) {
        JSPFileVisitor jspFileVisitor = new JSPFileVisitor(pattern, scope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jspFileVisitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return jspFileVisitor.getPaths();
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private HashMap fPaths = new HashMap();
        SearchPattern fPattern = null;
        IJavaSearchScope fScope = null;

        public JSPFileVisitor(SearchPattern pattern, IJavaSearchScope scope) {
            this.fPattern = pattern;
            this.fScope = scope;
        }

        public IPath[] getPaths() {
            return this.fPaths.values().toArray(new IPath[this.fPaths.size()]);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (JsSearchSupport.getInstance().isCanceled()) {
                return false;
            }
            if (proxy.getType() == 1) {
                if (Util.isJsType(proxy.getName())) {
                    IFile file = (IFile)proxy.requestResource();
                    IContentDescription contentDescription = file.getContentDescription();
                    if (contentDescription != null) {
                        contentDescription.getContentType().getId();
                    }
                    if (this.fScope.encloses(proxy.requestFullPath().toString())) {
                        if (DEBUG) {
                            System.out.println("adding selected index path:" + file.getParent().getFullPath());
                        }
                        this.fPaths.put(file.getParent().getFullPath(), JsSearchSupport.getInstance().computeIndexLocation(file.getParent().getFullPath()));
                    }
                }
                return false;
            }
            return true;
        }
    }
}

