/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.javascript.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsPathIndexer;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.core.javascript.search.NullSearchDocument;

public class JsSearchParticipant
extends SearchParticipant {
    private static final boolean DEBUG = JsSearchParticipant.calculateValue();

    private static boolean calculateValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.jstd.jsp.core/debug/jspsearch");
        boolean debug = value != null && value.equalsIgnoreCase("true");
        return debug;
    }

    public String getDescription() {
        return "Embeded JavaScript";
    }

    public SearchDocument getDocument(IFile file) {
        return null;
    }

    public SearchDocument getDocument(String documentPath) {
        SearchDocument sDoc = JsSearchSupport.getInstance().getSearchDocument(documentPath);
        if (sDoc == null) {
            return new NullSearchDocument(documentPath);
        }
        return sDoc;
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        if (!(document instanceof JSDTSearchDocumentDelegate)) {
            return;
        }
        SearchEngine.getDefaultSearchParticipant().indexDocument(document, indexPath);
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ArrayList<SearchDocument> filtered = new ArrayList<SearchDocument>();
        SearchDocument match = null;
        int i = 0;
        while (i < indexMatches.length) {
            if (DEBUG) {
                System.out.println("found possible matching JavaSearchDocumentDelegate: " + indexMatches[i]);
            }
            if ((match = indexMatches[i]) != null && match instanceof JSDTSearchDocumentDelegate && ((JSDTSearchDocumentDelegate)match).getFile().exists()) {
                filtered.add(match);
            }
            ++i;
        }
        indexMatches = filtered.toArray(new SearchDocument[filtered.size()]);
        SearchEngine.getDefaultSearchParticipant().locateMatches(indexMatches, pattern, scope, requestor, monitor);
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        JsPathIndexer indexer = new JsPathIndexer();
        return indexer.getVisibleJspPaths(pattern, scope);
    }
}

