/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterContext;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterDefaults;
import org.eclipse.jst.ws.internal.axis.consumption.core.plugin.WebServiceAxisConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AxisEmitterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String INFOPOP_PPAE_PAGE = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0001";
    private Button allWanted;
    private String INFOPOP_PPAE_CHECKBOX_ALL_WANTED = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0002";
    private Button helperWanted;
    private String INFOPOP_PPAE_CHECKBOX_HELPER_WANTED = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0003";
    private Button wrapArrays;
    private String INFOPOP_PPAE_CHECKBOX_WRAP_ARRAYS = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0004";
    private Combo deployScopeTypes;
    private String INFOPOP_PPAE_COMBO_DEPLOY_SCOPE = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0005";
    private StackLayout timeOutSubCompositeStackLayout;
    private Text timeOutField;
    int timeOut;
    String wsdl2JavaTimeoutProperty = System.getProperty("AxisWsdl2JavaTimeout");
    private Text timeOutMsgText;
    private String INFOPOP_PPAE_FIELD_TIME_OUT = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0006";
    private Button useInheritedMethods;
    private String INFOPOP_PPAE_CHECKBOX_USE_INHERITED_METHODS = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0007";
    private Button validateAgainstJAXRPC;
    private String INFOPOP_PPAE_CHECKBOX_VALIDATE_AGAINST_JAXRPC = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0010";
    private String INFOPOP_PPAE_GROUP_WSDL2JAVA = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0008";
    private String INFOPOP_PPAE_GROUP_JAVA2WSDL = "org.eclipse.jst.ws.axis.consumption.ui.PPAE0009";

    protected Control createContents(Composite superparent) {
        UIUtils utils = new UIUtils("org.eclipse.jst.ws.axis.consumption.ui");
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setToolTipText(AxisConsumptionUIMessages.TOOLTIP_PPAE_PAGE);
        helpSystem.setHelp((Control)parent, this.INFOPOP_PPAE_PAGE);
        Group wsdl2JavaGroup = utils.createGroup(parent, AxisConsumptionUIMessages.GROUP_WSDL2JAVA_NAME, AxisConsumptionUIMessages.TOOLTIP_PPAE_GROUP_WSDL2JAVA, this.INFOPOP_PPAE_GROUP_WSDL2JAVA, 2, 10, 10);
        this.allWanted = this.createCheckBox((Composite)wsdl2JavaGroup, AxisConsumptionUIMessages.BUTTON_ALL_WANTED, AxisConsumptionUIMessages.TOOLTIP_PPAE_CHECKBOX_ALL_WANTED, this.INFOPOP_PPAE_CHECKBOX_ALL_WANTED);
        this.helperWanted = this.createCheckBox((Composite)wsdl2JavaGroup, AxisConsumptionUIMessages.BUTTON_HELPER_WANTED, AxisConsumptionUIMessages.TOOLTIP_PPAE_CHECKBOX_HELPER_WANTED, this.INFOPOP_PPAE_CHECKBOX_HELPER_WANTED);
        this.wrapArrays = this.createCheckBox((Composite)wsdl2JavaGroup, AxisConsumptionUIMessages.BUTTON_WRAP_ARRAYS, AxisConsumptionUIMessages.TOOLTIP_PPAE_CHECKBOX_WRAP_ARRAYS, this.INFOPOP_PPAE_CHECKBOX_WRAP_ARRAYS);
        this.deployScopeTypes = utils.createCombo((Composite)wsdl2JavaGroup, AxisConsumptionUIMessages.LABEL_DEPLOY_SCOPE, AxisConsumptionUIMessages.TOOLTIP_PPAE_COMBO_DEPLOY_SCOPE, this.INFOPOP_PPAE_COMBO_DEPLOY_SCOPE, 2060);
        this.deployScopeTypes.setItems(new String[]{AxisConsumptionUIMessages.DEPLOY_SCOPE_APPLICATION, AxisConsumptionUIMessages.DEPLOY_SCOPE_REQUEST, AxisConsumptionUIMessages.DEPLOY_SCOPE_SESSION});
        Label timeoutLabel = new Label((Composite)wsdl2JavaGroup, 64);
        timeoutLabel.setText(AxisConsumptionUIMessages.LABEL_TIME_OUT);
        timeoutLabel.setToolTipText(AxisConsumptionUIMessages.TOOLTIP_PPAE_FIELD_TIME_OUT);
        Composite timeOutSubComposite = utils.createComposite((Composite)wsdl2JavaGroup, 1);
        this.timeOutSubCompositeStackLayout = new StackLayout();
        timeOutSubComposite.setLayout((Layout)this.timeOutSubCompositeStackLayout);
        this.timeOutField = this.createTextField(timeOutSubComposite, null, AxisConsumptionUIMessages.TOOLTIP_PPAE_FIELD_TIME_OUT, this.INFOPOP_PPAE_FIELD_TIME_OUT);
        this.timeOutMsgText = this.createTextField(timeOutSubComposite, null, AxisConsumptionUIMessages.TOOLTIP_PPAE_FIELD_TIME_OUT, this.INFOPOP_PPAE_FIELD_TIME_OUT);
        this.timeOutMsgText.setEditable(false);
        Group java2WsdlGroup = utils.createGroup(parent, AxisConsumptionUIMessages.GROUP_JAVA2WSDL_NAME, AxisConsumptionUIMessages.TOOLTIP_PPAE_GROUP_JAVA2WSDL, this.INFOPOP_PPAE_GROUP_JAVA2WSDL, 2, 10, 10);
        this.useInheritedMethods = this.createCheckBox((Composite)java2WsdlGroup, AxisConsumptionUIMessages.BUTTON_USE_INHERITED_METHODS, AxisConsumptionUIMessages.TOOLTIP_PPAE_CHECKBOX_USE_INHERITED_METHODS, this.INFOPOP_PPAE_CHECKBOX_USE_INHERITED_METHODS);
        this.validateAgainstJAXRPC = this.createCheckBox((Composite)java2WsdlGroup, AxisConsumptionUIMessages.BUTTON_VALIDATE_AGAINST_JAXRPC, AxisConsumptionUIMessages.TOOLTIP_PPAE_CHECKBOX_VALIDATE_AGAINST_JAXRPC, this.INFOPOP_PPAE_CHECKBOX_VALIDATE_AGAINST_JAXRPC);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private Button createCheckBox(Composite parent, String labelName, String tooltip, String infopop) {
        Button button = new Button(parent, 32);
        button.setText(labelName);
        button.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, "org.eclipse.jst.ws.axis.consumption.ui." + infopop);
        }
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Text createTextField(Composite parent, String labelName, String tooltip, String infopop) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        text.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, "org.eclipse.jst.ws.axis.consumption.ui." + infopop);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisEmitterPreferencePage.this.numberFieldChanged((Text)e.widget);
            }
        });
        return text;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        if (this.validateNumber(this.timeOutField.getText()).isOK()) {
            this.storeValues();
        }
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.allWanted.setSelection(AxisEmitterDefaults.getAllWantedDefault());
        this.helperWanted.setSelection(AxisEmitterDefaults.getHelperWantedDefault());
        this.wrapArrays.setSelection(AxisEmitterDefaults.getWrapArraysDefault());
        this.deployScopeTypes.select(AxisEmitterDefaults.getDeployScopeDefault());
        if (this.wsdl2JavaTimeoutProperty != null) {
            this.timeOutField.setText("" + this.getTimeOutValueWithProperty());
        } else {
            this.timeOutField.setText("" + AxisEmitterDefaults.getTimeOutDefault());
        }
        this.useInheritedMethods.setSelection(AxisEmitterDefaults.getUseInheritedMethodsDefault());
        this.validateAgainstJAXRPC.setSelection(AxisEmitterDefaults.getValidateAgainstJAXRPC());
    }

    private void initializeValues() {
        AxisEmitterContext context = WebServiceAxisConsumptionCorePlugin.getInstance().getAxisEmitterContext();
        this.allWanted.setSelection(context.isAllWantedEnabled());
        this.helperWanted.setSelection(context.isHelperWantedEnabled());
        this.wrapArrays.setSelection(context.isWrapArraysEnabled());
        this.deployScopeTypes.select(context.getDeployScopeType());
        this.useInheritedMethods.setSelection(context.isUseInheritedMethodsEnabled());
        this.validateAgainstJAXRPC.setSelection(context.isValidateAgainstJAXRPCEnabled());
        if (this.wsdl2JavaTimeoutProperty != null) {
            this.timeOut = this.getTimeOutValueWithProperty();
            this.timeOutSubCompositeStackLayout.topControl = this.timeOutMsgText;
            this.timeOutMsgText.setText(AxisConsumptionUIMessages.MSG_USE_JVM_ARGUMENT_FOR_TIME_OUT);
        } else {
            this.timeOut = context.getTimeOut();
            this.timeOutSubCompositeStackLayout.topControl = this.timeOutField;
        }
        this.timeOutField.setText("" + this.timeOut);
    }

    private void storeValues() {
        AxisEmitterContext context = WebServiceAxisConsumptionCorePlugin.getInstance().getAxisEmitterContext();
        context.setAllWantedEnabled(this.allWanted.getSelection());
        context.setHelperWantedEnabled(this.helperWanted.getSelection());
        context.setWrapArraysEnabled(this.wrapArrays.getSelection());
        context.selectDeployScopeType(this.deployScopeTypes.getSelectionIndex());
        this.timeOut = Integer.parseInt(this.timeOutField.getText().trim());
        context.setTimeOut(this.timeOut);
        context.setUseInheritedMethodsEnabled(this.useInheritedMethods.getSelection());
        context.setValidateAgainstJAXRPCEnabled(this.validateAgainstJAXRPC.getSelection());
    }

    private void numberFieldChanged(Text textControl) {
        IStatus status = this.validateNumber(textControl.getText());
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    private int getTimeOutValueWithProperty() {
        if (this.wsdl2JavaTimeoutProperty != null) {
            long timeOutProperty;
            block4: {
                try {
                    timeOutProperty = Long.parseLong(this.wsdl2JavaTimeoutProperty);
                    if (timeOutProperty >= 0L) break block4;
                    return -1;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.print("AxisWSDL2JavaTimeout is not a valid number");
                    return AxisEmitterDefaults.getTimeOutDefault();
                }
            }
            return (int)Math.ceil((double)timeOutProperty / 1000.0);
        }
        return AxisEmitterDefaults.getTimeOutDefault();
    }

    private IStatus validateNumber(String numberString) {
        IStatus status;
        try {
            int number = Integer.parseInt(numberString);
            if (number <= 0 && number != -1) {
                status = new Status(4, "org.eclipse.jst.ws.axis.consumption.ui", 4, AxisConsumptionUIMessages.MSG_ERROR_INVALID_TIME_OUT, null);
            } else {
                this.timeOut = number;
                status = Status.OK_STATUS;
                status = new Status(0, "org.eclipse.jst.ws.axis.consumption.ui", 0, "", null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            status = new Status(4, "org.eclipse.jst.ws.axis.consumption.ui", 4, AxisConsumptionUIMessages.MSG_ERROR_INVALID_TIME_OUT, null);
        }
        return status;
    }

    private void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(null, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

