/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.internal.ConnectionProfileHolder;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPSchemaContainerWrapper
extends DTPWrapper
implements SchemaContainer {
    private DTPSchemaWrapper[] schemata;

    DTPSchemaContainerWrapper(ConnectionProfileHolder connectionProfileHolder) {
        super(connectionProfileHolder);
    }

    @Override
    synchronized void catalogObjectChanged(int eventType) {
        this.dispose_();
    }

    abstract DTPDatabaseWrapper database();

    abstract boolean isCaseSensitive();

    abstract List<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata();

    @Override
    public Iterator<Schema> schemata() {
        return new ArrayIterator((Object[])this.schemata_());
    }

    private Iterator<DTPSchemaWrapper> schemaWrappers() {
        return new ArrayIterator((Object[])this.schemata_());
    }

    synchronized DTPSchemaWrapper[] schemata_() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemata();
        }
        return this.schemata;
    }

    private DTPSchemaWrapper[] buildSchemata() {
        List<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.dtpSchemata();
        DTPSchemaWrapper[] result = new DTPSchemaWrapper[dtpSchemata.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSchemaWrapper(this, dtpSchemata.get(i));
        }
        return result;
    }

    @Override
    public int schemataSize() {
        return this.schemata_().length;
    }

    @Override
    public Iterator<String> schemaNames() {
        return new TransformationIterator<DTPSchemaWrapper, String>(this.schemaWrappers()){

            protected String transform(DTPSchemaWrapper schema) {
                return schema.getName();
            }
        };
    }

    @Override
    public boolean containsSchemaNamed(String name) {
        return this.schemaNamed(name) != null;
    }

    @Override
    public DTPSchemaWrapper schemaNamed(String name) {
        return this.isCaseSensitive() ? this.schemaNamedCaseSensitive(name) : this.schemaNamedIgnoreCase(name);
    }

    private DTPSchemaWrapper schemaNamedCaseSensitive(String name) {
        Iterator<DTPSchemaWrapper> stream = this.schemaWrappers();
        while (stream.hasNext()) {
            DTPSchemaWrapper schema = stream.next();
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        return null;
    }

    private DTPSchemaWrapper schemaNamedIgnoreCase(String name) {
        Iterator<DTPSchemaWrapper> stream = this.schemaWrappers();
        while (stream.hasNext()) {
            DTPSchemaWrapper schema = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)schema.getName(), (String)name)) continue;
            return schema;
        }
        return null;
    }

    DTPSchemaWrapper schema(org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        Iterator<DTPSchemaWrapper> stream = this.schemaWrappers();
        while (stream.hasNext()) {
            DTPSchemaWrapper schema = stream.next();
            if (!schema.wraps(dtpSchema)) continue;
            return schema;
        }
        throw new IllegalArgumentException("invalid DTP schema: " + dtpSchema);
    }

    @Override
    synchronized void dispose() {
        this.dispose_();
        super.dispose();
    }

    void dispose_() {
        this.disposeSchemata();
    }

    private void disposeSchemata() {
        if (this.schemata != null) {
            DTPSchemaWrapper[] dTPSchemaWrapperArray = this.schemata;
            int n = this.schemata.length;
            int n2 = 0;
            while (n2 < n) {
                DTPSchemaWrapper schema = dTPSchemaWrapperArray[n2];
                schema.dispose();
                ++n2;
            }
            this.schemata = null;
        }
    }
}

