/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Sequence;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPSchemaWrapper
extends DTPWrapper
implements Schema {
    private final DTPSchemaContainerWrapper container;
    private final org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema;
    private DTPTableWrapper[] tables;
    private DTPSequenceWrapper[] sequences;

    DTPSchemaWrapper(DTPSchemaContainerWrapper container, org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        super(container);
        this.container = container;
        this.dtpSchema = dtpSchema;
    }

    @Override
    ICatalogObject getCatalogObject() {
        return (ICatalogObject)this.dtpSchema;
    }

    @Override
    synchronized void catalogObjectChanged(int eventType) {
        this.dispose_();
        this.getConnectionProfile().schemaChanged(this, eventType);
    }

    @Override
    public String getName() {
        return this.dtpSchema.getName();
    }

    @Override
    public Iterator<Table> tables() {
        return new ArrayIterator((Object[])this.tables_());
    }

    private Iterator<DTPTableWrapper> tableWrappers() {
        return new ArrayIterator((Object[])this.tables_());
    }

    private synchronized DTPTableWrapper[] tables_() {
        if (this.tables == null) {
            this.tables = this.buildTables();
        }
        return this.tables;
    }

    private DTPTableWrapper[] buildTables() {
        List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables = this.dtpTables();
        DTPTableWrapper[] result = new DTPTableWrapper[dtpTables.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPTableWrapper(this, dtpTables.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables() {
        return this.dtpSchema.getTables();
    }

    @Override
    public int tablesSize() {
        return this.tables_().length;
    }

    @Override
    public Iterator<String> tableNames() {
        return new TransformationIterator<DTPTableWrapper, String>(this.tableWrappers()){

            protected String transform(DTPTableWrapper table) {
                return table.getName();
            }
        };
    }

    @Override
    public boolean containsTableNamed(String name) {
        return this.tableNamed(name) != null;
    }

    @Override
    public DTPTableWrapper tableNamed(String name) {
        return this.isCaseSensitive() ? this.tableNamedCaseSensitive(name) : this.tableNamedIgnoreCase(name);
    }

    private DTPTableWrapper tableNamedCaseSensitive(String name) {
        Iterator<DTPTableWrapper> stream = this.tableWrappers();
        while (stream.hasNext()) {
            DTPTableWrapper table = stream.next();
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    private DTPTableWrapper tableNamedIgnoreCase(String name) {
        Iterator<DTPTableWrapper> stream = this.tableWrappers();
        while (stream.hasNext()) {
            DTPTableWrapper table = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)table.getName(), (String)name)) continue;
            return table;
        }
        return null;
    }

    DTPTableWrapper table(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        if (dtpTable.getSchema() != this.dtpSchema) {
            return this.database().table(dtpTable);
        }
        Iterator<DTPTableWrapper> stream = this.tableWrappers();
        while (stream.hasNext()) {
            DTPTableWrapper table = stream.next();
            if (!table.wraps(dtpTable)) continue;
            return table;
        }
        throw new IllegalArgumentException("invalid DTP table: " + dtpTable);
    }

    @Override
    public Iterator<Sequence> sequences() {
        return new ArrayIterator((Object[])this.sequences_());
    }

    private Iterator<DTPSequenceWrapper> sequenceWrappers() {
        return new ArrayIterator((Object[])this.sequences_());
    }

    private synchronized DTPSequenceWrapper[] sequences_() {
        if (this.sequences == null) {
            this.sequences = this.buildSequences();
        }
        return this.sequences;
    }

    private DTPSequenceWrapper[] buildSequences() {
        List<org.eclipse.datatools.modelbase.sql.schema.Sequence> dtpSequences = this.dtpSequences();
        DTPSequenceWrapper[] result = new DTPSequenceWrapper[dtpSequences.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSequenceWrapper(this, dtpSequences.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Sequence> dtpSequences() {
        return this.dtpSchema.getSequences();
    }

    @Override
    public int sequencesSize() {
        return this.sequences_().length;
    }

    @Override
    public Iterator<String> sequenceNames() {
        return new TransformationIterator<DTPSequenceWrapper, String>(this.sequenceWrappers()){

            protected String transform(DTPSequenceWrapper sequence) {
                return sequence.getName();
            }
        };
    }

    @Override
    public boolean containsSequenceNamed(String name) {
        return this.sequenceNamed(name) != null;
    }

    @Override
    public DTPSequenceWrapper sequenceNamed(String name) {
        return this.isCaseSensitive() ? this.sequenceNamedCaseSensitive(name) : this.sequenceNamedIgnoreCase(name);
    }

    private DTPSequenceWrapper sequenceNamedCaseSensitive(String name) {
        Iterator<DTPSequenceWrapper> stream = this.sequenceWrappers();
        while (stream.hasNext()) {
            DTPSequenceWrapper sequence = stream.next();
            if (!sequence.getName().equals(name)) continue;
            return sequence;
        }
        return null;
    }

    private DTPSequenceWrapper sequenceNamedIgnoreCase(String name) {
        Iterator<DTPSequenceWrapper> stream = this.sequenceWrappers();
        while (stream.hasNext()) {
            DTPSequenceWrapper sequence = stream.next();
            if (!sequence.getName().equalsIgnoreCase(name)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public int compareTo(Schema schema) {
        return Collator.getInstance().compare(this.getName(), schema.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.schema.Schema schema) {
        return this.dtpSchema == schema;
    }

    boolean isCaseSensitive() {
        return this.database().isCaseSensitive();
    }

    DTPColumnWrapper column(Column dtpColumn) {
        return this.database().column(dtpColumn);
    }

    DTPDatabaseWrapper database() {
        return this.container.database();
    }

    @Override
    synchronized void dispose() {
        this.dispose_();
        super.dispose();
    }

    private void dispose_() {
        this.disposeSequences();
        this.disposeTables();
    }

    private void disposeSequences() {
        if (this.sequences != null) {
            DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
            int n = this.sequences.length;
            int n2 = 0;
            while (n2 < n) {
                DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
                sequence.dispose();
                ++n2;
            }
            this.sequences = null;
        }
    }

    private void disposeTables() {
        if (this.tables != null) {
            DTPTableWrapper[] dTPTableWrapperArray = this.tables;
            int n = this.tables.length;
            int n2 = 0;
            while (n2 < n) {
                DTPTableWrapper table = dTPTableWrapperArray[n2];
                table.dispose();
                ++n2;
            }
            this.tables = null;
        }
    }
}

