/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPTableWrapper
extends DTPWrapper
implements Table {
    private final DTPSchemaWrapper schema;
    private final org.eclipse.datatools.modelbase.sql.tables.Table dtpTable;
    private DTPColumnWrapper[] columns;
    private DTPColumnWrapper[] primaryKeyColumns;
    private DTPForeignKeyWrapper[] foreignKeys;
    private static final DTPColumnWrapper[] EMPTY_COLUMNS = new DTPColumnWrapper[0];
    private static final DTPForeignKeyWrapper[] EMPTY_FOREIGN_KEYS = new DTPForeignKeyWrapper[0];

    DTPTableWrapper(DTPSchemaWrapper schema, org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        super(schema);
        this.schema = schema;
        this.dtpTable = dtpTable;
    }

    @Override
    ICatalogObject getCatalogObject() {
        return (ICatalogObject)this.dtpTable;
    }

    @Override
    synchronized void catalogObjectChanged(int eventType) {
        this.dispose_();
        this.getConnectionProfile().tableChanged(this, eventType);
    }

    @Override
    public String getName() {
        return this.dtpTable.getName();
    }

    @Override
    public String getShortJavaClassName() {
        String jName = this.getName();
        if (!this.isCaseSensitive()) {
            jName = StringTools.capitalize((String)jName.toLowerCase());
        }
        return NameTools.convertToJavaIdentifier((String)jName);
    }

    @Override
    public boolean matchesShortJavaClassName(String shortJavaClassName) {
        return this.isCaseSensitive() ? this.getName().equals(shortJavaClassName) : this.getName().equalsIgnoreCase(shortJavaClassName);
    }

    @Override
    public String getJavaFieldName() {
        String jName = this.getName();
        if (!this.isCaseSensitive()) {
            jName = jName.toLowerCase();
        }
        return NameTools.convertToJavaIdentifier((String)jName);
    }

    @Override
    public Iterator<Column> columns() {
        return new ArrayIterator((Object[])this.columns_());
    }

    private Iterator<DTPColumnWrapper> columnWrappers() {
        return new ArrayIterator((Object[])this.columns_());
    }

    private synchronized DTPColumnWrapper[] columns_() {
        if (this.columns == null) {
            this.columns = this.buildColumns();
        }
        return this.columns;
    }

    private DTPColumnWrapper[] buildColumns() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpColumns = this.dtpColumns();
        DTPColumnWrapper[] result = new DTPColumnWrapper[dtpColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPColumnWrapper(this, dtpColumns.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpColumns() {
        return this.dtpTable.getColumns();
    }

    @Override
    public int columnsSize() {
        return this.columns_().length;
    }

    @Override
    public Iterator<String> columnNames() {
        return new TransformationIterator<DTPColumnWrapper, String>(this.columnWrappers()){

            protected String transform(DTPColumnWrapper next) {
                return next.getName();
            }
        };
    }

    @Override
    public boolean containsColumnNamed(String name) {
        return this.columnNamed(name) != null;
    }

    @Override
    public DTPColumnWrapper columnNamed(String name) {
        return this.isCaseSensitive() ? this.columnNamedCaseSensitive(name) : this.columnNamedIgnoreCase(name);
    }

    private DTPColumnWrapper columnNamedCaseSensitive(String name) {
        Iterator<DTPColumnWrapper> stream = this.columnWrappers();
        while (stream.hasNext()) {
            DTPColumnWrapper column = stream.next();
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    private DTPColumnWrapper columnNamedIgnoreCase(String name) {
        Iterator<DTPColumnWrapper> stream = this.columnWrappers();
        while (stream.hasNext()) {
            DTPColumnWrapper column = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)column.getName(), (String)name)) continue;
            return column;
        }
        return null;
    }

    DTPColumnWrapper column(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        if (dtpColumn.getTable() != this.dtpTable) {
            return this.schema.column(dtpColumn);
        }
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns_();
        int n = dTPColumnWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            if (column.wraps(dtpColumn)) {
                return column;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP column: " + dtpColumn);
    }

    @Override
    public Iterator<Column> primaryKeyColumns() {
        return new ArrayIterator((Object[])this.primaryKeyColumns_());
    }

    @Override
    public DTPColumnWrapper primaryKeyColumn() {
        DTPColumnWrapper[] pkColumns = this.primaryKeyColumns_();
        if (pkColumns.length != 1) {
            throw new IllegalStateException("multiple primary key columns: " + pkColumns.length);
        }
        return pkColumns[0];
    }

    private synchronized DTPColumnWrapper[] primaryKeyColumns_() {
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = this.buildPrimaryKeyColumns();
        }
        return this.primaryKeyColumns;
    }

    private DTPColumnWrapper[] buildPrimaryKeyColumns() {
        if (!(this.dtpTable instanceof BaseTable)) {
            return EMPTY_COLUMNS;
        }
        PrimaryKey pk = ((BaseTable)this.dtpTable).getPrimaryKey();
        if (pk == null) {
            return EMPTY_COLUMNS;
        }
        List<org.eclipse.datatools.modelbase.sql.tables.Column> pkColumns = this.columns(pk);
        DTPColumnWrapper[] result = new DTPColumnWrapper[pkColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = this.column(pkColumns.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> columns(PrimaryKey pk) {
        return pk.getMembers();
    }

    @Override
    public int primaryKeyColumnsSize() {
        return this.primaryKeyColumns_().length;
    }

    @Override
    public boolean primaryKeyColumnsContains(Column column) {
        return CollectionTools.contains((Object[])this.primaryKeyColumns_(), (Object)column);
    }

    @Override
    public Iterator<ForeignKey> foreignKeys() {
        return new ArrayIterator((Object[])this.foreignKeys_());
    }

    private Iterator<DTPForeignKeyWrapper> foreignKeyWrappers() {
        return new ArrayIterator((Object[])this.foreignKeys_());
    }

    private synchronized DTPForeignKeyWrapper[] foreignKeys_() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.buildForeignKeys();
        }
        return this.foreignKeys;
    }

    private DTPForeignKeyWrapper[] buildForeignKeys() {
        if (!(this.dtpTable instanceof BaseTable)) {
            return EMPTY_FOREIGN_KEYS;
        }
        List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> dtpForeignKeys = this.dtpForeignKeys();
        DTPForeignKeyWrapper[] result = new DTPForeignKeyWrapper[dtpForeignKeys.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPForeignKeyWrapper(this, dtpForeignKeys.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> dtpForeignKeys() {
        return ((BaseTable)this.dtpTable).getForeignKeys();
    }

    @Override
    public int foreignKeysSize() {
        return this.foreignKeys_().length;
    }

    @Override
    public boolean foreignKeyBaseColumnsContains(Column column) {
        Iterator<DTPForeignKeyWrapper> stream = this.foreignKeyWrappers();
        while (stream.hasNext()) {
            DTPForeignKeyWrapper foreignKey = stream.next();
            if (!foreignKey.baseColumnsContains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Table table) {
        return Collator.getInstance().compare(this.getName(), table.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.dtpTable == table;
    }

    boolean isCaseSensitive() {
        return this.schema.isCaseSensitive();
    }

    DTPTableWrapper table(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.schema.table(table);
    }

    DTPDatabaseWrapper database() {
        return this.schema.database();
    }

    @Override
    synchronized void dispose() {
        this.dispose_();
        super.dispose();
    }

    private void dispose_() {
        this.disposeForeignKeys();
        this.primaryKeyColumns = null;
        this.disposeColumns();
    }

    private void disposeForeignKeys() {
        if (this.foreignKeys != null) {
            DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
            int n = this.foreignKeys.length;
            int n2 = 0;
            while (n2 < n) {
                DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
                foreignKey.dispose();
                ++n2;
            }
            this.foreignKeys = null;
        }
    }

    private void disposeColumns() {
        if (this.columns != null) {
            DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                DTPColumnWrapper column = dTPColumnWrapperArray[n2];
                column.dispose();
                ++n2;
            }
            this.columns = null;
        }
    }
}

