/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.jpt.db.internal.ConnectionProfileHolder;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.utility.internal.StringTools;

abstract class DTPWrapper
implements ConnectionProfileHolder {
    private final ConnectionProfileHolder connectionProfileHolder;
    private final ICatalogObjectListener catalogObjectListener;

    DTPWrapper(ConnectionProfileHolder connectionProfileHolder) {
        this.connectionProfileHolder = connectionProfileHolder;
        this.catalogObjectListener = this.buildCatalogObjectListener();
        if (this.getConnectionProfile().isConnected()) {
            RefreshManager.getInstance().AddListener(this.getCatalogObject(), this.catalogObjectListener);
        }
    }

    private ICatalogObjectListener buildCatalogObjectListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject catalogObject, int eventType) {
                if (catalogObject == DTPWrapper.this.getCatalogObject()) {
                    DTPWrapper.this.catalogObjectChanged(eventType);
                }
            }
        };
    }

    abstract ICatalogObject getCatalogObject();

    abstract void catalogObjectChanged(int var1);

    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this.connectionProfileHolder.getConnectionProfile();
    }

    void dispose() {
        RefreshManager.getInstance().removeListener(this.getCatalogObject(), this.catalogObjectListener);
    }

    abstract String getName();

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }
}

