/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContextFactory;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.context.IExternalContextFactoryLocator;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.internal.BasicExtensionFactory;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.osgi.framework.Bundle;

public final class DesignTimeApplicationManager {
    private static final String PROPERTY_QUALIFIER = "org.eclipse.jst.jsf.designtime.internal";
    private static final String SESSION_PROPERTY_NAME_PROJECT = "DesignTimeApplicationManager";
    private static final QualifiedName SESSION_PROPERTY_KEY_PROJECT = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "DesignTimeApplicationManager");
    private static final String SESSION_PROPERTY_NAME_FACES_CONTEXT = "DTFacesContext";
    private static final QualifiedName SESSION_PROPERTY_KEY_FACES_CONTEXT = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "DTFacesContext");
    private static final String PERSIST_PROPERTY_NAME_EXTERNAL_CONTEXT_PROVIDER = "ExternalContextProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "ExternalContextProvider");
    private static final String PERSIST_PROPERTY_NAME_VARIABLE_RESOLVER_PROVIDER = "VariableResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "VariableResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_PROPERTY_RESOLVER_PROVIDER = "PropertyResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "PropertyResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_METHOD_RESOLVER_PROVIDER = "MethodResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "MethodResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_VIEW_HANDLER = "ViewHandler";
    private static final String DEFAULT_EXTERNAL_CONTEXT_ID = "org.eclipse.jst.jsf.core.externalcontext.default";
    private static final String DEFAULT_VARIABLE_RESOLVER_ID = "org.eclipse.jst.jsf.core.variableresolver.default.decorative";
    private static final String DEFAULT_PROPERTY_RESOLVER_ID = "org.eclipse.jst.jsf.core.propertyresolver.default.decorative";
    private static final String DEFAULT_METHOD_RESOLVER_ID = "org.eclipse.jst.jsf.core.methodresolver.default";
    private static final String DEFAULT_VIEW_HANDLER_ID = "org.eclipse.jst.jsf.designtime.view.jspviewhandler";
    private IProject _project;
    private final IExternalContextFactoryLocator _locator;
    private Properties _properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DesignTimeApplicationManager getInstance(IProject project) {
        if (!DesignTimeApplicationManager.hasJSFDesignTime(project)) {
            return null;
        }
        try {
            IProject iProject = project;
            synchronized (iProject) {
                DesignTimeApplicationManager manager = (DesignTimeApplicationManager)project.getSessionProperty(SESSION_PROPERTY_KEY_PROJECT);
                if (manager == null) {
                    manager = new DesignTimeApplicationManager(project);
                    project.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, (Object)manager);
                } else {
                    DesignTimeApplicationManager designTimeApplicationManager = manager;
                    synchronized (designTimeApplicationManager) {
                        if (!project.equals((Object)manager._project)) {
                            manager._project = project;
                        }
                    }
                }
                return manager;
            }
        }
        catch (CoreException ce) {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "Problem loading design time appmanager", new Throwable(ce)));
            return null;
        }
    }

    public static boolean hasJSFDesignTime(IProject project) {
        return project != null && project.isAccessible() && JSFAppConfigUtils.isValidJSFProject(project);
    }

    private DesignTimeApplicationManager(IProject project) {
        this._project = project;
        this._locator = new MyExternalContextFactoryLocator();
        this._properties = this.loadProperties(this._project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTFacesContext getFacesContext(IFile file) {
        if (!this.hasDTFacesContext(file)) {
            return null;
        }
        try {
            IFile iFile = file;
            synchronized (iFile) {
                Object context = file.getSessionProperty(SESSION_PROPERTY_KEY_FACES_CONTEXT);
                if (context == null) {
                    context = new DTFacesContext((IAdaptable)file, this._locator);
                    file.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, context);
                }
                return (DTFacesContext)context;
            }
        }
        catch (CoreException ce) {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "Problem loading design time facescontext", new Throwable(ce)));
            return null;
        }
    }

    public boolean hasDTFacesContext(IFile file) {
        IDTViewHandler viewHandler = this.getViewHandler();
        return file != null && file.isAccessible() && viewHandler != null && viewHandler.supportsViewDefinition(file);
    }

    public synchronized IDTViewHandler getViewHandler() {
        String viewHandlerId = this.getFromProjectSettings(PERSIST_PROPERTY_NAME_VIEW_HANDLER, DEFAULT_VIEW_HANDLER_ID);
        if (viewHandlerId != null) {
            return JSFCorePlugin.getViewHandlers(viewHandlerId).getInstance(this._project);
        }
        return null;
    }

    public synchronized void setViewHandlerId(String viewHandlerId) {
        this.setProjectSetting(PERSIST_PROPERTY_NAME_VIEW_HANDLER, viewHandlerId);
    }

    public synchronized void setExternalContextProvider(String resolverPluginId) throws CoreException {
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER, resolverPluginId);
    }

    public synchronized String getExternalContextProvider() {
        return this.getResolverId(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER, DEFAULT_EXTERNAL_CONTEXT_ID);
    }

    public synchronized AbstractDTVariableResolver getVariableResolver() {
        BasicExtensionFactory.ExtensionData<AbstractDTVariableResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getVariableResolvers(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getVariableResolvers(DEFAULT_VARIABLE_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setVariableResolverProvider(String resolverPluginId) throws CoreException {
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getVariableResolverProvider() {
        return this.getResolverId(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER, DEFAULT_VARIABLE_RESOLVER_ID);
    }

    public synchronized AbstractDTPropertyResolver getDefaultPropertyResolver() {
        return JSFCorePlugin.getPropertyResolver(DEFAULT_PROPERTY_RESOLVER_ID).getInstance(this._project);
    }

    public synchronized AbstractDTPropertyResolver getPropertyResolver() {
        BasicExtensionFactory.ExtensionData<AbstractDTPropertyResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getPropertyResolver(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getPropertyResolver(DEFAULT_PROPERTY_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setPropertyResolverProvider(String resolverPluginId) throws CoreException {
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getPropertyResolverProvider() {
        return this.getResolverId(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER, DEFAULT_PROPERTY_RESOLVER_ID);
    }

    public synchronized AbstractDTMethodResolver getMethodResolver() {
        BasicExtensionFactory.ExtensionData<AbstractDTMethodResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getMethodResolvers(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getMethodResolvers(DEFAULT_METHOD_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setMethodResolverProvider(String resolverPluginId) throws CoreException {
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getMethodResolverProvider() {
        return this.getResolverId(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER, DEFAULT_METHOD_RESOLVER_ID);
    }

    private String getResolverId_OLD(QualifiedName pluginKey) {
        String pluginId = null;
        try {
            pluginId = this._project.getPersistentProperty(pluginKey);
        }
        catch (CoreException ce) {
            JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error getting plugin property", (Throwable)ce));
            pluginId = null;
        }
        return pluginId;
    }

    private String getResolverId(QualifiedName key, String defaultValue) {
        String id = defaultValue;
        try {
            String userId = this._project.getPersistentProperty(key);
            if (userId != null) {
                id = userId;
            }
        }
        catch (CoreException coreException) {}
        return id;
    }

    private String getFromProjectSettings(String key, String defaultValue) {
        return this._properties.getProperty(key, defaultValue);
    }

    private void setProjectSetting(String key, String value) {
        this._properties.setProperty(key, value);
        this.storeProperties(this._properties);
    }

    private void storeProperties(Properties properties) {
        try {
            IFile propFile = this.getPropsFile(this._project);
            if (propFile != null) {
                ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                properties.store(outstream, null);
                propFile.setContents((InputStream)new ByteArrayInputStream(outstream.toByteArray()), true, true, null);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Problem storing properties");
        }
        catch (IOException e) {
            JSFCorePlugin.log(e, "Problem storing properties");
        }
    }

    private Properties loadProperties(IProject project) {
        Properties props = new Properties();
        try {
            IFile propFile = this.getPropsFile(project);
            if (propFile != null) {
                props.load(propFile.getContents());
            }
        }
        catch (CoreException ce) {
            JSFCorePlugin.log((Exception)((Object)ce), "Problem loading properties");
        }
        catch (IOException ce) {
            JSFCorePlugin.log(ce, "Problem loading properties");
        }
        return props;
    }

    private IFile getPropsFile(IProject project) throws CoreException {
        IFile file;
        IFolder folder = project.getFolder((IPath)new Path(".settings"));
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        if (!(file = folder.getFile((IPath)new Path("org.eclipse.jst.jsf.designtime.appmgr.prefs"))).exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        return file;
    }

    private class MyExternalContextFactoryLocator
    implements IExternalContextFactoryLocator {
        private MyExternalContextFactoryLocator() {
        }

        public AbstractDTExternalContextFactory getFactory() {
            BasicExtensionFactory.ExtensionData<AbstractDTExternalContextFactory> extData = null;
            String id = DesignTimeApplicationManager.this.getResolverId_OLD(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER);
            if (id != null) {
                extData = JSFCorePlugin.getExternalContextProviders(id);
            }
            if (extData == null) {
                extData = JSFCorePlugin.getExternalContextProviders(DesignTimeApplicationManager.DEFAULT_EXTERNAL_CONTEXT_ID);
            }
            return extData.getInstance(DesignTimeApplicationManager.this._project);
        }
    }
}

