/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.context;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContextFactory;
import org.eclipse.jst.jsf.designtime.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.context.IExternalContextFactoryLocator;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;

public final class DTFacesContext {
    private final IExternalContextFactoryLocator _locator;
    private IAdaptable _contextObject;
    private DTUIViewRoot _viewRoot;
    private String _localeString = "";

    public DTFacesContext(IAdaptable contextObject, IExternalContextFactoryLocator locator) {
        this._contextObject = contextObject;
        this._locator = locator;
    }

    public DTFacesContext(IExternalContextFactoryLocator locator) {
        this._locator = locator;
    }

    public IDTExternalContext getDTExternalContext(IAdaptable contextObject) {
        IDTExternalContext externalContext = null;
        if (contextObject instanceof IFile || contextObject != null && contextObject.getAdapter(IFile.class) != null) {
            AbstractDTExternalContextFactory factory = this._locator.getFactory();
            externalContext = factory.create(contextObject);
        }
        return externalContext;
    }

    public DTUIViewRoot getViewRoot() {
        IDTViewHandler viewHandler;
        IResource contextResource = this.adaptContextObject();
        if (contextResource != null && this._viewRoot == null && (viewHandler = this.getViewHandler()) != null) {
            String viewId = viewHandler.getViewId(this, contextResource);
            try {
                this._viewRoot = viewHandler.createView(this, viewId);
                if (this._viewRoot.getViewId() == null) {
                    this._viewRoot.setViewId(viewId);
                }
            }
            catch (IDTViewHandler.ViewHandlerException e) {
                JSFCorePlugin.log(e, "While creating dt viewroot for viewId: " + viewId);
            }
        }
        return this._viewRoot;
    }

    public String getLocaleString() {
        return this._localeString;
    }

    public void setLocaleString(String newLocaleString) {
        this._localeString = newLocaleString;
    }

    private IDTViewHandler getViewHandler() {
        DesignTimeApplicationManager manager;
        IDTViewHandler viewHandler = null;
        IResource res = this.adaptContextObject();
        if (res != null && (manager = DesignTimeApplicationManager.getInstance(res.getProject())) != null) {
            viewHandler = manager.getViewHandler();
        }
        return viewHandler;
    }

    public IResource adaptContextObject() {
        if (this._contextObject instanceof IResource) {
            return (IResource)this._contextObject;
        }
        if (this._contextObject != null && this._contextObject.getAdapter(IResource.class) != null) {
            return (IResource)this._contextObject.getAdapter(IResource.class);
        }
        return null;
    }
}

