/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ActionSourceInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ActionSourceInfo2;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.EditableValueHolderInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.INamingContainerInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ValueHolderInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IConverterTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IValidatorTagElement;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.ComponentConstructionData;
import org.eclipse.jst.jsf.designtime.internal.view.DTComponentIntrospector;
import org.eclipse.jst.jsf.designtime.internal.view.ViewObjectConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLViewObjectConstructionStrategy
extends ViewObjectConstructionStrategy<Element> {
    private static final String GENERATED_ID = "_generatedId";
    private final ComponentConstructionData _constructionData;
    private final XMLViewDefnAdapter _adapter;

    public XMLViewObjectConstructionStrategy(XMLViewDefnAdapter adapter, ComponentConstructionData constructionData) {
        this._constructionData = constructionData;
        this._adapter = adapter;
    }

    @Override
    public ViewObject createViewObject(Element element, ITagElement tagElement) {
        try {
            if (tagElement instanceof IComponentTagElement) {
                ComponentTypeInfo typeInfo = ((IComponentTagElement)tagElement).getComponent();
                String id = null;
                if (!"javax.faces.ViewRoot".equals(typeInfo.getComponentType())) {
                    id = this.calculateId(element, this._constructionData);
                }
                return this.findBestComponent(element, id, typeInfo);
            }
            if (tagElement instanceof IConverterTagElement) {
                ConverterTypeInfo typeInfo = ((IConverterTagElement)tagElement).getConverter();
                return new ConverterDecorator(this._constructionData.getParent(), typeInfo);
            }
            if (tagElement instanceof IValidatorTagElement) {
                ValidatorTypeInfo typeInfo = ((IValidatorTagElement)tagElement).getValidator();
                return new ValidatorDecorator(this._constructionData.getParent(), typeInfo);
            }
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, "Error constructing view object");
        }
        return null;
    }

    private ComponentInfo findBestComponent(Element srcElement, String id, ComponentTypeInfo typeInfo) {
        Object bestComponent = null;
        ComponentInfo parent = this._constructionData.getParent();
        HashMap<String, String> initMap = new HashMap<String, String>();
        this.populateInitMap(initMap, srcElement, typeInfo);
        if (initMap.get("id") == null) {
            initMap.put("id", id);
        }
        bestComponent = typeInfo.isInstanceOf("javax.faces.component.UIInput") ? ComponentFactory.createUIInputInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIOutput") ? ComponentFactory.createUIOutputInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UICommand") ? ComponentFactory.createUICommandInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIData") ? ComponentFactory.createUIDataInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIForm") ? ComponentFactory.createUIFormInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : ComponentFactory.createComponentInfo((ComponentInfo)this._constructionData.getParent(), (ComponentTypeInfo)typeInfo, initMap)))));
        this.addTypeAdapters((ComponentInfo)bestComponent);
        return bestComponent;
    }

    private void populateInitMap(Map initMap, Element srcElement, ComponentTypeInfo typeInfo) {
        Map<String, JDTBeanProperty> properties = DTComponentIntrospector.getBeanProperties(typeInfo, this._constructionData.getProject());
        for (Map.Entry<String, JDTBeanProperty> propertyEntry : properties.entrySet()) {
            String value;
            String name = propertyEntry.getKey();
            Attr valueAttr = this._adapter.mapAttributeToComponent(srcElement, name);
            if (valueAttr == null || (value = valueAttr.getNodeValue()) == null) continue;
            Object convertedValue = this.convertFromString(value, propertyEntry.getValue());
            initMap.put(name, convertedValue);
        }
    }

    private Object convertFromString(String convertValue, JDTBeanProperty ofThisType) {
        String signature = ofThisType.getTypeSignature();
        Object result = null;
        switch (Signature.getTypeSignatureKind((String)signature)) {
            case 2: {
                result = this.convertFromBaseType(convertValue, signature);
                break;
            }
            case 1: {
                if ("Ljava.lang.String;".equals(signature)) {
                    result = convertValue;
                    break;
                }
                if (!"Ljava.lang.Object;".equals(signature)) break;
                result = convertValue;
            }
        }
        return result;
    }

    private Object convertFromBaseType(String convertValue, String signature) {
        if ("Z".equals(signature)) {
            return Boolean.valueOf(convertValue);
        }
        if ("I".equals(signature) || "B".equals(signature) || "S".equals(signature)) {
            return Integer.valueOf(convertValue);
        }
        if ("J".equals(convertValue)) {
            return Long.valueOf(convertValue);
        }
        return null;
    }

    private void addTypeAdapters(ComponentInfo component) {
        String[] interfaceNames = component.getComponentTypeInfo().getInterfaces();
        HashSet<String> interfaceNameSets = new HashSet<String>();
        String[] stringArray = interfaceNames;
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            interfaceNameSets.add(interfaceName);
            ++n2;
        }
        if (interfaceNameSets.contains("javax.faces.component.ActionSource")) {
            if (interfaceNameSets.contains("javax.faces.component.ActionSource2") && component.getAdapter(ComponentFactory.ACTION_SOURCE2) == null) {
                component.addAdapter(ComponentFactory.ACTION_SOURCE2, (Object)new ActionSourceInfo2(null, null, false, null));
            }
            if (component.getAdapter(ComponentFactory.ACTION_SOURCE) == null) {
                component.addAdapter(ComponentFactory.ACTION_SOURCE, (Object)new ActionSourceInfo(null, null, false));
            }
        }
        if (interfaceNameSets.contains("javax.faces.component.ValueHolder")) {
            if (interfaceNameSets.contains("javax.faces.component.EditableValueHolder") && component.getAdapter(ComponentFactory.EDITABLE_VALUE_HOLDER) == null) {
                component.addAdapter(ComponentFactory.EDITABLE_VALUE_HOLDER, (Object)new EditableValueHolderInfo(null, null, null, false, false, true, false, null, null, null));
            }
            if (component.getAdapter(ComponentFactory.VALUE_HOLDER) == null) {
                component.addAdapter(ComponentFactory.VALUE_HOLDER, (Object)new ValueHolderInfo(null, null, null));
            }
        }
        if (interfaceNameSets.contains("javax.faces.component.NamingContainer") && component.getAdapter(ComponentFactory.NAMING_CONTAINER) == null) {
            component.addAdapter(ComponentFactory.NAMING_CONTAINER, (Object)INamingContainerInfo.ADAPTER);
        }
    }

    protected String calculateId(Element element, ComponentConstructionData constructionData) {
        String id = this._adapter.getId(element);
        if (id != null) {
            return id;
        }
        String prefix = this._adapter.getGeneratedIdPrefix();
        return String.valueOf(prefix != null ? prefix : GENERATED_ID) + constructionData.increment();
    }

    public final ComponentConstructionData getConstructionData() {
        return this._constructionData;
    }
}

