/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.TypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IHandlerTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultTagTypeInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDComponentTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDConverterTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagHandlerElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDValidatorTagElement;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class DefaultJSPTagResolver
extends JSPTagResolvingStrategy {
    public static final String ID = "org.eclipse.jst.jsf.THISISTEMPORARY";
    public static final String DISPLAY_NAME = "Meta-data Driven Resolver";
    private final IProject _project;

    public DefaultJSPTagResolver(IProject project) {
        this._project = project;
    }

    public ITagElement resolve(TLDElementDeclaration elementDecl) {
        IProjectFacetVersion version = JSFAppConfigUtils.getProjectFacet(this._project);
        String versionAsString = version.getVersionString();
        JSFVersion jsfVersion = JSFVersion.valueOfString(versionAsString);
        DefaultTagTypeInfo defaultTagTypeInfo = new DefaultTagTypeInfo();
        TagIdentifier tagId = TagIdentifierFactory.createTLDTagWrapper(elementDecl);
        TypeInfo elementType = defaultTagTypeInfo.getTypeInfo(tagId, jsfVersion);
        if (elementType instanceof ComponentTypeInfo) {
            return new TLDComponentTagElement(elementDecl, (ComponentTypeInfo)elementType);
        }
        if (elementType instanceof ConverterTypeInfo) {
            return new TLDConverterTagElement(elementDecl, (ConverterTypeInfo)elementType);
        }
        if (elementType instanceof ValidatorTypeInfo) {
            return new TLDValidatorTagElement(elementDecl, (ValidatorTypeInfo)elementType);
        }
        if (elementType instanceof IHandlerTagElement.TagHandlerType) {
            return new TLDTagHandlerElement(elementDecl, (IHandlerTagElement.TagHandlerType)elementType);
        }
        if (defaultTagTypeInfo.isDefaultLib(tagId.getUri())) {
            return new TLDTagElement(elementDecl);
        }
        return null;
    }

    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

