/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDNamespace
extends Namespace {
    private final TLDDocument _tldDoc;
    private final ITagResolvingStrategy<TLDElementDeclaration, String> _tagResolver;
    private final ILock _tagMapReadWriteLock;
    private Map<String, ITagElement> _tags;

    public TLDNamespace(TLDDocument tldDoc, ITagResolvingStrategy<TLDElementDeclaration, String> tagResolver) {
        this._tldDoc = tldDoc;
        this._tagResolver = tagResolver;
        this._tagMapReadWriteLock = Job.getJobManager().newLock();
    }

    public final String getDisplayName() {
        String displayName = this._tldDoc.getDisplayName();
        if (displayName == null || "".equals(displayName.trim())) {
            displayName = this.getNSUri();
        }
        return displayName;
    }

    public final String getNSUri() {
        return this._tldDoc.getUri();
    }

    public boolean isInitialized() {
        int tagMapSize;
        int numTags = this._tldDoc.getElements().getLength();
        return numTags == (tagMapSize = this.getOrCreateMap(3).size());
    }

    private synchronized Map<String, ITagElement> getOrCreateMap(int mapSizeHint) {
        if (this._tags == null) {
            int initSize = (int)((float)mapSizeHint / 0.75f) + 1;
            this._tags = Collections.synchronizedMap(new HashMap(initSize));
        }
        return this._tags;
    }

    private ITagElement getOrCreateTagElement(String name, Map<String, ITagElement> tags) {
        ITagElement tagElement = null;
        this._tagMapReadWriteLock.acquire();
        try {
            CMNode cmNode;
            tagElement = tags.get(name);
            if (tagElement == null && (cmNode = this._tldDoc.getElements().getNamedItem(name)) instanceof TLDElementDeclaration) {
                tagElement = this._tagResolver.resolve((TLDElementDeclaration)cmNode);
                if (tagElement != this._tagResolver.getNotFoundIndicator()) {
                    tags.put(tagElement.getName(), tagElement);
                } else {
                    tagElement = null;
                }
            }
        }
        finally {
            this._tagMapReadWriteLock.release();
        }
        return tagElement;
    }

    public final ITagElement getViewElement(String name) {
        Map<String, ITagElement> tags = this.getOrCreateMap(3);
        return this.getOrCreateTagElement(name, tags);
    }

    public final Collection<? extends ITagElement> getViewElements() {
        return Collections.unmodifiableCollection(this.initializeTags().values());
    }

    public final boolean hasViewElements() {
        return this._tldDoc.getElements().getLength() > 0;
    }

    private final Map<String, ITagElement> initializeTags() {
        CMNamedNodeMap elementMap = this._tldDoc.getElements();
        Map<String, ITagElement> tags = this.getOrCreateMap(elementMap.getLength());
        int i = 0;
        while (i < elementMap.getLength()) {
            CMNode cmNode = elementMap.item(i);
            this.getOrCreateTagElement(cmNode.getNodeName(), tags);
            ++i;
        }
        return tags;
    }
}

