/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.analyzer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDERegistration;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IHandlerTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IJSFTagElement;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.core.internal.jem.BeanProxyUtil;
import org.eclipse.jst.jsf.designtime.internal.view.DTComponentIntrospector;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDComponentTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDConverterTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagHandlerElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDValidatorTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.analyzer.ServletBeanProxyContributor;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;

public final class TagAnalyzer {
    private static final String JAVAX_FACES_WEBAPP_CONVERTER_TAG = "javax.faces.webapp.ConverterTag";
    private static final String JAVAX_FACES_WEBAPP_CONVERTER_ELTAG = "javax.faces.webapp.ConverterELTag";
    private static final String JAVAX_FACES_WEBAPP_VALIDATOR_TAG = "javax.faces.webapp.ValidatorTag";
    private static final String JAVAX_FACES_WEBAPP_VALIDATOR_ELTAG = "javax.faces.webapp.ValidatorELTag";
    private static final String JAVAX_FACES_WEBAPP_FACET_TAG = "javax.faces.webapp.FacetTag";
    private static final String JAVAX_FACES_WEBAPP_ATTRIBUTE_TAG = "javax.faces.webapp.AttributeTag";
    private static final Set<String> COMPONENT_TAG_HANDLER_TYPES_JSF11;
    private static final Set<String> COMPONENT_TAG_HANDLER_TYPES_JSF12;
    private static final Set<String> CONVERTER_TAG_HANDLER_TYPES_JSF11;
    private static final Set<String> CONVERTER_TAG_HANDLER_TYPES_JSF12;
    private static final Set<String> VALIDATOR_TAG_HANDLER_TYPES_JSF11;
    private static final Set<String> VALIDATOR_TAG_HANDLER_TYPES_JSF12;
    private static final Set<String> FACET_TAG_HANDLER;
    private static final Set<String> ATTRIBUTE_TAG_HANDLER;
    private static final Set<String> ALL_HANDLER_TAGS;

    static {
        CONVERTER_TAG_HANDLER_TYPES_JSF11 = Collections.singleton(JAVAX_FACES_WEBAPP_CONVERTER_TAG);
        VALIDATOR_TAG_HANDLER_TYPES_JSF11 = Collections.singleton(JAVAX_FACES_WEBAPP_VALIDATOR_TAG);
        FACET_TAG_HANDLER = Collections.singleton(JAVAX_FACES_WEBAPP_FACET_TAG);
        ATTRIBUTE_TAG_HANDLER = Collections.singleton(JAVAX_FACES_WEBAPP_ATTRIBUTE_TAG);
        HashSet<String> set = new HashSet<String>(8);
        set.add("javax.faces.webapp.UIComponentTag");
        set.add("javax.faces.webapp.UIComponentBodyTag");
        COMPONENT_TAG_HANDLER_TYPES_JSF11 = Collections.unmodifiableSet(set);
        set = new HashSet(8);
        set.add("javax.faces.webapp.UIComponentTag");
        set.add("javax.faces.webapp.UIComponentBodyTag");
        set.add("javax.faces.webapp.UIComponentELTag");
        COMPONENT_TAG_HANDLER_TYPES_JSF12 = Collections.unmodifiableSet(set);
        set = new HashSet(8);
        set.add(JAVAX_FACES_WEBAPP_CONVERTER_TAG);
        set.add(JAVAX_FACES_WEBAPP_CONVERTER_ELTAG);
        CONVERTER_TAG_HANDLER_TYPES_JSF12 = Collections.unmodifiableSet(set);
        set = new HashSet(8);
        set.add(JAVAX_FACES_WEBAPP_VALIDATOR_TAG);
        set.add(JAVAX_FACES_WEBAPP_VALIDATOR_ELTAG);
        VALIDATOR_TAG_HANDLER_TYPES_JSF12 = Collections.unmodifiableSet(set);
        ALL_HANDLER_TAGS = new HashSet<String>();
        ALL_HANDLER_TAGS.addAll(FACET_TAG_HANDLER);
        ALL_HANDLER_TAGS.addAll(ATTRIBUTE_TAG_HANDLER);
    }

    public static String findComponentType(TLDElementDeclaration tldDecl, IProject project) {
        block3: {
            String className = tldDecl.getTagclass();
            IConfigurationContributor[] contributor = new IConfigurationContributor[]{new ServletBeanProxyContributor(project)};
            ProxyFactoryRegistry registry = TagAnalyzer.getProxyFactoryRegistry(contributor, project);
            if (registry != null) {
                IStandardBeanTypeProxyFactory factory = registry.getBeanTypeProxyFactory();
                IBeanTypeProxy classTypeProxy = factory.getBeanTypeProxy(className);
                BeanProxyUtil.BeanProxyWrapper classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(classTypeProxy);
                try {
                    classTypeWrapper.init();
                    return classTypeWrapper.callStringMethod("getComponentType");
                }
                catch (BeanProxyUtil.ProxyException tp) {
                    if (!JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) break block3;
                    JSFCoreTraceOptions.log("TagAnalyzer.findComponentType", tp);
                }
            }
        }
        return null;
    }

    public static String findConverterType(TLDElementDeclaration tldDecl, IProject project) {
        String className = tldDecl.getTagclass();
        IConfigurationContributor[] contributor = new IConfigurationContributor[]{new ServletBeanProxyContributor(project)};
        ProxyFactoryRegistry registry = TagAnalyzer.getProxyFactoryRegistry(contributor, project);
        if (registry != null) {
            IStandardBeanTypeProxyFactory factory = registry.getBeanTypeProxyFactory();
            IBeanTypeProxy classTypeProxy = factory.getBeanTypeProxy(className);
            try {
                IType type = JavaCore.create((IProject)project).findType(className);
                if (type != null && DTComponentIntrospector.isTypeNameInstanceOfClass(type, Collections.singleton(JAVAX_FACES_WEBAPP_CONVERTER_ELTAG))) {
                    return TagAnalyzer.findConverterType_InELTag(factory, classTypeProxy);
                }
                if (type != null && DTComponentIntrospector.isTypeNameInstanceOfClass(type, Collections.singleton(JAVAX_FACES_WEBAPP_CONVERTER_TAG))) {
                    return TagAnalyzer.findConverterType_InTag(factory, classTypeProxy);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private static String findConverterType_InTag(IStandardBeanTypeProxyFactory factory, IBeanTypeProxy classTypeProxy) {
        IBeanTypeProxy nullPageContextType = factory.getBeanTypeProxy("javax.servlet.jsp.PageContext");
        BeanProxyUtil.BeanProxyWrapper classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(classTypeProxy);
        try {
            classTypeWrapper.init();
            TagAnalyzer.callSuppressExceptions(classTypeWrapper, "setPageContext", new IBeanProxy[1], new IBeanTypeProxy[]{nullPageContextType});
            TagAnalyzer.callSuppressExceptions(classTypeWrapper, "doStartTag");
            IBeanTypeProxy converterProxy = factory.getBeanTypeProxy(JAVAX_FACES_WEBAPP_CONVERTER_TAG);
            String converterId = TagAnalyzer.getStringField(classTypeWrapper, converterProxy, "converterId");
            if (converterId != null) {
                return converterId;
            }
            converterId = TagAnalyzer.getStringField(classTypeWrapper, converterProxy, "_converterId");
            if (converterId != null) {
                return converterId;
            }
            converterId = TagAnalyzer.getStringField(classTypeWrapper, classTypeProxy, "CONVERTER_ID");
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
        return null;
    }

    private static String findConverterType_InELTag(IStandardBeanTypeProxyFactory factory, IBeanTypeProxy classTypeProxy) {
        BeanProxyUtil.BeanProxyWrapper classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(classTypeProxy);
        IBeanTypeProxy elExpressionType = factory.getBeanTypeProxy("javax.el.ValueExpression");
        if (elExpressionType == null) {
            return null;
        }
        try {
            classTypeWrapper.init();
            TagAnalyzer.callSuppressExceptions(classTypeWrapper, "doStartTag");
            IBeanProxy converterId = TagAnalyzer.getFieldInParents(classTypeWrapper, classTypeProxy, "CONVERTER_ID_EXPR");
            if (converterId != null) {
                converterId.getTypeProxy().isKindOf(elExpressionType);
                BeanProxyUtil.BeanProxyWrapper elExprValue = new BeanProxyUtil.BeanProxyWrapper(converterId.getTypeProxy());
                String value = elExprValue.callStringMethod("getExpressionString");
                System.out.println("Expression string:" + value);
            }
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
        return null;
    }

    public static String findValidatorType(TLDElementDeclaration tldDecl, IProject project) {
        String className = tldDecl.getTagclass();
        IConfigurationContributor[] contributor = new IConfigurationContributor[]{new ServletBeanProxyContributor(project)};
        ProxyFactoryRegistry registry = TagAnalyzer.getProxyFactoryRegistry(contributor, project);
        if (registry != null) {
            IStandardBeanTypeProxyFactory factory = registry.getBeanTypeProxyFactory();
            IBeanTypeProxy classTypeProxy = factory.getBeanTypeProxy(className);
            BeanProxyUtil.BeanProxyWrapper classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(classTypeProxy);
            IBeanTypeProxy converterProxy = factory.getBeanTypeProxy(JAVAX_FACES_WEBAPP_VALIDATOR_TAG);
            try {
                classTypeWrapper.init();
                TagAnalyzer.callSuppressExceptions(classTypeWrapper, "doStartTag");
                TagAnalyzer.callSuppressExceptions(classTypeWrapper, "createValidator");
                String validatorId = TagAnalyzer.getStringField(classTypeWrapper, converterProxy, "validatorId");
                if (validatorId != null) {
                    return validatorId;
                }
                validatorId = TagAnalyzer.getStringField(classTypeWrapper, converterProxy, "_validatorId");
                if (validatorId != null) {
                    return validatorId;
                }
                validatorId = TagAnalyzer.getStringField(classTypeWrapper, classTypeProxy, "VALIDATOR_ID");
                if (validatorId != null) {
                    return validatorId;
                }
            }
            catch (BeanProxyUtil.ProxyException proxyException) {}
        }
        return null;
    }

    private static IBeanProxy getFieldInParents(BeanProxyUtil.BeanProxyWrapper classTypeWrapper, IBeanTypeProxy typeProxy, String fieldName) {
        try {
            return classTypeWrapper.getFieldValueIncludeParents(fieldName, typeProxy);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {
            return null;
        }
    }

    private static String getStringField(BeanProxyUtil.BeanProxyWrapper classTypeWrapper, IBeanTypeProxy typeProxy, String fieldName) {
        try {
            return classTypeWrapper.getStringFieldValue(fieldName, typeProxy);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {
            return null;
        }
    }

    private static void callSuppressExceptions(BeanProxyUtil.BeanProxyWrapper classTypeWrapper, String methodName) {
        try {
            classTypeWrapper.call(methodName);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
    }

    private static void callSuppressExceptions(BeanProxyUtil.BeanProxyWrapper classTypeWrapper, String methodName, IBeanProxy[] args, IBeanTypeProxy[] argTypes) {
        try {
            classTypeWrapper.call(methodName, args, argTypes);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
    }

    private static ProxyFactoryRegistry getProxyFactoryRegistry(IConfigurationContributor[] configuration, IProject project) {
        try {
            return IDERegistration.startAnImplementation((IConfigurationContributor[])configuration, (boolean)false, (IProject)project, (String)project.getName(), (String)"org.eclipse.jst.jsf.core", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JSFCorePlugin.log("Error starting vm for project: " + project.getName(), e);
            return null;
        }
    }

    public static TLDTagElement createTLDTagElement(TLDElementDeclaration tldDecl, IProject project) {
        IType type;
        block12: {
            String typeName;
            IJavaProject javaProject;
            block11: {
                if (JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) {
                    JSFCoreTraceOptions.log(String.format("TagAnalyzer.createTLDTagElement: Start tld=%s, project=%s", tldDecl.getNodeName(), project.getName()));
                }
                javaProject = JavaCore.create((IProject)project);
                typeName = tldDecl.getTagclass();
                if (typeName != null && JavaConventions.validateJavaTypeName((String)typeName, (String)"1.3", (String)"1.3").getSeverity() != 4) break block11;
                JSFCorePlugin.log("Bad tag class name in " + tldDecl.toString(), new Throwable());
                return null;
            }
            type = javaProject.findType(typeName);
            if (type != null) break block12;
            if (JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) {
                JSFCoreTraceOptions.log("Type not found for: " + typeName);
            }
            return null;
        }
        try {
            IJSFTagElement.TagType tagType = TagAnalyzer.getJSFComponentTagType(type, project);
            if (JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) {
                JSFCoreTraceOptions.log(String.format("Tag class type=%s\nTag type=%s", type, tagType));
            }
            if (tagType == IJSFTagElement.TagType.COMPONENT) {
                return TagAnalyzer.createComponentTagElement(tldDecl, project);
            }
            if (tagType == IJSFTagElement.TagType.CONVERTER) {
                return TagAnalyzer.createConverterTagElement(tldDecl, project);
            }
            if (tagType == IJSFTagElement.TagType.VALIDATOR) {
                return TagAnalyzer.createValidatorTagElement(tldDecl, project);
            }
            if (tagType == IJSFTagElement.TagType.HANDLER) {
                return TagAnalyzer.createHandlerTagElement(tldDecl, type);
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log((Exception)((Object)jme), "Trying to get type for TLD");
        }
        return null;
    }

    public static TLDTagElement createComponentTagElement(TLDElementDeclaration tldDecl, IProject project) {
        ComponentTypeInfo typeInfo;
        String componentClass;
        String componentType = TagAnalyzer.findComponentType(tldDecl, project);
        if (componentType != null && (componentClass = DTComponentIntrospector.findComponentClass(componentType, project)) != null && !"".equals(componentClass.trim()) && (typeInfo = DTComponentIntrospector.getComponent(componentType, componentClass, project, new IConfigurationContributor[]{new ServletBeanProxyContributor(project)})) != null) {
            TLDComponentTagElement tagElement = new TLDComponentTagElement(tldDecl, typeInfo);
            return tagElement;
        }
        return null;
    }

    public static TLDTagElement createConverterTagElement(TLDElementDeclaration tldDecl, IProject project) {
        String converterClass;
        String converterId = TagAnalyzer.findConverterType(tldDecl, project);
        if (converterId != null && (converterClass = DTComponentIntrospector.findConverterClass(converterId, project)) != null && !"".equals(converterClass.trim())) {
            ConverterTypeInfo typeInfo = DTComponentIntrospector.getConverter(converterId, converterClass);
            TLDConverterTagElement tagElement = new TLDConverterTagElement(tldDecl, typeInfo);
            return tagElement;
        }
        return new TLDConverterTagElement(tldDecl, ConverterTypeInfo.UNKNOWN);
    }

    public static TLDTagElement createValidatorTagElement(TLDElementDeclaration tldDecl, IProject project) {
        String validatorClass;
        String validatorId = TagAnalyzer.findValidatorType(tldDecl, project);
        if (validatorId != null && (validatorClass = DTComponentIntrospector.findValidatorClass(validatorId, project)) != null && !"".equals(validatorClass.trim())) {
            ValidatorTypeInfo typeInfo = DTComponentIntrospector.getValidator(validatorId, validatorClass);
            TLDValidatorTagElement tagElement = new TLDValidatorTagElement(tldDecl, typeInfo);
            return tagElement;
        }
        return new TLDValidatorTagElement(tldDecl, ValidatorTypeInfo.UNKNOWN);
    }

    public static TLDTagElement createHandlerTagElement(TLDElementDeclaration tldDecl, IType type) {
        if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, FACET_TAG_HANDLER)) {
            return new TLDTagHandlerElement(tldDecl, IHandlerTagElement.TagHandlerType.FACET);
        }
        if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, ATTRIBUTE_TAG_HANDLER)) {
            return new TLDTagHandlerElement(tldDecl, IHandlerTagElement.TagHandlerType.ATTRIBUTE);
        }
        return null;
    }

    public static IJSFTagElement.TagType getJSFComponentTagType(IType type, IProject project) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) {
            JSFCoreTraceOptions.log(String.format("TagAnalyzer.getJSFComponentTagType: Determining Tag Type for type %s on project %s", type.getFullyQualifiedName(), project.toString()));
        }
        Set<String> componentTags = null;
        Set<String> converterTags = null;
        Set<String> validatorTags = null;
        JSFVersion jsfVersion = ServletBeanProxyContributor.getProjectVersion(project);
        if (jsfVersion == JSFVersion.V1_0 || jsfVersion == JSFVersion.V1_1) {
            componentTags = COMPONENT_TAG_HANDLER_TYPES_JSF11;
            converterTags = CONVERTER_TAG_HANDLER_TYPES_JSF11;
            validatorTags = VALIDATOR_TAG_HANDLER_TYPES_JSF11;
        } else if (jsfVersion == JSFVersion.V1_2) {
            componentTags = COMPONENT_TAG_HANDLER_TYPES_JSF12;
            converterTags = CONVERTER_TAG_HANDLER_TYPES_JSF12;
            validatorTags = VALIDATOR_TAG_HANDLER_TYPES_JSF12;
        }
        IJSFTagElement.TagType tagType = null;
        if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, componentTags)) {
            tagType = IJSFTagElement.TagType.COMPONENT;
        } else if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, converterTags)) {
            tagType = IJSFTagElement.TagType.CONVERTER;
        } else if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, validatorTags)) {
            tagType = IJSFTagElement.TagType.VALIDATOR;
        } else if (DTComponentIntrospector.isTypeNameInstanceOfClass(type, ALL_HANDLER_TAGS)) {
            tagType = IJSFTagElement.TagType.HANDLER;
        }
        if (JSFCoreTraceOptions.TRACE_JSPTAGINTROSPECTOR) {
            JSFCoreTraceOptions.log(String.format("TagAnalyzer.getJSFComponentTagType: tag type is %s", tagType != null ? tagType.toString() : "null"));
        }
        return tagType;
    }
}

