/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.w3c.dom.css.CSSValue;

public class FontWeightMeta
extends CSSPropertyMeta {
    public static final Integer NORMAL_WEIGHT = new Integer(400);
    private static final Integer BOLD_WEIGHT = new Integer(700);
    private static final String[] KEYWORDS = new String[]{"normal", "bold", "bolder", "lighter"};
    private Logger _log = PDPlugin.getLogger(FontWeightMeta.class);

    public FontWeightMeta() {
        super(true, NORMAL_WEIGHT);
    }

    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        String text = value.getCssText();
        String result = this.checkKeywordValues(text);
        if (result == null) {
            try {
                int i = Integer.parseInt(text);
                if (i < 100) {
                    i = 100;
                }
                if (i > 900) {
                    i = 900;
                }
                return new Integer(i);
            }
            catch (Exception ex) {
                this._log.error("Info.FontWeightMeta.0", (Throwable)ex);
                return NORMAL_WEIGHT;
            }
        }
        if ("normal".equals(result)) {
            return NORMAL_WEIGHT;
        }
        if ("bold".equals(result)) {
            return BOLD_WEIGHT;
        }
        if ("bolder".equals(result)) {
            return BOLD_WEIGHT;
        }
        if ("lighter".equals(result)) {
            int i = style.getParentStyle().getCSSFont().getWeight() - 100;
            if (i < 100) {
                i = 100;
            }
            if (i > 900) {
                i = 900;
            }
            return new Integer(i);
        }
        return NORMAL_WEIGHT;
    }
}

