/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.swt.graphics.Image;

public class TagImageManager {
    private static TagImageManager INSTANCE = null;
    private static final ImageDescriptor DEFAULT_SMALL_ICON = JSFUICommonPlugin.getDefault().getImageDescriptor("PD_Palette_Default.gif");
    private static final ImageDescriptor DEFAULT_LARGE_ICON = PDPlugin.getDefault().getImageDescriptor("palette/GENERIC/large/PD_Palette_Default.gif");
    private static final String TRAIT_ICON_SMALL = "small-icon";
    private static final String TRAIT_ICON_LARGE = "large-icon";

    public static synchronized TagImageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagImageManager();
        }
        return INSTANCE;
    }

    public Image getSmallIconImage(IProject project, String nsUri, String tagName) {
        Image image = null;
        Model model = this.getModel(project, nsUri);
        if (model != null) {
            ImageDescriptor imgDesc = this.getSmallIconImageDescriptor(model, tagName);
            image = this.getOrCreateImage(imgDesc);
        }
        return image;
    }

    public Image getLargeIconImage(IProject project, String nsUri, String tagName) {
        Image image = null;
        Model model = this.getModel(project, nsUri);
        if (model != null) {
            ImageDescriptor imgDesc = this.getLargeIconImageDescriptor(model, nsUri);
            image = this.getOrCreateImage(imgDesc);
        }
        return image;
    }

    private Image getOrCreateImage(ImageDescriptor imgDesc) {
        Image image = null;
        if (imgDesc != null) {
            image = PDPlugin.getDefault().getImageRegistry().get(imgDesc.toString());
            if (image == null) {
                image = imgDesc.createImage();
                PDPlugin.getDefault().getImageRegistry().put(imgDesc.toString(), image);
            } else if (image.isDisposed()) {
                PDPlugin.getDefault().getImageRegistry().remove(imgDesc.toString());
                image = imgDesc.createImage();
                PDPlugin.getDefault().getImageRegistry().put(imgDesc.toString(), image);
            }
        }
        return image;
    }

    private Model getModel(IProject project, String nsUri) {
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)nsUri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        return model;
    }

    private ImageDescriptor getSmallIconImageDescriptor(Model model, String tagName) {
        return this.getIconImageDescriptor(model, tagName, true);
    }

    private ImageDescriptor getLargeIconImageDescriptor(Model model, String tagName) {
        return this.getIconImageDescriptor(model, tagName, false);
    }

    private ImageDescriptor getIconImageDescriptor(Model model, String tagName, boolean small) {
        ImageDescriptor icon = null;
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"paletteInfos");
        if (trait != null) {
            PaletteInfos tags = (PaletteInfos)trait.getValue();
            for (PaletteInfo tag : tags.getInfos()) {
                if (!tag.getId().equalsIgnoreCase(tagName)) continue;
                IMetaDataSourceModelProvider sourceProvider = ((Trait)tag.eContainer().eContainer()).getSourceModelProvider();
                icon = small ? this.getImageDescriptorFromString(sourceProvider, tag.getSmallIcon(), DEFAULT_SMALL_ICON) : this.getImageDescriptorFromString(sourceProvider, tag.getLargeIcon(), DEFAULT_LARGE_ICON);
                break;
            }
        } else {
            for (Entity tagAsEntity : model.getChildEntities()) {
                if (!tagAsEntity.getId().equalsIgnoreCase(tagName)) continue;
                icon = small ? this.getImageDescriptorFromTagTraitValueAsString(tagAsEntity, TRAIT_ICON_SMALL, DEFAULT_SMALL_ICON) : this.getImageDescriptorFromTagTraitValueAsString(tagAsEntity, TRAIT_ICON_LARGE, DEFAULT_LARGE_ICON);
                break;
            }
        }
        return icon;
    }

    private ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc, ImageDescriptor defaultValue) {
        ImageDescriptor image = defaultValue;
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class);
        if (imageProvider != null) {
            image = imageProvider.getImageDescriptor(imgDesc);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptorFromTagTraitValueAsString(Entity entity, String key, ImageDescriptor defaultValue) {
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return this.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc, defaultValue);
        }
        return defaultValue;
    }
}

