/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.meta.IAttributeCellEditorFactory;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.OLDIValueType;
import org.eclipse.jst.pagedesigner.meta.internal.XXXCellEditorFacRegistryReader;
import org.eclipse.jst.pagedesigner.properties.celleditors.OLDCellEditorFactory;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Element;

public class XXXCellEditorFactoryRegistry {
    private static final Logger _log = PDPlugin.getLogger(XXXCellEditorFactoryRegistry.class);
    private static XXXCellEditorFactoryRegistry _instance;
    private Map _factoryMap = new HashMap();
    private List _defaultFactories = new ArrayList();

    public static XXXCellEditorFactoryRegistry getInstance() {
        if (_instance == null) {
            _instance = new XXXCellEditorFactoryRegistry();
        }
        return _instance;
    }

    private XXXCellEditorFactoryRegistry() {
        IAttributeCellEditorFactory[] facs = XXXCellEditorFacRegistryReader.getAllFactories();
        if (facs != null) {
            int i = 0;
            while (i < facs.length) {
                this.addCellEditorFactory(facs[i]);
                ++i;
            }
        }
        this.addCellEditorFactory(new OLDCellEditorFactory());
    }

    public void addCellEditorFactory(IAttributeCellEditorFactory fac) {
        String[] types = fac.getSupportedValueTypes();
        if (types == null || types.length == 0) {
            this._defaultFactories.add(fac);
        } else {
            int i = 0;
            while (i < types.length) {
                this._factoryMap.put(types[i].toUpperCase(), fac);
                ++i;
            }
        }
    }

    public CellEditor createCellEditor(Composite parent, IAttributeDescriptor attr, Element element) {
        String type = attr.getValueType();
        if (type == null || type.length() == 0) {
            return null;
        }
        type = type.toUpperCase();
        CellEditor result = null;
        IAttributeCellEditorFactory fac = (IAttributeCellEditorFactory)this._factoryMap.get(type);
        if (fac != null) {
            result = fac.createCellEditor(parent, attr, element);
        }
        if (result == null) {
            int i = 0;
            int size = this._defaultFactories.size();
            while (i < size) {
                result = ((IAttributeCellEditorFactory)this._defaultFactories.get(i)).createCellEditor(parent, attr, element);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public CellEditor createCellEditor(Composite parent, IPropertyPageDescriptor attr, Element element) {
        TextCellEditor result = null;
        result = new TextCellEditor(parent);
        return result;
    }

    public DialogField createDialogField(IAttributeDescriptor attr) {
        String type = attr.getValueType();
        if (type == null || type.length() == 0) {
            DialogField result = this.createTextDialogField(attr);
            result.setLabelText(String.valueOf(attr.getLabelString()) + ":");
            return result;
        }
        type = type.toUpperCase();
        DialogField result = null;
        IAttributeCellEditorFactory fac = (IAttributeCellEditorFactory)this._factoryMap.get(type);
        if (fac != null) {
            result = fac.createDialogField(attr);
        }
        if (result == null) {
            int i = 0;
            int size = this._defaultFactories.size();
            while (i < size) {
                result = ((IAttributeCellEditorFactory)this._defaultFactories.get(i)).createDialogField(attr);
                if (result != null) break;
                ++i;
            }
        }
        if (result == null) {
            result = this.createTextDialogField(attr);
        }
        if (!(result instanceof ISupportTextValue)) {
            result = this.createTextDialogField(attr);
        }
        result.setLabelText(String.valueOf(attr.getLabelString()) + ":");
        return result;
    }

    public DialogField createDialogField(IPropertyPageDescriptor attr) {
        String type = attr.getValueType();
        if (type == null || type.length() == 0) {
            DialogField result = this.createTextDialogField(attr);
            result.setLabelText(attr.getLabel());
            return result;
        }
        type = type.toUpperCase();
        DialogField result = null;
        result = this.createTextDialogField(attr);
        if (!(result instanceof ISupportTextValue)) {
            result = this.createTextDialogField(attr);
        }
        return result;
    }

    public DialogField createTextDialogField(IAttributeDescriptor attr) {
        StringDialogField field = new StringDialogField();
        field.setLabelText(attr.getLabelString());
        field.setRequired(attr.isRequired());
        field.setToolTip(attr.getDescription());
        return field;
    }

    public DialogField createTextDialogField(IPropertyPageDescriptor attr) {
        StringDialogField field = new StringDialogField();
        field.setLabelText(attr.getLabel());
        field.setRequired(attr.isRequired());
        field.setToolTip(attr.getDescription());
        return field;
    }

    public String[] getAllValueTypes() {
        HashSet<Object> valueTypes = new HashSet<Object>();
        for (IAttributeCellEditorFactory fac : this._factoryMap.values()) {
            String[] supportedTypes = fac.getSupportedValueTypes();
            if (supportedTypes == null) continue;
            int i = 0;
            while (i < supportedTypes.length) {
                valueTypes.add(supportedTypes[i]);
                ++i;
            }
        }
        Field[] fields = OLDIValueType.class.getFields();
        int i = 0;
        while (i < fields.length) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && fields[i].getType() == String.class) {
                try {
                    valueTypes.add(fields[i].get(null));
                }
                catch (IllegalArgumentException ex) {
                    _log.info("CellEditorFactoryRegistry.Info.2", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    _log.info("CellEditorFactoryRegistry.Info.3", (Throwable)ex);
                }
            }
            ++i;
        }
        String[] ret = new String[valueTypes.size()];
        valueTypes.toArray(ret);
        return ret;
    }
}

