/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldGroup;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.attrgroup.IElementContextable;
import org.eclipse.jst.pagedesigner.properties.internal.DefaultPropertyPageDescriptor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGroup
extends DialogFieldGroup {
    private static final Object KEY_ATTR = "KEY_ATTR";
    private List<DialogField> _dialogFields = null;
    private IDOMElement _ownerElement;
    private Entity _tagEntity;
    private List<String> _attrNames;
    private List<IPropertyPageDescriptor> _attrPDs;
    private String _uri;
    private String _tagName;

    public AttributeGroup(Entity tagEntity, List<String> attrNames) {
        this._tagEntity = tagEntity;
        this._attrNames = attrNames;
    }

    public AttributeGroup(String uri, String tagName, String[] attributeNames) {
        this._uri = uri;
        this._tagName = tagName;
        this._attrNames = attributeNames != null ? Arrays.asList(attributeNames) : new ArrayList<String>();
    }

    private List<IPropertyPageDescriptor> prepareDescriptors(Entity tagEntity, List<String> names) {
        ArrayList<IPropertyPageDescriptor> pds = new ArrayList<IPropertyPageDescriptor>();
        for (String attrName : names) {
            IPropertyPageDescriptor pd = this.getPD(tagEntity, attrName);
            if (pd == null) continue;
            pds.add(pd);
        }
        return pds;
    }

    private IPropertyPageDescriptor getPD(Entity tagEntity, String attrName) {
        IPropertyPageDescriptor pd = null;
        Entity attrEntity = TaglibDomainMetaDataQueryHelper.getEntity((Entity)tagEntity, (String)attrName);
        if (attrEntity != null) {
            List pds = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPropertyPageDescriptor.class, null, attrEntity);
            pd = pds != null && !pds.isEmpty() ? (IPropertyPageDescriptor)pds.get(0) : new DefaultPropertyPageDescriptor(tagEntity, attrEntity);
        }
        return pd;
    }

    protected Entity getTagEntity() {
        IStructuredDocumentContext context;
        if (this._tagEntity == null && this._ownerElement != null && (context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._ownerElement.getStructuredDocument(), 0)) != null) {
            String tagName;
            String uri = this._uri != null ? this._uri : IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context).getNode().getBaseURI();
            String string = tagName = this._tagName != null ? this._tagName : IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context).getNode().getNodeName();
            if (uri != null) {
                IProject project = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context).getProject();
                this._tagEntity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri), (String)tagName);
            }
        }
        return this._tagEntity;
    }

    public String getTagName() {
        if (this.getTagEntity() == null) {
            return this._tagName;
        }
        return this.getTagEntity().getId();
    }

    public String getURI() {
        if (this.getTagEntity() == null) {
            return this._uri;
        }
        return this.getTagEntity().getModel().getCurrentModelContext().getUri();
    }

    protected DialogField createDialogField(IPropertyPageDescriptor ppd) {
        return null;
    }

    public void initialize() {
        if (this._dialogFields == null) {
            this._dialogFields = new ArrayList<DialogField>();
            for (IPropertyPageDescriptor pd : this.getAttributePDs()) {
                DialogField field = this.createDialogField(pd);
                if (field == null) {
                    field = pd.getDialogFieldEditor();
                }
                field.putAttachedData(KEY_ATTR, (Object)pd);
                IDialogFieldApplyListener applyListener = this.getDialogFieldApplyListener(pd);
                if (applyListener == null) {
                    applyListener = this.getDefaultApplyListener();
                }
                field.setDialogFieldApplyListener(applyListener);
                IDialogFieldChangeListener changeListener = this.getDialogFieldChangeListener(pd);
                if (changeListener == null) {
                    changeListener = this.getDefaultChangeListener();
                }
                field.setDialogFieldChangeListener(changeListener);
                this._dialogFields.add(field);
            }
        }
    }

    private List<IPropertyPageDescriptor> getAttributePDs() {
        if (this._attrPDs == null) {
            this._attrPDs = this.prepareDescriptors(this.getTagEntity(), this._attrNames);
        }
        return this._attrPDs;
    }

    protected IDialogFieldApplyListener getDialogFieldApplyListener(IPropertyPageDescriptor ppd) {
        return null;
    }

    protected IDialogFieldChangeListener getDialogFieldChangeListener(IPropertyPageDescriptor ppd) {
        return null;
    }

    public void refreshData() {
        if (this._ownerElement == null) {
            return;
        }
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = this._dialogFields.get(i);
            ISupportTextValue textValue = (ISupportTextValue)field;
            IPropertyPageDescriptor attr = (IPropertyPageDescriptor)field.getAttachedData(KEY_ATTR);
            String attrName = attr.getAttributeName();
            String attrValue = this._ownerElement.getAttribute(attrName);
            textValue.setTextWithoutUpdate(attrValue);
            ++i;
        }
    }

    public IDOMElement getElement() {
        return this._ownerElement;
    }

    public void setElementContext(IDOMNode context, IDOMElement owner) {
        this._ownerElement = owner;
        this.initialize();
        if (context != null) {
            int i = 0;
            int size = this._dialogFields.size();
            while (i < size) {
                DialogField field = this._dialogFields.get(i);
                if (field instanceof IElementContextable) {
                    ((IElementContextable)field).setElementContext(context, owner);
                }
                ++i;
            }
        }
        this.refreshData();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        int numColumns;
        Composite top;
        if (toolkit == null) {
            top = new Composite(parent, 0);
            FillLayout fillLayout = new FillLayout(512);
            parent.setLayout((Layout)fillLayout);
        } else {
            top = toolkit.createComposite(parent, 0);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns = this.getNumColumns();
        top.setLayout((Layout)layout);
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = this._dialogFields.get(i);
            field.doFillIntoGrid(toolkit, top, numColumns);
            ++i;
        }
        DialogField maxColumnField = null;
        int maxColumn = 0;
        int i2 = 0;
        int size2 = this._dialogFields.size();
        while (i2 < size2) {
            DialogField field = this._dialogFields.get(i2);
            int c = field.getNumberOfControls();
            if (c > maxColumn) {
                maxColumn = c;
                maxColumnField = field;
            }
            ++i2;
        }
        if (maxColumnField != null) {
            maxColumnField.handleGrabHorizontal();
        }
    }

    public int getNumColumns() {
        int columns = 1;
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = this._dialogFields.get(i);
            columns = Math.max(columns, field.getNumberOfControls());
            ++i;
        }
        return columns;
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public DialogField[] getDialogFields() {
        this.initialize();
        DialogField[] ret = new DialogField[this._dialogFields.size()];
        this._dialogFields.toArray(ret);
        return ret;
    }

    public DialogField getDialogField(String attrName) {
        this.initialize();
        int i = 0;
        int size = this._dialogFields.size();
        while (i < size) {
            DialogField field = this._dialogFields.get(i);
            IPropertyPageDescriptor attr = this.getPropertyDescriptor(field);
            if (attr != null && attr.getAttributeName().equals(attrName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public IPropertyPageDescriptor getPropertyDescriptor(DialogField field) {
        Object obj = field.getAttachedData(KEY_ATTR);
        if (obj instanceof IPropertyPageDescriptor) {
            return (IPropertyPageDescriptor)obj;
        }
        return null;
    }

    public void reset() {
        if (this._dialogFields != null) {
            for (DialogField field : this._dialogFields) {
                field.setDialogFieldApplyListener(null);
                field.setDialogFieldChangeListener(null);
            }
            this._dialogFields = null;
        }
    }

    void setTagEntity(Entity tagEntity) {
        this._tagEntity = tagEntity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AttributeGroup: uri=");
        buf.append("\r\r").append(this.getURI()).append("\r\rtag=").append(this.getTagName());
        buf.append("\r\rAttrs: ");
        int i = 0;
        while (i < this._attrNames.size()) {
            String attr = this._attrNames.get(i);
            buf.append(attr);
            if (i < this._attrNames.size()) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }
}

