/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.PathUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.ui.IEditorInput;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewUtil {
    private static Logger _log = PDPlugin.getLogger(PreviewUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String WEBROOT_PATH = null;
    private static IFile CURRENT_FILE = null;
    private static PropertyResourceBundle BUNDLE = null;
    private static Map BUNDLE_MAP = null;
    private static String VAR = null;
    private static Map _taglibMap = new HashMap();

    public static final PropertyResourceBundle getBUNDLE() {
        return BUNDLE;
    }

    public static final void setBUNDLE(PropertyResourceBundle bundle) {
        BUNDLE = bundle;
    }

    public static final Map getBUNDLE_MAP() {
        return BUNDLE_MAP;
    }

    public static final void setBUNDLE_MAP(Map bundle_map) {
        BUNDLE_MAP = bundle_map;
    }

    public static final String getVAR() {
        return VAR;
    }

    public static final void setVAR(String var) {
        VAR = var;
    }

    public static Map getTaglibMap() {
        return _taglibMap;
    }

    public static void setTaglibMap(Map map) {
        _taglibMap = map;
    }

    public static String getAttributesAsString(Map map) {
        return PreviewUtil.getAttributesAsString(map, true);
    }

    public static String getPathFromURI(String uri) {
        IPath path;
        IContainer con;
        if (uri == null) {
            return uri;
        }
        if (uri.startsWith("/")) {
            return String.valueOf(WEBROOT_PATH) + uri;
        }
        IFile curFile = CURRENT_FILE;
        if (curFile != null && (con = curFile.getParent()) != null && (path = con.getLocation()) != null) {
            File file;
            String aPath = String.valueOf(path.toString()) + File.separator + uri;
            aPath = aPath.replace('/', File.separatorChar);
            if ((aPath = aPath.replace('\\', File.separatorChar)).endsWith(File.separator)) {
                aPath = String.valueOf(aPath) + File.separator;
            }
            if ((file = new File(aPath)).exists()) {
                return aPath;
            }
            return uri;
        }
        return null;
    }

    public static String getValueOFEP(String attrValue) {
        if (attrValue != null && attrValue.startsWith("#{")) {
            String value = null;
            int i = attrValue.lastIndexOf(".");
            if (i > 0) {
                String key = attrValue.substring(i + 1, attrValue.length() - 1).trim();
                String bundleVariable = attrValue.substring(2, i).trim();
                if (BUNDLE_MAP == null) {
                    return attrValue;
                }
                PropertyResourceBundle bundle = (PropertyResourceBundle)BUNDLE_MAP.get(bundleVariable);
                if (bundle != null) {
                    try {
                        value = bundle.getString(key);
                        if (value != null) {
                            return value;
                        }
                        return attrValue;
                    }
                    catch (MissingResourceException e1) {
                        _log.info("PreviewUtil.Error.0", (Throwable)e1);
                    }
                }
            }
        }
        return attrValue;
    }

    private static String getAttributesAsString(Map<String, String> map, boolean flag) {
        if (map == null) {
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            attrValue = PreviewUtil.getValueOFEP(attrValue);
            if (("src".equalsIgnoreCase(attrName) || "href".equalsIgnoreCase(attrName) || "uri".equalsIgnoreCase(attrName) || "binding".equalsIgnoreCase(attrName) || "page".equalsIgnoreCase(attrName)) && WEBROOT_PATH != null && attrValue != null && !attrValue.startsWith("http") && !attrValue.startsWith("file")) {
                attrValue = PreviewUtil.getPathFromURI(attrValue);
            }
            if (attrValue == null) continue;
            stringbuffer.append(" ").append(attrName);
            if (attrValue.indexOf(34) != -1) {
                StringBuffer stringbuffer1 = new StringBuffer();
                int j = 0;
                while (j < attrValue.length()) {
                    char c = attrValue.charAt(j);
                    if (c != '\"') {
                        stringbuffer1.append(c);
                    }
                    ++j;
                }
                attrValue = stringbuffer1.toString();
            }
            if (attrValue != null && attrValue.startsWith("#{")) {
                attrValue = "";
            }
            stringbuffer.append("=\"").append(attrValue).append('\"');
        }
        return stringbuffer.toString();
    }

    public static Map getAttributeMap(NamedNodeMap nodeMap) {
        if (nodeMap != null) {
            int len = nodeMap.getLength();
            HashMap<String, String> map = new HashMap<String, String>();
            int i = 0;
            while (i < len) {
                Node node = nodeMap.item(i);
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if (name != null && !name.trim().equalsIgnoreCase("") && value != null) {
                    map.put(name, value);
                }
                ++i;
            }
            return map;
        }
        return null;
    }

    public static File toFile(StringBuffer result, IEditorInput editorInput) {
        try {
            File file = File.createTempFile("previewtmp", ".html");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream((OutputStream)fos, true, "UTF-8");
            ps.print(result.toString());
            ps.close();
            fos.close();
            return file;
        }
        catch (IOException e) {
            _log.info("PreviewUtil.Error.3", (Throwable)e);
            return null;
        }
    }

    public static void previewNode(Node node) {
        int n;
        int i;
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return;
        }
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap != null) {
            i = 0;
            n = attrMap.getLength();
            while (i < n) {
                Node attrNode = attrMap.item(i);
                if (attrNode instanceof Attr) {
                    Attr attr = (Attr)attrNode;
                    attr.setNodeValue(PreviewUtil.getValueOFEP(attr.getNodeValue()));
                    attr.setNodeValue(PathUtil.convertToAbsolutePath((String)attr.getNodeValue(), null));
                }
                ++i;
            }
        }
        i = 0;
        n = nodeList.getLength();
        while (i < n) {
            PreviewUtil.previewNode(nodeList.item(i));
            ++i;
        }
    }
}

